/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.SoftHashMap;
import gnu.trove.TObjectIntHashMap;
import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;

public abstract class InspectionTreeTailRenderer {
    private static final int MAX_LEVEL_TYPES = 5;
    private static final JBColor TREE_RED = new JBColor(new Color(184, 66, 55), new Color(204, 102, 102));
    private static final JBColor TREE_GRAY = new JBColor((Color)Gray._153, (Color)Gray._117);
    private final Map<HighlightSeverity, String> myPluralizedSeverityNames = new SoftHashMap();
    private final Map<HighlightSeverity, String> myUnpluralizedSeverityNames = new SoftHashMap();
    private final TObjectIntHashMap<HighlightDisplayLevel> myItemCounter = new TObjectIntHashMap();
    private final SeverityRegistrar myRegistrar;
    private final GlobalInspectionContextImpl myContext;

    public InspectionTreeTailRenderer(GlobalInspectionContextImpl context) {
        this.myRegistrar = SeverityRegistrar.getSeverityRegistrar(context.getProject());
        this.myContext = context;
    }

    public void appendTailText(InspectionTreeNode node) {
        this.appendText("  ");
        String customizedTailText = node.getTailText();
        if (customizedTailText != null) {
            this.appendText("  ");
            this.appendText(customizedTailText, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else {
            this.myItemCounter.clear();
            node.visitProblemSeverities(this.myItemCounter);
            if (this.myItemCounter.size() > 5) {
                this.appendText(InspectionsBundle.message((String)"inspection.problem.descriptor.count", (Object[])new Object[]{InspectionTreeTailRenderer.sum(this.myItemCounter.getValues()), SimpleTextAttributes.GRAYED_ATTRIBUTES}));
            } else {
                Object[] levels = this.myItemCounter.keys();
                Arrays.sort(levels, Comparator.comparing(l -> ((HighlightDisplayLevel)l).getSeverity()).reversed());
                for (Object o : levels) {
                    HighlightDisplayLevel level = (HighlightDisplayLevel)o;
                    int occur = this.myItemCounter.get((Object)level);
                    SimpleTextAttributes attrs = SimpleTextAttributes.GRAY_ATTRIBUTES;
                    attrs = attrs.derive(-1, (Color)(level == HighlightDisplayLevel.ERROR && !this.myContext.getUIOptions().GROUP_BY_SEVERITY ? TREE_RED : TREE_GRAY), null, null);
                    this.appendText(occur + " " + this.getPresentableName(level, occur > 1) + " ", attrs);
                }
            }
        }
    }

    protected abstract void appendText(String var1, SimpleTextAttributes var2);

    protected abstract void appendText(String var1);

    private String getPresentableName(HighlightDisplayLevel level, boolean pluralize) {
        HighlightSeverity severity = level.getSeverity();
        if (pluralize) {
            String name2 = this.myPluralizedSeverityNames.get(severity);
            if (name2 == null) {
                String lowerCaseName = level.getName().toLowerCase(Locale.ENGLISH);
                name2 = this.myRegistrar.isDefaultSeverity(severity) ? StringUtil.pluralize((String)lowerCaseName) : lowerCaseName;
                this.myPluralizedSeverityNames.put(severity, name2);
            }
            return name2;
        }
        String name3 = this.myUnpluralizedSeverityNames.get(severity);
        if (name3 == null) {
            name3 = level.getName().toLowerCase(Locale.ENGLISH);
            this.myUnpluralizedSeverityNames.put(severity, name3);
        }
        return name3;
    }

    private static int sum(int[] numbers) {
        int result2 = 0;
        for (int number : numbers) {
            result2 += number;
        }
        return result2;
    }
}

