/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.varScopeCanBeNarrowed.BaseConvertToLocalQuickFix;
import com.intellij.codeInspection.varScopeCanBeNarrowed.ParameterCanBeLocalInspectionBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.NotNullFunction;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterCanBeLocalInspection
extends ParameterCanBeLocalInspectionBase {
    @Override
    protected ConvertParameterToLocalQuickFix createFix() {
        return new ConvertParameterToLocalQuickFix();
    }

    public static class ConvertParameterToLocalQuickFix
    extends BaseConvertToLocalQuickFix<PsiParameter> {
        @Override
        protected PsiParameter getVariable(@NotNull ProblemDescriptor descriptor) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "getVariable"));
            }
            return (PsiParameter)descriptor.getPsiElement().getParent();
        }

        @Override
        protected PsiElement applyChanges(final @NotNull Project project2, final @NotNull String localName, final @Nullable PsiExpression initializer, final @NotNull PsiParameter parameter, final @NotNull Collection<PsiReference> references, boolean delete, final @NotNull NotNullFunction<PsiDeclarationStatement, PsiElement> action) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "applyChanges"));
            }
            if (localName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localName", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "applyChanges"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "applyChanges"));
            }
            if (references == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "applyChanges"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "applyChanges"));
            }
            PsiElement scope = parameter.getDeclarationScope();
            if (scope instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                ArrayList<ParameterInfoImpl> info = new ArrayList<ParameterInfoImpl>();
                for (int i2 = 0; i2 < parameters2.length; ++i2) {
                    PsiParameter psiParameter = parameters2[i2];
                    if (psiParameter == parameter) continue;
                    info.add(new ParameterInfoImpl(i2, psiParameter.getName(), psiParameter.getType()));
                }
                ParameterInfoImpl[] newParams = info.toArray(new ParameterInfoImpl[info.size()]);
                String visibilityModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
                PsiType returnType = method.getReturnType();
                JavaChangeInfoImpl changeInfo = new JavaChangeInfoImpl(visibilityModifier, method, method.getName(), returnType != null ? CanonicalTypes.createTypeWrapper(returnType) : null, newParams, null, false, ContainerUtil.newHashSet(), ContainerUtil.newHashSet());
                ChangeSignatureProcessor cp = new ChangeSignatureProcessor(project2, changeInfo){

                    @Override
                    protected void performRefactoring(@NotNull UsageInfo[] usages) {
                        if (usages == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix$1", "performRefactoring"));
                        }
                        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
                        PsiElement newDeclaration = this.moveDeclaration(elementFactory, localName, parameter, initializer, (NotNullFunction<PsiDeclarationStatement, PsiElement>)action, references);
                        super.performRefactoring(usages);
                        BaseConvertToLocalQuickFix.positionCaretToDeclaration(project2, newDeclaration.getContainingFile(), newDeclaration);
                    }
                };
                cp.run();
            }
            return null;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Override
        @NotNull
        protected String suggestLocalName(@NotNull Project project2, @NotNull PsiParameter parameter, @NotNull PsiCodeBlock scope) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "suggestLocalName"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "suggestLocalName"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "suggestLocalName"));
            }
            String string = parameter.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "suggestLocalName"));
            }
            return string;
        }
    }
}

