/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CompilerIOUtil {
    private static final ThreadLocal<byte[]> myBuffer = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[1024];
        }
    };

    private CompilerIOUtil() {
    }

    public static String readString(DataInput stream) throws IOException {
        int length = stream.readInt();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        char[] chars = new char[length];
        int charsRead = 0;
        byte[] buff = myBuffer.get();
        while (charsRead < length) {
            int bytesRead = Math.min((length - charsRead) * 2, buff.length);
            stream.readFully(buff, 0, bytesRead);
            for (int i2 = 0; i2 < bytesRead; i2 += 2) {
                chars[charsRead++] = (char)((buff[i2] << 8) + (buff[i2 + 1] & 0xFF));
            }
        }
        return new String(chars);
    }

    public static void writeString(String s, DataOutput stream) throws IOException {
        if (s == null) {
            stream.writeInt(-1);
            return;
        }
        int len = s.length();
        stream.writeInt(len);
        if (len == 0) {
            return;
        }
        int charsWritten = 0;
        byte[] buff = myBuffer.get();
        while (charsWritten < len) {
            int bytesWritten = Math.min((len - charsWritten) * 2, buff.length);
            for (int i2 = 0; i2 < bytesWritten; i2 += 2) {
                char aChar = s.charAt(charsWritten++);
                buff[i2] = (byte)(aChar >>> 8 & 0xFF);
                buff[i2 + 1] = (byte)(aChar & 0xFF);
            }
            stream.write(buff, 0, bytesWritten);
        }
    }
}

