/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.compiler.CompileTaskBean;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.FileProcessingCompilerAdapterTask;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.compiler.impl.OneProjectItemCompileScope;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerFactory;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.SourceInstrumentingCompiler;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.NetUtils;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.impl.java.JavacCompilerTool;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ExternalJavacManager;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;

public class CompilerManagerImpl
extends CompilerManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.CompilerManagerImpl");
    private final Project myProject;
    private final List<Compiler> myCompilers = new ArrayList<Compiler>();
    private final List<CompileTask> myBeforeTasks = new ArrayList<CompileTask>();
    private final List<CompileTask> myAfterTasks = new ArrayList<CompileTask>();
    private final Set<FileType> myCompilableTypes = new HashSet<FileType>();
    private final CompilationStatusListener myEventPublisher;
    private final Semaphore myCompilationSemaphore = new Semaphore(1, true);
    private final Set<ModuleType> myValidationDisabledModuleTypes = new HashSet<ModuleType>();
    private final Set<LocalFileSystem.WatchRequest> myWatchRoots;
    private volatile ExternalJavacManager myExternalJavacManager;
    private final Map<CompilationStatusListener, MessageBusConnection> myListenerAdapters = new HashMap<CompilationStatusListener, MessageBusConnection>();

    public CompilerManagerImpl(Project project2, MessageBus messageBus) {
        this.myProject = project2;
        this.myEventPublisher = (CompilationStatusListener)messageBus.syncPublisher(CompilerTopics.COMPILATION_STATUS);
        for (Compiler compiler : (Compiler[])Extensions.getExtensions((ExtensionPointName)Compiler.EP_NAME, (AreaInstance)this.myProject)) {
            this.addCompiler(compiler);
        }
        for (Compiler compiler : (CompilerFactory[])Extensions.getExtensions((ExtensionPointName)CompilerFactory.EP_NAME, (AreaInstance)this.myProject)) {
            Compiler[] compilers;
            for (Compiler compiler2 : compilers = compiler.createCompilers((CompilerManager)this)) {
                this.addCompiler(compiler2);
            }
        }
        for (Compiler compiler : (InspectionValidator[])Extensions.getExtensions((ExtensionPointName)InspectionValidator.EP_NAME, (AreaInstance)this.myProject)) {
            this.addCompiler((Compiler)new InspectionValidatorWrapper(this, InspectionManager.getInstance((Project)project2), InspectionProjectProfileManager.getInstance(project2), PsiDocumentManager.getInstance((Project)project2), PsiManager.getInstance((Project)project2), (InspectionValidator)compiler));
        }
        this.addCompilableFileType((FileType)StdFileTypes.JAVA);
        File projectGeneratedSrcRoot = CompilerPaths.getGeneratedDataDirectory((Project)project2);
        projectGeneratedSrcRoot.mkdirs();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        this.myWatchRoots = lfs.addRootsToWatch(Collections.singletonList(FileUtil.toCanonicalPath((String)projectGeneratedSrcRoot.getPath())), true);
        Disposer.register((Disposable)project2, () -> {
            ExternalJavacManager manager = this.myExternalJavacManager;
            this.myExternalJavacManager = null;
            if (manager != null) {
                manager.stop();
            }
            lfs.removeWatchedRoots(this.myWatchRoots);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                FileUtil.delete((File)CompilerPaths.getCompilerSystemDirectory((Project)project2));
            }
        });
    }

    public Semaphore getCompilationSemaphore() {
        return this.myCompilationSemaphore;
    }

    public boolean isCompilationActive() {
        return this.myCompilationSemaphore.availablePermits() == 0;
    }

    public final void addCompiler(@NotNull Compiler compiler) {
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "com/intellij/compiler/CompilerManagerImpl", "addCompiler"));
        }
        this.myCompilers.add(compiler);
        if (compiler instanceof SourceInstrumentingCompiler) {
            this.addBeforeTask(new FileProcessingCompilerAdapterTask((FileProcessingCompiler)compiler));
        } else if (compiler instanceof Validator) {
            this.addAfterTask(new FileProcessingCompilerAdapterTask((FileProcessingCompiler)compiler));
        }
    }

    @Deprecated
    public void addTranslatingCompiler(@NotNull TranslatingCompiler compiler, Set<FileType> inputTypes, Set<FileType> outputTypes) {
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "com/intellij/compiler/CompilerManagerImpl", "addTranslatingCompiler"));
        }
    }

    public final void removeCompiler(@NotNull Compiler compiler) {
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "com/intellij/compiler/CompilerManagerImpl", "removeCompiler"));
        }
        for (List tasks : Arrays.asList(this.myBeforeTasks, this.myAfterTasks)) {
            tasks.removeIf(task -> {
                if (compiler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "com/intellij/compiler/CompilerManagerImpl", "lambda$removeCompiler$1"));
                }
                return task instanceof FileProcessingCompilerAdapterTask && ((FileProcessingCompilerAdapterTask)task).getCompiler() == compiler;
            });
        }
    }

    @NotNull
    public <T extends Compiler> T[] getCompilers(@NotNull Class<T> compilerClass) {
        if (compilerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerClass", "com/intellij/compiler/CompilerManagerImpl", "getCompilers"));
        }
        Compiler[] compilerArray = this.getCompilers(compilerClass, CompilerFilter.ALL);
        if (compilerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/CompilerManagerImpl", "getCompilers"));
        }
        return compilerArray;
    }

    @NotNull
    public <T extends Compiler> T[] getCompilers(@NotNull Class<T> compilerClass, CompilerFilter filter) {
        if (compilerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerClass", "com/intellij/compiler/CompilerManagerImpl", "getCompilers"));
        }
        ArrayList<Compiler> compilers = new ArrayList<Compiler>(this.myCompilers.size());
        for (Compiler item : this.myCompilers) {
            if (!compilerClass.isAssignableFrom(item.getClass()) || !filter.acceptCompiler(item)) continue;
            compilers.add(item);
        }
        Compiler[] array = (Compiler[])Array.newInstance(compilerClass, compilers.size());
        Compiler[] compilerArray = compilers.toArray(array);
        if (compilerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/CompilerManagerImpl", "getCompilers"));
        }
        return compilerArray;
    }

    public void addCompilableFileType(@NotNull FileType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/compiler/CompilerManagerImpl", "addCompilableFileType"));
        }
        this.myCompilableTypes.add(type2);
    }

    public void removeCompilableFileType(@NotNull FileType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/compiler/CompilerManagerImpl", "removeCompilableFileType"));
        }
        this.myCompilableTypes.remove(type2);
    }

    public boolean isCompilableFileType(@NotNull FileType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/compiler/CompilerManagerImpl", "isCompilableFileType"));
        }
        return this.myCompilableTypes.contains(type2);
    }

    public final void addBeforeTask(@NotNull CompileTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/compiler/CompilerManagerImpl", "addBeforeTask"));
        }
        this.myBeforeTasks.add(task);
    }

    public final void addAfterTask(@NotNull CompileTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/compiler/CompilerManagerImpl", "addAfterTask"));
        }
        this.myAfterTasks.add(task);
    }

    @NotNull
    public CompileTask[] getBeforeTasks() {
        CompileTask[] compileTaskArray = this.getCompileTasks(this.myBeforeTasks, CompileTaskBean.CompileTaskExecutionPhase.BEFORE);
        if (compileTaskArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/CompilerManagerImpl", "getBeforeTasks"));
        }
        return compileTaskArray;
    }

    private CompileTask[] getCompileTasks(List<CompileTask> taskList, CompileTaskBean.CompileTaskExecutionPhase phase) {
        ArrayList<CompileTask> beforeTasks = new ArrayList<CompileTask>(taskList);
        for (CompileTaskBean extension : (CompileTaskBean[])CompileTaskBean.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            if (extension.myExecutionPhase != phase) continue;
            beforeTasks.add(extension.getTaskInstance());
        }
        return beforeTasks.toArray(new CompileTask[beforeTasks.size()]);
    }

    @NotNull
    public CompileTask[] getAfterTasks() {
        CompileTask[] compileTaskArray = this.getCompileTasks(this.myAfterTasks, CompileTaskBean.CompileTaskExecutionPhase.AFTER);
        if (compileTaskArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/CompilerManagerImpl", "getAfterTasks"));
        }
        return compileTaskArray;
    }

    public void compile(@NotNull VirtualFile[] files, CompileStatusNotification callback) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/compiler/CompilerManagerImpl", "compile"));
        }
        this.compile(this.createFilesCompileScope(files), callback);
    }

    public void compile(@NotNull Module module2, CompileStatusNotification callback) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/compiler/CompilerManagerImpl", "compile"));
        }
        new CompileDriver(this.myProject).compile(this.createModuleCompileScope(module2, false), new ListenerNotificator(callback));
    }

    public void compile(@NotNull CompileScope scope, CompileStatusNotification callback) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/compiler/CompilerManagerImpl", "compile"));
        }
        new CompileDriver(this.myProject).compile(scope, new ListenerNotificator(callback));
    }

    public void make(CompileStatusNotification callback) {
        new CompileDriver(this.myProject).make(this.createProjectCompileScope(this.myProject), new ListenerNotificator(callback));
    }

    public void make(@NotNull Module module2, CompileStatusNotification callback) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/compiler/CompilerManagerImpl", "make"));
        }
        new CompileDriver(this.myProject).make(this.createModuleCompileScope(module2, true), new ListenerNotificator(callback));
    }

    public void make(@NotNull Project project2, @NotNull Module[] modules, CompileStatusNotification callback) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/CompilerManagerImpl", "make"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/compiler/CompilerManagerImpl", "make"));
        }
        new CompileDriver(this.myProject).make(this.createModuleGroupCompileScope(project2, modules, true), new ListenerNotificator(callback));
    }

    public void make(@NotNull CompileScope scope, CompileStatusNotification callback) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/compiler/CompilerManagerImpl", "make"));
        }
        new CompileDriver(this.myProject).make(scope, new ListenerNotificator(callback));
    }

    public void make(@NotNull CompileScope scope, CompilerFilter filter, @Nullable CompileStatusNotification callback) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/compiler/CompilerManagerImpl", "make"));
        }
        CompileDriver compileDriver = new CompileDriver(this.myProject);
        compileDriver.setCompilerFilter(filter);
        compileDriver.make(scope, new ListenerNotificator(callback));
    }

    public boolean isUpToDate(@NotNull CompileScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/compiler/CompilerManagerImpl", "isUpToDate"));
        }
        return new CompileDriver(this.myProject).isUpToDate(scope);
    }

    public void rebuild(CompileStatusNotification callback) {
        new CompileDriver(this.myProject).rebuild(new ListenerNotificator(callback));
    }

    public void executeTask(@NotNull CompileTask task, @NotNull CompileScope scope, String contentName, Runnable onTaskFinished) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/compiler/CompilerManagerImpl", "executeTask"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/compiler/CompilerManagerImpl", "executeTask"));
        }
        CompileDriver compileDriver = new CompileDriver(this.myProject);
        compileDriver.executeCompileTask(task, scope, contentName, onTaskFinished);
    }

    public void addCompilationStatusListener(@NotNull CompilationStatusListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/compiler/CompilerManagerImpl", "addCompilationStatusListener"));
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        this.myListenerAdapters.put(listener2, connection);
        connection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)listener2);
    }

    public void addCompilationStatusListener(@NotNull CompilationStatusListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/compiler/CompilerManagerImpl", "addCompilationStatusListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/compiler/CompilerManagerImpl", "addCompilationStatusListener"));
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect(parentDisposable);
        connection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)listener2);
    }

    public void removeCompilationStatusListener(@NotNull CompilationStatusListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/compiler/CompilerManagerImpl", "removeCompilationStatusListener"));
        }
        MessageBusConnection connection = this.myListenerAdapters.remove(listener2);
        if (connection != null) {
            connection.disconnect();
        }
    }

    public boolean isExcludedFromCompilation(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/compiler/CompilerManagerImpl", "isExcludedFromCompilation"));
        }
        return CompilerConfiguration.getInstance((Project)this.myProject).isExcludedFromCompilation(file2);
    }

    @NotNull
    public CompileScope createFilesCompileScope(@NotNull VirtualFile[] files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/compiler/CompilerManagerImpl", "createFilesCompileScope"));
        }
        CompileScope[] scopes = new CompileScope[files.length];
        for (int i = 0; i < files.length; ++i) {
            scopes[i] = new OneProjectItemCompileScope(this.myProject, files[i]);
        }
        CompositeScope compositeScope = new CompositeScope(scopes);
        if (compositeScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/CompilerManagerImpl", "createFilesCompileScope"));
        }
        return compositeScope;
    }

    @NotNull
    public CompileScope createModuleCompileScope(@NotNull Module module2, boolean includeDependentModules) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/compiler/CompilerManagerImpl", "createModuleCompileScope"));
        }
        CompileScope compileScope = this.createModulesCompileScope(new Module[]{module2}, includeDependentModules);
        if (compileScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/CompilerManagerImpl", "createModuleCompileScope"));
        }
        return compileScope;
    }

    @NotNull
    public CompileScope createModulesCompileScope(@NotNull Module[] modules, boolean includeDependentModules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/compiler/CompilerManagerImpl", "createModulesCompileScope"));
        }
        CompileScope compileScope = this.createModulesCompileScope(modules, includeDependentModules, false);
        if (compileScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/CompilerManagerImpl", "createModulesCompileScope"));
        }
        return compileScope;
    }

    @NotNull
    public CompileScope createModulesCompileScope(@NotNull Module[] modules, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/compiler/CompilerManagerImpl", "createModulesCompileScope"));
        }
        ModuleCompileScope moduleCompileScope = new ModuleCompileScope(this.myProject, modules, includeDependentModules, includeRuntimeDependencies);
        if (moduleCompileScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/CompilerManagerImpl", "createModulesCompileScope"));
        }
        return moduleCompileScope;
    }

    @NotNull
    public CompileScope createModuleGroupCompileScope(@NotNull Project project2, @NotNull Module[] modules, boolean includeDependentModules) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/CompilerManagerImpl", "createModuleGroupCompileScope"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/compiler/CompilerManagerImpl", "createModuleGroupCompileScope"));
        }
        ModuleCompileScope moduleCompileScope = new ModuleCompileScope(project2, modules, includeDependentModules);
        if (moduleCompileScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/CompilerManagerImpl", "createModuleGroupCompileScope"));
        }
        return moduleCompileScope;
    }

    @NotNull
    public CompileScope createProjectCompileScope(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/CompilerManagerImpl", "createProjectCompileScope"));
        }
        ProjectCompileScope projectCompileScope = new ProjectCompileScope(project2);
        if (projectCompileScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/CompilerManagerImpl", "createProjectCompileScope"));
        }
        return projectCompileScope;
    }

    public void setValidationEnabled(ModuleType moduleType, boolean enabled) {
        if (enabled) {
            this.myValidationDisabledModuleTypes.remove(moduleType);
        } else {
            this.myValidationDisabledModuleTypes.add(moduleType);
        }
    }

    public boolean isValidationEnabled(Module module2) {
        if (this.myValidationDisabledModuleTypes.isEmpty()) {
            return true;
        }
        return !this.myValidationDisabledModuleTypes.contains(ModuleType.get((Module)module2));
    }

    public Collection<ClassObject> compileJavaCode(List<String> options, Collection<File> platformCp, Collection<File> classpath, Collection<File> modulePath, Collection<File> sourcePath, Collection<File> files, File outputDir) throws IOException, CompilationException {
        boolean compiledOk;
        Pair<Sdk, JavaSdkVersion> runtime = BuildManager.getJavacRuntimeSdk(this.myProject);
        Sdk sdk = (Sdk)runtime.getFirst();
        SdkTypeId type2 = sdk.getSdkType();
        String javaHome = null;
        if (type2 instanceof JavaSdkType && !CompilerManagerImpl.isJdkOrJre(javaHome = sdk.getHomePath())) {
            String binPath = ((JavaSdkType)type2).getBinPath(sdk);
            String string = javaHome = binPath != null ? new File(binPath).getParent() : null;
            if (!CompilerManagerImpl.isJdkOrJre(javaHome)) {
                javaHome = null;
            }
        }
        if (javaHome == null) {
            throw new IOException("Was not able to determine JDK for project " + this.myProject.getName());
        }
        OutputCollector outputCollector = new OutputCollector();
        DiagnosticCollector diagnostic = new DiagnosticCollector();
        THashSet sourceRoots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        if (!sourcePath.isEmpty()) {
            sourceRoots.addAll(sourcePath);
        } else {
            for (File file2 : files) {
                File parentFile = file2.getParentFile();
                if (parentFile == null) continue;
                sourceRoots.add(parentFile);
            }
        }
        Map<File, THashSet> outs = Collections.singletonMap(outputDir, sourceRoots);
        ExternalJavacManager javacManager = this.getJavacManager();
        boolean bl = compiledOk = javacManager != null && javacManager.forkJavac(javaHome, -1, Collections.emptyList(), options, platformCp, classpath, modulePath, sourcePath, files, outs, (DiagnosticOutputConsumer)diagnostic, (OutputFileConsumer)outputCollector, (JavaCompilingTool)new JavacCompilerTool(), CanceledStatus.NULL);
        if (!compiledOk) {
            SmartList messages = new SmartList();
            for (Diagnostic<? extends JavaFileObject> d : diagnostic.getDiagnostics()) {
                JavaFileObject source = d.getSource();
                URI uri = source != null ? source.toUri() : null;
                messages.add(new CompilationException.Message(CompilerManagerImpl.kindToCategory(d.getKind()), d.getMessage(Locale.US), uri != null ? uri.toURL().toString() : null, (int)d.getLineNumber(), (int)d.getColumnNumber()));
            }
            throw new CompilationException("Compilation failed", (Collection)messages);
        }
        ArrayList<ClassObject> result2 = new ArrayList<ClassObject>();
        for (OutputFileObject fileObject : outputCollector.getCompiledClasses()) {
            BinaryContent content = fileObject.getContent();
            result2.add(new CompiledClass(fileObject.getName(), fileObject.getClassName(), content != null ? content.toByteArray() : null));
        }
        return result2;
    }

    private static boolean isJdkOrJre(@Nullable String path) {
        return path != null && (JdkUtil.checkForJre((String)path) || JdkUtil.checkForJdk((String)path));
    }

    private static CompilerMessageCategory kindToCategory(Diagnostic.Kind kind2) {
        switch (kind2) {
            case ERROR: {
                return CompilerMessageCategory.ERROR;
            }
            case MANDATORY_WARNING: {
                return CompilerMessageCategory.WARNING;
            }
            case WARNING: {
                return CompilerMessageCategory.WARNING;
            }
            case NOTE: {
                return CompilerMessageCategory.INFORMATION;
            }
        }
        return CompilerMessageCategory.INFORMATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ExternalJavacManager getJavacManager() throws IOException {
        ExternalJavacManager manager = this.myExternalJavacManager;
        if (manager == null) {
            CompilerManagerImpl compilerManagerImpl = this;
            synchronized (compilerManagerImpl) {
                manager = this.myExternalJavacManager;
                if (manager == null) {
                    File compilerWorkingDir = this.getJavacCompilerWorkingDir();
                    if (compilerWorkingDir == null) {
                        return null;
                    }
                    int listenPort = NetUtils.findAvailableSocketPort();
                    manager = new ExternalJavacManager(compilerWorkingDir);
                    manager.start(listenPort);
                    this.myExternalJavacManager = manager;
                }
            }
        }
        return manager;
    }

    @Nullable
    public File getJavacCompilerWorkingDir() {
        File projectBuildDir = BuildManager.getInstance().getProjectSystemDirectory(this.myProject);
        if (projectBuildDir == null) {
            return null;
        }
        projectBuildDir.mkdirs();
        return projectBuildDir;
    }

    private static class OutputCollector
    implements OutputFileConsumer {
        private final List<OutputFileObject> myClasses = new ArrayList<OutputFileObject>();

        private OutputCollector() {
        }

        public void save(@NotNull OutputFileObject fileObject) {
            if (fileObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "com/intellij/compiler/CompilerManagerImpl$OutputCollector", "save"));
            }
            this.myClasses.add(fileObject);
        }

        List<OutputFileObject> getCompiledClasses() {
            return this.myClasses;
        }
    }

    private static class DiagnosticCollector
    implements DiagnosticOutputConsumer {
        private final List<Diagnostic<? extends JavaFileObject>> myDiagnostics = new ArrayList<Diagnostic<? extends JavaFileObject>>();

        private DiagnosticCollector() {
        }

        public void outputLineAvailable(String line) {
            if (line != null && line.startsWith("JAVAC_PROCESS[STDERR]")) {
                LOG.info(line.trim());
            }
        }

        public void registerImports(String className, Collection<String> imports2, Collection<String> staticImports) {
        }

        public void javaFileLoaded(File file2) {
        }

        public void customOutputData(String pluginId, String dataName, byte[] data) {
        }

        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            this.myDiagnostics.add(diagnostic);
        }

        public List<Diagnostic<? extends JavaFileObject>> getDiagnostics() {
            return this.myDiagnostics;
        }
    }

    private class ListenerNotificator
    implements CompileStatusNotification {
        @Nullable
        private final CompileStatusNotification myDelegate;

        private ListenerNotificator(CompileStatusNotification delegate) {
            this.myDelegate = delegate;
        }

        public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
            if (!CompilerManagerImpl.this.myProject.isDisposed()) {
                CompilerManagerImpl.this.myEventPublisher.compilationFinished(aborted, errors, warnings, compileContext);
            }
            if (this.myDelegate != null) {
                this.myDelegate.finished(aborted, errors, warnings, compileContext);
            }
        }
    }

    private static class CompiledClass
    implements ClassObject {
        private final String myPath;
        private final String myClassName;
        private final byte[] myBytes;

        CompiledClass(String path, String className, byte[] bytes) {
            this.myPath = path;
            this.myClassName = className;
            this.myBytes = bytes;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getClassName() {
            return this.myClassName;
        }

        @Nullable
        public byte[] getContent() {
            return this.myBytes;
        }

        public String toString() {
            return this.getClassName();
        }
    }
}

