/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.LanguageLightRefAdapter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.Queue;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerBackwardReferenceIndex;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;
import org.jetbrains.jps.backwardRefs.SignatureData;
import org.jetbrains.jps.backwardRefs.index.CompilerIndices;

class CompilerReferenceReader {
    private static final Logger LOG = Logger.getInstance(CompilerReferenceReader.class);
    private final CompilerBackwardReferenceIndex myIndex;
    private final File myBuildDir;

    private CompilerReferenceReader(File buildDir) {
        this.myIndex = new CompilerBackwardReferenceIndex(buildDir, true);
        this.myBuildDir = buildDir;
    }

    @Nullable
    TIntHashSet findReferentFileIds(@NotNull LightRef ref, boolean checkBaseClassAmbiguity) throws StorageException {
        LightRef.NamedLightRef[] hierarchy;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "findReferentFileIds"));
        }
        if (ref instanceof LightRef.LightClassHierarchyElementDef) {
            hierarchy = new LightRef.NamedLightRef[]{(LightRef.NamedLightRef)ref};
        } else {
            LightRef.LightClassHierarchyElementDef hierarchyElement = ((LightRef.LightMember)ref).getOwner();
            hierarchy = this.getHierarchy(hierarchyElement, checkBaseClassAmbiguity, false, -1);
        }
        if (hierarchy == null) {
            return null;
        }
        TIntHashSet set2 = new TIntHashSet();
        for (LightRef.NamedLightRef aClass : hierarchy) {
            LightRef overriderUsage = ref.override(aClass.getName());
            this.addUsages(overriderUsage, set2);
        }
        return set2;
    }

    @NotNull
    Map<VirtualFile, SearchId[]> getDirectInheritors(@NotNull LightRef searchElement, @NotNull GlobalSearchScope searchScope, @NotNull GlobalSearchScope dirtyScope, @NotNull FileType fileType, @NotNull CompilerHierarchySearchType searchType) throws StorageException {
        if (searchElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchElement", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "getDirectInheritors"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "getDirectInheritors"));
        }
        if (dirtyScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirtyScope", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "getDirectInheritors"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "getDirectInheritors"));
        }
        if (searchType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchType", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "getDirectInheritors"));
        }
        GlobalSearchScope effectiveSearchScope = GlobalSearchScope.notScope((GlobalSearchScope)dirtyScope).intersectWith(searchScope);
        LanguageLightRefAdapter adapter = LanguageLightRefAdapter.findAdapter(fileType);
        LOG.assertTrue(adapter != null, (Object)("adapter is null for file type: " + fileType));
        Class<? extends LightRef> requiredLightRefClass = searchType.getRequiredClass(adapter);
        HashMap candidatesPerFile = new HashMap();
        this.myIndex.get(CompilerIndices.BACK_HIERARCHY).getData((Object)searchElement).forEach((fileId, defs) -> {
            if (searchType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchType", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "lambda$getDirectInheritors$0"));
            }
            List<LightRef> requiredCandidates = defs.stream().filter(requiredLightRefClass::isInstance).collect(Collectors.toList());
            if (requiredCandidates.isEmpty()) {
                return true;
            }
            VirtualFile file2 = this.findFile(fileId);
            if (file2 != null && effectiveSearchScope.contains(file2)) {
                candidatesPerFile.put(file2, searchType.convertToIds(requiredCandidates, this.myIndex.getByteSeqEum()));
            }
            return true;
        });
        Map<Object, Object> map2 = candidatesPerFile.isEmpty() ? Collections.emptyMap() : candidatesPerFile;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "getDirectInheritors"));
        }
        return map2;
    }

    @Nullable
    Integer getAnonymousCount(@NotNull LightRef.LightClassHierarchyElementDef classDef, boolean checkDefinitions) {
        if (classDef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDef", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "getAnonymousCount"));
        }
        try {
            if (checkDefinitions && this.getDefinitionCount((LightRef.NamedLightRef)classDef) != DefCount.ONE) {
                return null;
            }
            final int[] count = new int[]{0};
            this.myIndex.get(CompilerIndices.BACK_HIERARCHY).getData((Object)classDef).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Collection<LightRef>>(){

                public boolean perform(int id, Collection<LightRef> value2) {
                    count[0] = count[0] + value2.size();
                    return true;
                }
            });
            return count[0];
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    int getOccurrenceCount(@NotNull LightRef element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "getOccurrenceCount"));
        }
        try {
            final int[] result2 = new int[]{0};
            this.myIndex.get(CompilerIndices.BACK_USAGES).getData((Object)element).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Integer>(){

                public boolean perform(int id, Integer value2) {
                    result2[0] = result2[0] + value2;
                    return true;
                }
            });
            return result2[0];
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    List<LightRef> getMembersFor(@NotNull SignatureData data) {
        ArrayList<LightRef> arrayList;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "getMembersFor"));
        }
        try {
            ArrayList<LightRef> result2 = new ArrayList<LightRef>();
            this.myIndex.get(CompilerIndices.BACK_MEMBER_SIGN).getData((Object)data).forEach((id, refs) -> {
                result2.addAll((Collection<LightRef>)refs);
                return true;
            });
            arrayList = result2;
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "getMembersFor"));
        }
        return arrayList;
    }

    @NotNull
    TIntHashSet getAllContainingFileIds(@NotNull LightRef ref) throws StorageException {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "getAllContainingFileIds"));
        }
        TIntHashSet tIntHashSet = InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)this.myIndex.get(CompilerIndices.BACK_USAGES), Collections.singletonList(ref), null, null, null);
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "getAllContainingFileIds"));
        }
        return tIntHashSet;
    }

    @NotNull
    NameEnumerator getNameEnumerator() {
        NameEnumerator nameEnumerator = this.myIndex.getByteSeqEum();
        if (nameEnumerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "getNameEnumerator"));
        }
        return nameEnumerator;
    }

    void close(boolean removeIndex) {
        this.myIndex.close();
        if (removeIndex) {
            CompilerBackwardReferenceIndex.removeIndexFiles((File)this.myBuildDir);
        }
    }

    public CompilerBackwardReferenceIndex getIndex() {
        return this.myIndex;
    }

    static boolean exists(Project project2) {
        File buildDir = BuildManager.getInstance().getProjectSystemDirectory(project2);
        if (buildDir == null || CompilerBackwardReferenceIndex.versionDiffers((File)buildDir)) {
            return false;
        }
        return CompilerBackwardReferenceIndex.exist((File)buildDir);
    }

    static CompilerReferenceReader create(Project project2) {
        if (!CompilerReferenceReader.exists(project2)) {
            return null;
        }
        try {
            return new CompilerReferenceReader(BuildManager.getInstance().getProjectSystemDirectory(project2));
        }
        catch (RuntimeException e) {
            LOG.error("An exception while initialization of compiler reference index.", (Throwable)e);
            return null;
        }
    }

    private void addUsages(LightRef usage, final TIntHashSet sink) throws StorageException {
        this.myIndex.get(CompilerIndices.BACK_USAGES).getData((Object)usage).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Integer>(){

            public boolean perform(int id, Integer value2) {
                VirtualFile file2 = CompilerReferenceReader.this.findFile(id);
                if (file2 != null) {
                    sink.add(((VirtualFileWithId)file2).getId());
                }
                return true;
            }
        });
    }

    private VirtualFile findFile(int id) {
        try {
            String path = this.myIndex.getFilePathEnumerator().valueOf(id);
            assert (path != null);
            return VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable(value="return null if the class hierarchy contains ambiguous qualified names")
    LightRef.LightClassHierarchyElementDef[] getHierarchy(LightRef.LightClassHierarchyElementDef hierarchyElement, boolean checkBaseClassAmbiguity, boolean includeAnonymous, int interruptNumber) {
        try {
            THashSet result2 = new THashSet();
            Queue q = new Queue(10);
            q.addLast((Object)hierarchyElement);
            while (!q.isEmpty()) {
                LightRef.LightClassHierarchyElementDef curClass = (LightRef.LightClassHierarchyElementDef)q.pullFirst();
                if (interruptNumber != -1 && result2.size() > interruptNumber) break;
                if (!result2.add(curClass)) continue;
                if (!(curClass instanceof LightRef.LightAnonymousClassDef) && (checkBaseClassAmbiguity || curClass != hierarchyElement) && this.hasMultipleDefinitions((LightRef.NamedLightRef)curClass)) {
                    return null;
                }
                this.myIndex.get(CompilerIndices.BACK_HIERARCHY).getData((Object)curClass).forEach((id, children2) -> {
                    for (LightRef child : children2) {
                        if (!(child instanceof LightRef.LightClassHierarchyElementDef) || !includeAnonymous && child instanceof LightRef.LightAnonymousClassDef) continue;
                        q.addLast((Object)((LightRef.LightClassHierarchyElementDef)child));
                    }
                    return true;
                });
            }
            return result2.toArray(LightRef.LightClassHierarchyElementDef.EMPTY_ARRAY);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    LightRef.LightClassHierarchyElementDef[] getDirectInheritors(LightRef.LightClassHierarchyElementDef hierarchyElement) throws StorageException {
        THashSet result2 = new THashSet();
        this.myIndex.get(CompilerIndices.BACK_HIERARCHY).getData((Object)hierarchyElement).forEach((arg_0, arg_1) -> CompilerReferenceReader.lambda$getDirectInheritors$3((Set)result2, arg_0, arg_1));
        LightRef.LightClassHierarchyElementDef[] lightClassHierarchyElementDefArray = result2.toArray(LightRef.LightClassHierarchyElementDef.EMPTY_ARRAY);
        if (lightClassHierarchyElementDefArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "getDirectInheritors"));
        }
        return lightClassHierarchyElementDefArray;
    }

    private boolean hasMultipleDefinitions(LightRef.NamedLightRef def) throws StorageException {
        DefCount count = this.getDefinitionCount(def);
        if (count == DefCount.NONE) {
            String name2 = def instanceof LightRef.LightAnonymousClassDef ? String.valueOf(def.getName()) : this.getNameEnumerator().getName(def.getName());
            LOG.error("Can't get definition files for: " + name2 + ", class: " + def.getClass());
        }
        return count == DefCount.MANY;
    }

    @NotNull
    private DefCount getDefinitionCount(LightRef.NamedLightRef def) throws StorageException {
        final DefCount[] result2 = new DefCount[]{DefCount.NONE};
        this.myIndex.get(CompilerIndices.BACK_CLASS_DEF).getData((Object)def).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Void>(){

            public boolean perform(int id, Void value2) {
                if (result2[0] == DefCount.NONE) {
                    result2[0] = DefCount.ONE;
                    return true;
                }
                if (result2[0] == DefCount.ONE) {
                    result2[0] = DefCount.MANY;
                    return true;
                }
                return false;
            }
        });
        DefCount defCount = result2[0];
        if (defCount == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceReader", "getDefinitionCount"));
        }
        return defCount;
    }

    private static /* synthetic */ boolean lambda$getDirectInheritors$3(Set result2, int id, Collection children2) {
        for (LightRef child : children2) {
            if (!(child instanceof LightRef.LightClassHierarchyElementDef) || child instanceof LightRef.LightAnonymousClassDef) continue;
            result2.add((LightRef.LightClassHierarchyElementDef)child);
        }
        return true;
    }

    private static enum DefCount {
        NONE,
        ONE,
        MANY;

    }
}

