/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

class ExcludedFromCompileFilesUtil {
    ExcludedFromCompileFilesUtil() {
    }

    static GlobalSearchScope getExcludedFilesScope(@NotNull ExcludeEntryDescription[] descriptions, @NotNull Set<FileType> fileTypes, @NotNull Project project2, @NotNull ProjectFileIndex fileIndex) {
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/compiler/backwardRefs/ExcludedFromCompileFilesUtil", "getExcludedFilesScope"));
        }
        if (fileTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypes", "com/intellij/compiler/backwardRefs/ExcludedFromCompileFilesUtil", "getExcludedFilesScope"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/backwardRefs/ExcludedFromCompileFilesUtil", "getExcludedFilesScope"));
        }
        if (fileIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIndex", "com/intellij/compiler/backwardRefs/ExcludedFromCompileFilesUtil", "getExcludedFilesScope"));
        }
        ManagingFS fs = ManagingFS.getInstance();
        Collection excludedFiles = Stream.of(descriptions).flatMap(description -> {
            VirtualFile file2 = description.getVirtualFile();
            if (file2 == null) {
                return Stream.empty();
            }
            if (description.isFile()) {
                return Stream.of(file2);
            }
            if (description.isIncludeSubdirectories()) {
                Stream.Builder builder = Stream.builder();
                VfsUtilCore.iterateChildrenRecursively((VirtualFile)file2, f -> !f.isDirectory() || fs.areChildrenLoaded(f), f -> {
                    builder.accept(f);
                    return true;
                });
                return builder.build();
            }
            return fs.areChildrenLoaded(file2) ? Stream.of(file2.getChildren()) : Stream.empty();
        }).filter(f -> {
            if (fileTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypes", "com/intellij/compiler/backwardRefs/ExcludedFromCompileFilesUtil", "lambda$getExcludedFilesScope$3"));
            }
            if (fileIndex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIndex", "com/intellij/compiler/backwardRefs/ExcludedFromCompileFilesUtil", "lambda$getExcludedFilesScope$3"));
            }
            return !f.isDirectory() && fileTypes.contains(f.getFileType()) && fileIndex.isInSourceContent(f);
        }).collect(Collectors.toList());
        return GlobalSearchScope.filesWithoutLibrariesScope((Project)project2, (Collection)excludedFiles);
    }
}

