/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceImpl;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompilerElementRetriever {
    private static final Logger LOG = Logger.getInstance(JavaCompilerElementRetriever.class);
    private static final TokenSet FUN_EXPR = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.LAMBDA_EXPRESSION, JavaElementType.METHOD_REF_EXPRESSION});

    @NotNull
    static PsiFunctionalExpression[] retrieveFunExpressionsByIndices(@NotNull TIntHashSet indices2, @NotNull PsiFileWithStubSupport psiFile) {
        boolean foreign;
        if (indices2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indices", "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever", "retrieveFunExpressionsByIndices"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever", "retrieveFunExpressionsByIndices"));
        }
        StubTree tree = psiFile.getStubTree();
        boolean bl = foreign = tree == null;
        if (foreign) {
            tree = ((PsiFileImpl)psiFile).calcStubTree();
        }
        Object[] result2 = new PsiFunctionalExpression[indices2.size()];
        int resIdx = 0;
        int funExprIdx = 0;
        for (StubElement element : tree.getPlainList()) {
            if (!FUN_EXPR.contains((IElementType)element.getStubType()) || !indices2.contains(funExprIdx++)) continue;
            result2[resIdx++] = (PsiFunctionalExpression)element.getPsi();
        }
        if (result2.length != resIdx) {
            CompilerReferenceServiceImpl compilerReferenceService = (CompilerReferenceServiceImpl)CompilerReferenceService.getInstance(psiFile.getProject());
            Set<Module> state = compilerReferenceService.getDirtyScopeHolder().getAllDirtyModules();
            VirtualFile file2 = psiFile.getVirtualFile();
            Module moduleForFile = ProjectFileIndex.getInstance((Project)psiFile.getProject()).getModuleForFile(file2);
            LOG.error("Compiler functional expression index doesn't match to stub index.\nFunctional expression indices: " + indices2 + "\nDoes the file belong to dirty scope?: " + state.contains(moduleForFile), new Attachment[]{new Attachment(psiFile.getName(), psiFile.getText())});
            PsiFunctionalExpression[] psiFunctionalExpressionArray = ContainerUtil.filter((Object[])result2, Objects::nonNull).toArray(PsiFunctionalExpression.EMPTY_ARRAY);
            if (psiFunctionalExpressionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever", "retrieveFunExpressionsByIndices"));
            }
            return psiFunctionalExpressionArray;
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever", "retrieveFunExpressionsByIndices"));
        }
        return result2;
    }

    @NotNull
    static PsiClass[] retrieveClassesByInternalIds(@NotNull SearchId[] internalIds, @NotNull PsiFileWithStubSupport psiFile) {
        if (internalIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalIds", "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever", "retrieveClassesByInternalIds"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever", "retrieveClassesByInternalIds"));
        }
        ClassMatcher matcher = ClassMatcher.create(internalIds);
        PsiClass[] psiClassArray = (PsiClass[])ReadAction.compute(() -> {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever", "lambda$retrieveClassesByInternalIds$0"));
            }
            return matcher.retrieveClasses(psiFile);
        });
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever", "retrieveClassesByInternalIds"));
        }
        return psiClassArray;
    }

    private static class ClassMatcher {
        @Nullable
        private final TIntHashSet myAnonymousIndices;
        @NotNull
        private final Collection<InternalNameMatcher> myClassNameMatchers;

        private ClassMatcher(@Nullable TIntHashSet anonymousIndices, @NotNull Collection<InternalNameMatcher> nameMatchers) {
            if (nameMatchers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameMatchers", "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever$ClassMatcher", "<init>"));
            }
            this.myAnonymousIndices = anonymousIndices;
            this.myClassNameMatchers = nameMatchers;
        }

        private PsiClass[] retrieveClasses(PsiFileWithStubSupport file2) {
            boolean foreign;
            StubTree tree = file2.getStubTree();
            boolean bl = foreign = tree == null;
            if (foreign) {
                tree = ((PsiFileImpl)file2).calcStubTree();
            }
            ArrayList<PsiClass> result2 = new ArrayList<PsiClass>(this.myClassNameMatchers.size() + (this.myAnonymousIndices == null ? 0 : this.myAnonymousIndices.size()));
            int anonymousId = 0;
            for (StubElement element : tree.getPlainList()) {
                if (!(element instanceof PsiClassStub)) continue;
                if (((PsiClassStub)element).isAnonymous()) {
                    if (this.myAnonymousIndices == null || this.myAnonymousIndices.isEmpty()) continue;
                    if (this.myAnonymousIndices.contains(anonymousId)) {
                        result2.add((PsiClass)element.getPsi());
                    }
                    ++anonymousId;
                    continue;
                }
                if (!ClassMatcher.match((PsiClassStub)element, this.myClassNameMatchers)) continue;
                result2.add((PsiClass)element.getPsi());
            }
            return result2.toArray(PsiClass.EMPTY_ARRAY);
        }

        private static boolean match(PsiClassStub stub, Collection<InternalNameMatcher> matchers) {
            for (InternalNameMatcher matcher : matchers) {
                if (!matcher.matches(stub)) continue;
                if (matcher instanceof InternalNameMatcher.ByQualifiedName) {
                    matchers.remove(matcher);
                }
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private static ClassMatcher create(@NotNull SearchId[] internalIds) {
            if (internalIds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalIds", "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever$ClassMatcher", "create"));
            }
            SmartList nameMatchers = new SmartList();
            TIntHashSet anonymousIndices = null;
            SearchId[] searchIdArray = internalIds;
            int n = searchIdArray.length;
            int n2 = 0;
            while (n2 < n) {
                SearchId internalId = searchIdArray[n2];
                if (internalId.getId() != -1) {
                    if (anonymousIndices == null) {
                        anonymousIndices = new TIntHashSet();
                    }
                    anonymousIndices.add(internalId.getId());
                } else {
                    String internalName = internalId.getDeserializedName();
                    int curLast = internalName.length() - 1;
                    while (true) {
                        int lastIndex;
                        if ((lastIndex = internalName.lastIndexOf(36, curLast)) > -1 && lastIndex < internalName.length() - 1) {
                            int followingIndex = lastIndex + 1;
                            boolean digit = Character.isDigit(internalName.charAt(followingIndex));
                            if (digit) {
                                if (curLast == internalName.length() - 1) {
                                    int nextNonDigit = ClassMatcher.getNextNonDigitIndex(internalName, followingIndex);
                                    if (nextNonDigit == -1) {
                                        throw new IllegalStateException();
                                    }
                                    nameMatchers.add(new InternalNameMatcher.ByName(internalName.substring(nextNonDigit)));
                                } else {
                                    nameMatchers.add(new InternalNameMatcher.ByName(StringUtil.getShortName((String)internalName, (char)'$')));
                                    break;
                                }
                            }
                        } else {
                            nameMatchers.add(new InternalNameMatcher.ByQualifiedName(StringUtil.replace((String)internalName, (String)"$", (String)".")));
                            break;
                        }
                        curLast = lastIndex - 1;
                    }
                }
                ++n2;
            }
            return new ClassMatcher(anonymousIndices, (Collection<InternalNameMatcher>)nameMatchers);
        }

        private static int getNextNonDigitIndex(String name2, int digitIndex) {
            for (int i2 = digitIndex + 1; i2 < name2.length(); ++i2) {
                if (Character.isDigit(name2.charAt(i2))) continue;
                return i2;
            }
            return -1;
        }
    }

    private static interface InternalNameMatcher {
        public boolean matches(PsiClassStub var1);

        public static class ByQualifiedName
        implements InternalNameMatcher {
            private final String myQName;

            public ByQualifiedName(String name2) {
                this.myQName = name2;
            }

            @Override
            public boolean matches(PsiClassStub stub) {
                return this.myQName.equals(stub.getQualifiedName());
            }
        }

        public static class ByName
        implements InternalNameMatcher {
            private final String myName;

            public ByName(String name2) {
                this.myName = name2;
            }

            @Override
            public boolean matches(PsiClassStub stub) {
                return this.myName.equals(stub.getName());
            }
        }
    }
}

