/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;

public class ChainRelevance
implements Comparable<ChainRelevance> {
    private final int myChainSize;
    private final int myUnreachableParameterCount;
    private final int myParametersInContext;

    public ChainRelevance(int chainSize, int unreachableParameterCount, int parametersInContext) {
        this.myChainSize = chainSize;
        this.myUnreachableParameterCount = unreachableParameterCount;
        this.myParametersInContext = parametersInContext;
    }

    public int getChainSize() {
        return this.myChainSize;
    }

    public int getUnreachableParameterCount() {
        return this.myUnreachableParameterCount;
    }

    public int getParametersInContext() {
        return this.myParametersInContext;
    }

    @Override
    public int compareTo(@NotNull ChainRelevance that) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/compiler/chainsSearch/ChainRelevance", "compareTo"));
        }
        int sub = Comparing.compare((int)this.myChainSize, (int)that.myChainSize);
        if (sub != 0) {
            return sub;
        }
        sub = Comparing.compare((int)this.myUnreachableParameterCount, (int)that.myUnreachableParameterCount);
        if (sub != 0) {
            return sub;
        }
        return -Comparing.compare((int)this.myParametersInContext, (int)that.myParametersInContext);
    }

    public String toString() {
        return "{\"chain_size\": " + this.myChainSize + ", \"unreachable_params\": " + this.myUnreachableParameterCount + ", \"parameters_in_context\": " + this.myParametersInContext + "}";
    }
}

