/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.compiler.chainsSearch.MethodIncompleteSignature;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodChain {
    private final List<PsiMethod[]> myRevertedPath;
    private final MethodIncompleteSignature mySignature;
    private final int myWeight;
    private final PsiClass myQualifierClass;

    @Nullable
    public static MethodChain create(@NotNull MethodIncompleteSignature signature, int weight, @NotNull ChainCompletionContext context) {
        PsiClass contextClass;
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/compiler/chainsSearch/MethodChain", "create"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/compiler/chainsSearch/MethodChain", "create"));
        }
        PsiClass qualifier = context.resolveQualifierClass(signature);
        if (qualifier == null || !signature.isStatic() && InheritanceUtil.isInheritorOrSelf((PsiClass)context.getTarget().getTargetClass(), (PsiClass)qualifier, (boolean)true)) {
            return null;
        }
        PsiMethod[] methods = context.resolve(signature);
        if (methods.length == 0) {
            return null;
        }
        Set classes2 = Arrays.stream(methods).flatMap(m -> Arrays.stream(m.getParameterList().getParameters())).map(p -> PsiUtil.resolveClassInType((PsiType)p.getType())).collect(Collectors.toSet());
        if (classes2.contains(contextClass = context.getTarget().getTargetClass())) {
            return null;
        }
        classes2.add(contextClass);
        return new MethodChain(qualifier, Collections.singletonList(methods), signature, weight);
    }

    public MethodChain(@NotNull PsiClass qualifierClass, @NotNull List<PsiMethod[]> revertedPath, MethodIncompleteSignature signature, int weight) {
        if (qualifierClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierClass", "com/intellij/compiler/chainsSearch/MethodChain", "<init>"));
        }
        if (revertedPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revertedPath", "com/intellij/compiler/chainsSearch/MethodChain", "<init>"));
        }
        this.myQualifierClass = qualifierClass;
        this.myRevertedPath = revertedPath;
        this.mySignature = signature;
        this.myWeight = weight;
    }

    @NotNull
    public MethodIncompleteSignature getHeadSignature() {
        MethodIncompleteSignature methodIncompleteSignature = this.mySignature;
        if (methodIncompleteSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/MethodChain", "getHeadSignature"));
        }
        return methodIncompleteSignature;
    }

    public int length() {
        return this.myRevertedPath.size();
    }

    public PsiClass getQualifierClass() {
        return this.myQualifierClass;
    }

    @NotNull
    public PsiMethod[] getFirst() {
        PsiMethod[] psiMethodArray = this.myRevertedPath.get(0);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/MethodChain", "getFirst"));
        }
        return psiMethodArray;
    }

    public List<PsiMethod[]> getPath() {
        return ContainerUtil.reverse(this.myRevertedPath);
    }

    public int getChainWeight() {
        return this.myWeight;
    }

    public MethodChain continuation(@NotNull MethodIncompleteSignature signature, int weight, @NotNull ChainCompletionContext context) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/compiler/chainsSearch/MethodChain", "continuation"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/compiler/chainsSearch/MethodChain", "continuation"));
        }
        MethodChain head = MethodChain.create(signature, weight, context);
        if (head == null) {
            return null;
        }
        ArrayList newRevertedPath = ContainerUtil.newArrayList();
        newRevertedPath.addAll(this.myRevertedPath);
        newRevertedPath.add(head.getPath().get(0));
        return new MethodChain(head.getQualifierClass(), newRevertedPath, head.getHeadSignature(), Math.min(weight, this.getChainWeight()));
    }

    public String toString() {
        return this.myQualifierClass.getName() + "." + ContainerUtil.reverse(this.myRevertedPath).stream().map(methods -> methods[0].getName() + "()").collect(Collectors.joining("."));
    }

    public static CompareResult compare(@NotNull MethodChain left, @NotNull MethodChain right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/compiler/chainsSearch/MethodChain", "compare"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/compiler/chainsSearch/MethodChain", "compare"));
        }
        if (left.length() == 0 || right.length() == 0) {
            throw new IllegalStateException("chains can't be empty");
        }
        Iterator<PsiMethod[]> leftIterator = left.myRevertedPath.iterator();
        Iterator<PsiMethod[]> rightIterator = right.myRevertedPath.iterator();
        while (leftIterator.hasNext() && rightIterator.hasNext()) {
            PsiMethod[] thatNext;
            PsiMethod[] thisNext = leftIterator.next();
            if (MethodChain.lookSimilar(thisNext, thatNext = rightIterator.next())) continue;
            return CompareResult.NOT_EQUAL;
        }
        if (leftIterator.hasNext() && !rightIterator.hasNext()) {
            return CompareResult.LEFT_CONTAINS_RIGHT;
        }
        if (!leftIterator.hasNext() && rightIterator.hasNext()) {
            return CompareResult.RIGHT_CONTAINS_LEFT;
        }
        return CompareResult.EQUAL;
    }

    static boolean lookSimilar(PsiMethod[] methods1, PsiMethod[] methods2) {
        HashSet methodSet2;
        PsiMethod repr1 = methods1[0];
        PsiMethod repr2 = methods2[0];
        if (repr1.hasModifierProperty("static") || repr2.hasModifierProperty("static")) {
            return false;
        }
        if (!repr1.getName().equals(repr2.getName()) || repr1.getParameterList().getParametersCount() != repr2.getParameterList().getParametersCount()) {
            return false;
        }
        HashSet methodSet1 = ContainerUtil.newHashSet((Object[])methods1);
        if (ContainerUtil.intersects((Collection)methodSet1, (Collection)(methodSet2 = ContainerUtil.newHashSet((Object[])methods2)))) {
            return true;
        }
        Set deepestSupers1 = methodSet1.stream().flatMap(m -> Arrays.stream(m.findDeepestSuperMethods())).collect(Collectors.toSet());
        return methodSet2.stream().flatMap(m -> Arrays.stream(m.findDeepestSuperMethods())).anyMatch(deepestSupers1::contains);
    }

    public static enum CompareResult {
        LEFT_CONTAINS_RIGHT,
        RIGHT_CONTAINS_LEFT,
        EQUAL,
        NOT_EQUAL;

    }
}

