/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.text.EditDistance;
import java.util.Comparator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodChainsSearchUtil {
    private static final int COMMON_PART_MIN_LENGTH = 3;

    private MethodChainsSearchUtil() {
    }

    public static boolean isSimilar(@NotNull String target2, @NotNull String candidate) {
        if (target2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/compiler/chainsSearch/MethodChainsSearchUtil", "isSimilar"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/compiler/chainsSearch/MethodChainsSearchUtil", "isSimilar"));
        }
        return EditDistance.levenshtein((CharSequence)target2, (CharSequence)MethodChainsSearchUtil.sanitizedToLowerCase(candidate), (boolean)true) >= 3;
    }

    @NotNull
    public static String sanitizedToLowerCase(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/compiler/chainsSearch/MethodChainsSearchUtil", "sanitizedToLowerCase"));
        }
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < name2.length(); ++i2) {
            char ch = name2.charAt(i2);
            if (!Character.isLetter(ch)) continue;
            result2.append(Character.toLowerCase(ch));
        }
        String string = result2.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/MethodChainsSearchUtil", "sanitizedToLowerCase"));
        }
        return string;
    }

    @Nullable
    public static PsiMethod getMethodWithMinNotPrimitiveParameters(@NotNull PsiMethod[] methods, @NotNull PsiClass target2) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/compiler/chainsSearch/MethodChainsSearchUtil", "getMethodWithMinNotPrimitiveParameters"));
        }
        if (target2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/compiler/chainsSearch/MethodChainsSearchUtil", "getMethodWithMinNotPrimitiveParameters"));
        }
        return Stream.of(methods).filter(m -> {
            if (target2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/compiler/chainsSearch/MethodChainsSearchUtil", "lambda$getMethodWithMinNotPrimitiveParameters$0"));
            }
            for (PsiParameter parameter : m.getParameterList().getParameters()) {
                PsiType t = parameter.getType();
                PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)t);
                if (aClass == null || aClass != target2) continue;
                return false;
            }
            return true;
        }).sorted(Comparator.comparing(MethodChainsSearchUtil::getNonPrimitiveParameterCount)).findFirst().orElse(null);
    }

    private static int getNonPrimitiveParameterCount(PsiMethod method) {
        return (int)Stream.of(method.getParameterList().getParameters()).map(p -> p.getType()).filter(t -> !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)t)).count();
    }
}

