/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.compiler.chainsSearch.MethodChain;
import com.intellij.compiler.chainsSearch.MethodIncompleteSignature;
import com.intellij.compiler.chainsSearch.SignatureAndOccurrences;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;

public class SearchInitializer {
    private final ChainCompletionContext myContext;
    private final LinkedList<MethodChain> myQueue;
    private final LinkedHashMap<MethodIncompleteSignature, MethodChain> myChains;

    public SearchInitializer(SortedSet<SignatureAndOccurrences> indexValues, ChainCompletionContext context) {
        this.myContext = context;
        int size = indexValues.size();
        ArrayList<MethodChain> chains = new ArrayList<MethodChain>(size);
        this.populateFrequentlyUsedMethod(indexValues, chains);
        this.myQueue = new LinkedList();
        this.myChains = new LinkedHashMap(chains.size());
        for (MethodChain chain : chains) {
            MethodIncompleteSignature signature = chain.getHeadSignature();
            this.myQueue.add(chain);
            this.myChains.put(signature, chain);
        }
    }

    public LinkedList<MethodChain> getChainQueue() {
        return this.myQueue;
    }

    public LinkedHashMap<MethodIncompleteSignature, MethodChain> getChains() {
        return this.myChains;
    }

    private void populateFrequentlyUsedMethod(SortedSet<SignatureAndOccurrences> signatures, List<MethodChain> chains) {
        int bestOccurrences = -1;
        for (SignatureAndOccurrences indexValue : signatures) {
            MethodChain methodChain = MethodChain.create(indexValue.getSignature(), indexValue.getOccurrenceCount(), this.myContext);
            if (methodChain == null) continue;
            chains.add(methodChain);
            int occurrences = indexValue.getOccurrenceCount();
            if (bestOccurrences == -1) {
                bestOccurrences = occurrences;
                continue;
            }
            if (bestOccurrences <= occurrences * 10) continue;
            return;
        }
    }
}

