/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaCompletionSorting;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.backwardRefs.ReferenceIndexUnavailableException;
import com.intellij.compiler.chainsSearch.ChainSearcher;
import com.intellij.compiler.chainsSearch.MethodChain;
import com.intellij.compiler.chainsSearch.MethodChainLookupRangingHelper;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.compiler.chainsSearch.context.ChainSearchTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodChainCompletionContributor
extends CompletionContributor {
    public static final String REGISTRY_KEY = "compiler.ref.chain.search";
    private static final Logger LOG = Logger.getInstance(MethodChainCompletionContributor.class);
    private static final boolean UNIT_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();

    public MethodChainCompletionContributor() {
        ElementPattern pattern = PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{MethodChainCompletionContributor.patternForMethodCallArgument(), MethodChainCompletionContributor.patternForVariableAssignment(), MethodChainCompletionContributor.patternForReturnExpression()});
        this.extend(CompletionType.SMART, pattern, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext context, @NotNull CompletionResultSet result2) {
                if (parameters2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/compiler/chainsSearch/completion/MethodChainCompletionContributor$1", "addCompletions"));
                }
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/compiler/chainsSearch/completion/MethodChainCompletionContributor$1", "addCompletions"));
                }
                try {
                    if (!Registry.is((String)MethodChainCompletionContributor.REGISTRY_KEY)) {
                        return;
                    }
                    THashSet alreadySuggested = new THashSet();
                    CompletionResultSet finalResult = result2;
                    result2.runRemainingContributors(parameters2, arg_0 -> 1.lambda$addCompletions$0((Set)alreadySuggested, finalResult, arg_0));
                    ChainCompletionContext completionContext = MethodChainCompletionContributor.extractContext(parameters2);
                    if (completionContext == null) {
                        return;
                    }
                    result2 = JavaCompletionSorting.addJavaSorting(parameters2, result2);
                    List elementsFoundByMethodsChainsSearch = MethodChainCompletionContributor.searchForLookups(completionContext);
                    if (!UNIT_TEST_MODE && !alreadySuggested.isEmpty()) {
                        elementsFoundByMethodsChainsSearch = elementsFoundByMethodsChainsSearch.stream().filter(arg_0 -> 1.lambda$addCompletions$1((Set)alreadySuggested, arg_0)).collect(Collectors.toList());
                    }
                    result2.addAllElements((Iterable)elementsFoundByMethodsChainsSearch);
                }
                catch (ReferenceIndexUnavailableException referenceIndexUnavailableException) {
                    // empty catch block
                }
            }

            private static /* synthetic */ boolean lambda$addCompletions$1(Set alreadySuggested, LookupElement lookupElement) {
                PsiElement psi = lookupElement.getPsiElement();
                return !(psi instanceof PsiMethod) || !alreadySuggested.contains(psi);
            }

            private static /* synthetic */ void lambda$addCompletions$0(Set alreadySuggested, CompletionResultSet finalResult, CompletionResult completionResult) {
                LookupElement lookupElement = completionResult.getLookupElement();
                PsiElement psi = lookupElement.getPsiElement();
                if (psi instanceof PsiMethod) {
                    alreadySuggested.add((PsiMethod)psi);
                }
                finalResult.passResult(completionResult);
            }
        });
    }

    private static List<LookupElement> searchForLookups(ChainCompletionContext context) {
        CompilerReferenceServiceEx methodsUsageIndexReader = (CompilerReferenceServiceEx)CompilerReferenceService.getInstance(context.getProject());
        ChainSearchTarget target2 = context.getTarget();
        List<MethodChain> searchResult = ChainSearcher.search(4, target2, 5, context, methodsUsageIndexReader);
        int maxWeight = searchResult.stream().mapToInt(MethodChain::getChainWeight).max().orElse(0);
        return searchResult.stream().filter(ch -> ch.getChainWeight() * 10 >= maxWeight).map(ch -> MethodChainLookupRangingHelper.toLookupElement(ch, context)).collect(Collectors.toList());
    }

    @Nullable
    private static ChainCompletionContext extractContext(CompletionParameters parameters2) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)parameters2.getPosition(), (Class[])new Class[]{PsiAssignmentExpression.class, PsiLocalVariable.class, PsiMethodCallExpression.class, PsiReturnStatement.class});
        LOG.assertTrue(parent != null, (Object)"A completion position should match to a pattern");
        if (parent instanceof PsiReturnStatement) {
            return MethodChainCompletionContributor.extractContextFromReturn((PsiReturnStatement)parent, parameters2);
        }
        if (parent instanceof PsiAssignmentExpression) {
            return MethodChainCompletionContributor.extractContextFromAssignment((PsiAssignmentExpression)parent, parameters2);
        }
        if (parent instanceof PsiLocalVariable) {
            return MethodChainCompletionContributor.extractContextFromVariable((PsiLocalVariable)parent, parameters2);
        }
        return MethodChainCompletionContributor.extractContextFromMethodCall((PsiMethodCallExpression)parent, parameters2);
    }

    @Nullable
    private static ChainCompletionContext extractContextFromMethodCall(PsiMethodCallExpression parent, CompletionParameters parameters2) {
        PsiParameter[] methodParameters;
        PsiMethod method = parent.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)parameters2.getPosition(), PsiExpression.class);
        PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)parameters2.getPosition(), PsiExpressionList.class);
        if (expressionList == null) {
            return null;
        }
        int exprPosition = Arrays.asList(expressionList.getExpressions()).indexOf(expression2);
        if (exprPosition < (methodParameters = method.getParameterList().getParameters()).length) {
            PsiParameter methodParameter = methodParameters[exprPosition];
            return ChainCompletionContext.createContext(methodParameter.getType(), PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethodCallExpression.class), MethodChainCompletionContributor.suggestIterators(parameters2));
        }
        return null;
    }

    @Nullable
    private static ChainCompletionContext extractContextFromReturn(PsiReturnStatement returnStatement, CompletionParameters parameters2) {
        PsiType type2 = PsiTypesUtil.getMethodReturnType((PsiElement)returnStatement);
        if (type2 == null) {
            return null;
        }
        return ChainCompletionContext.createContext(type2, (PsiElement)returnStatement, MethodChainCompletionContributor.suggestIterators(parameters2));
    }

    @Nullable
    private static ChainCompletionContext extractContextFromVariable(PsiLocalVariable localVariable, CompletionParameters parameters2) {
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)localVariable, PsiDeclarationStatement.class);
        return ChainCompletionContext.createContext(localVariable.getType(), (PsiElement)declaration2, MethodChainCompletionContributor.suggestIterators(parameters2));
    }

    @Nullable
    private static ChainCompletionContext extractContextFromAssignment(PsiAssignmentExpression assignmentExpression, CompletionParameters parameters2) {
        PsiExpression lExpr = assignmentExpression.getLExpression();
        if (!(lExpr instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement resolved = ((PsiReferenceExpression)lExpr).resolve();
        return resolved instanceof PsiVariable ? ChainCompletionContext.createContext(((PsiVariable)resolved).getType(), (PsiElement)assignmentExpression, MethodChainCompletionContributor.suggestIterators(parameters2)) : null;
    }

    @NotNull
    private static ElementPattern<PsiElement> patternForVariableAssignment() {
        ElementPattern patternForParent = PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("IntellijIdeaRulezzz")).afterSiblingSkipping((ElementPattern)PsiJavaPatterns.psiElement(PsiWhiteSpace.class), (ElementPattern)PsiJavaPatterns.psiElement(PsiJavaToken.class).withText("="))});
        TreeElementPattern treeElementPattern = ((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(patternForParent)).withSuperParent(2, PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiAssignmentExpression.class), PsiJavaPatterns.psiElement(PsiLocalVariable.class).inside(PsiDeclarationStatement.class)}))).inside(PsiMethod.class);
        if (treeElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/completion/MethodChainCompletionContributor", "patternForVariableAssignment"));
        }
        return treeElementPattern;
    }

    @NotNull
    private static ElementPattern<PsiElement> patternForMethodCallArgument() {
        TreeElementPattern treeElementPattern = PsiJavaPatterns.psiElement().withParent((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiReferenceExpression().with((PatternCondition)new PatternCondition<PsiReferenceExpression>("qualifier is null"){

            public boolean accepts(@NotNull PsiReferenceExpression expression2, ProcessingContext context) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/compiler/chainsSearch/completion/MethodChainCompletionContributor$2", "accepts"));
                }
                return expression2.getQualifierExpression() == null;
            }
        })).withSuperParent(2, PsiMethodCallExpression.class));
        if (treeElementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/completion/MethodChainCompletionContributor", "patternForMethodCallArgument"));
        }
        return treeElementPattern;
    }

    private static ElementPattern<PsiElement> patternForReturnExpression() {
        return PsiJavaPatterns.psiElement().withSuperParent(2, PsiReturnStatement.class);
    }

    private static boolean suggestIterators(@NotNull CompletionParameters parameters2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/compiler/chainsSearch/completion/MethodChainCompletionContributor", "suggestIterators"));
        }
        return parameters2.getInvocationCount() > 1;
    }
}

