/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.MessagesContainer;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompileContextImpl
extends UserDataHolderBase
implements CompileContextEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.CompileContextImpl");
    private final Project myProject;
    private final CompilerTask myBuildSession;
    private final MessagesContainer myMessages;
    private final boolean myShouldUpdateProblemsView;
    private CompileScope myCompileScope;
    private final boolean myMake;
    private final boolean myIsRebuild;
    private final boolean myIsAnnotationProcessorsEnabled;
    private boolean myRebuildRequested;
    private String myRebuildReason;
    private final ProjectFileIndex myProjectFileIndex;
    private final ProjectCompileScope myProjectCompileScope;
    private final long myStartCompilationStamp;
    private final UUID mySessionId;

    public CompileContextImpl(@NotNull Project project2, @NotNull CompilerTask compilerSession, @NotNull CompileScope compileScope, boolean isMake, boolean isRebuild) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/impl/CompileContextImpl", "<init>"));
        }
        if (compilerSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerSession", "com/intellij/compiler/impl/CompileContextImpl", "<init>"));
        }
        if (compileScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileScope", "com/intellij/compiler/impl/CompileContextImpl", "<init>"));
        }
        this.mySessionId = UUID.randomUUID();
        this.myProject = project2;
        this.myMessages = new MessagesContainer(project2);
        this.myBuildSession = compilerSession;
        this.myCompileScope = compileScope;
        this.myMake = isMake;
        this.myIsRebuild = isRebuild;
        this.myStartCompilationStamp = System.currentTimeMillis();
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        this.myProjectCompileScope = new ProjectCompileScope(this.myProject);
        this.myIsAnnotationProcessorsEnabled = CompilerConfiguration.getInstance((Project)project2).isAnnotationProcessorsEnabled();
        Object sessionId = ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.get((UserDataHolder)compileScope);
        if (sessionId != null) {
            compilerSession.setSessionId(sessionId);
        }
        CompilerWorkspaceConfiguration workspaceConfig = CompilerWorkspaceConfiguration.getInstance((Project)this.myProject);
        this.myShouldUpdateProblemsView = workspaceConfig.MAKE_PROJECT_ON_SAVE;
    }

    @NotNull
    public CompilerTask getBuildSession() {
        CompilerTask compilerTask = this.myBuildSession;
        if (compilerTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompileContextImpl", "getBuildSession"));
        }
        return compilerTask;
    }

    public boolean shouldUpdateProblemsView() {
        return this.myShouldUpdateProblemsView;
    }

    public long getStartCompilationStamp() {
        return this.myStartCompilationStamp;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompileContextImpl", "getProject"));
        }
        return project2;
    }

    @NotNull
    public CompilerMessage[] getMessages(@NotNull CompilerMessageCategory category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/compiler/impl/CompileContextImpl", "getMessages"));
        }
        CompilerMessage[] compilerMessageArray = this.myMessages.getMessages(category).toArray(CompilerMessage.EMPTY_ARRAY);
        if (compilerMessageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompileContextImpl", "getMessages"));
        }
        return compilerMessageArray;
    }

    public void addMessage(@NotNull CompilerMessageCategory category, String message2, String url, int lineNum, int columnNum) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/compiler/impl/CompileContextImpl", "addMessage"));
        }
        this.addMessage(category, message2, url, lineNum, columnNum, null);
    }

    public void addMessage(@NotNull CompilerMessageCategory category, String message2, String url, int lineNum, int columnNum, Navigatable navigatable) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/compiler/impl/CompileContextImpl", "addMessage"));
        }
        CompilerMessage msg = this.myMessages.addMessage(category, message2, url, lineNum, columnNum, navigatable);
        if (msg != null) {
            this.addToProblemsView(msg);
        }
    }

    @Override
    public void addMessage(CompilerMessage msg) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info("addMessage: " + msg + " this=" + this);
        }
        if (this.myMessages.addMessage(msg)) {
            this.addToProblemsView(msg);
        }
    }

    private void addToProblemsView(CompilerMessage msg) {
        this.myBuildSession.addMessage(msg);
        if (this.myShouldUpdateProblemsView && msg.getCategory() == CompilerMessageCategory.ERROR) {
            ProblemsView.SERVICE.getInstance(this.myProject).addMessage(msg, this.mySessionId);
        }
    }

    public int getMessageCount(CompilerMessageCategory category) {
        return this.myMessages.getMessageCount(category);
    }

    public CompileScope getCompileScope() {
        return this.myCompileScope;
    }

    public CompileScope getProjectCompileScope() {
        return this.myProjectCompileScope;
    }

    public void requestRebuildNextTime(String message2) {
        if (!this.myRebuildRequested) {
            this.myRebuildRequested = true;
            this.myRebuildReason = message2;
        }
    }

    public boolean isRebuildRequested() {
        return this.myRebuildRequested;
    }

    @Nullable
    public String getRebuildReason() {
        return this.myRebuildReason;
    }

    @NotNull
    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = this.myBuildSession.getIndicator();
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompileContextImpl", "getProgressIndicator"));
        }
        return progressIndicator;
    }

    public Module getModuleByFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/compiler/impl/CompileContextImpl", "getModuleByFile"));
        }
        Module module2 = this.myProjectFileIndex.getModuleForFile(file2);
        if (module2 != null) {
            LOG.assertTrue(!module2.isDisposed());
            return module2;
        }
        return null;
    }

    public VirtualFile getModuleOutputDirectory(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/compiler/impl/CompileContextImpl", "getModuleOutputDirectory"));
        }
        return CompilerPaths.getModuleOutputDirectory((Module)module2, (boolean)false);
    }

    public VirtualFile getModuleOutputDirectoryForTests(Module module2) {
        return CompilerPaths.getModuleOutputDirectory((Module)module2, (boolean)true);
    }

    public boolean isMake() {
        return this.myMake;
    }

    public boolean isAutomake() {
        return false;
    }

    public boolean isRebuild() {
        return this.myIsRebuild;
    }

    public boolean isAnnotationProcessorsEnabled() {
        return this.myIsAnnotationProcessorsEnabled;
    }

    @Override
    public void addScope(CompileScope additionalScope) {
        this.myCompileScope = new CompositeScope(this.myCompileScope, additionalScope);
    }

    public UUID getSessionId() {
        return this.mySessionId;
    }
}

