/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class StateCache<T> {
    private PersistentHashMap<String, T> myMap;
    private final File myBaseFile;

    public StateCache(@NonNls File storePath) throws IOException {
        this.myBaseFile = storePath;
        this.myMap = this.createMap(storePath);
    }

    protected abstract T read(DataInput var1) throws IOException;

    protected abstract void write(T var1, DataOutput var2) throws IOException;

    public void force() {
        this.myMap.force();
    }

    public void close() throws IOException {
        this.myMap.close();
    }

    public boolean wipe() {
        try {
            this.myMap.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PersistentHashMap.deleteFilesStartingWith((File)this.myBaseFile);
        try {
            this.myMap = this.createMap(this.myBaseFile);
        }
        catch (IOException ignored) {
            return false;
        }
        return true;
    }

    public void update(@NonNls String url, T state) throws IOException {
        if (state != null) {
            this.myMap.put((Object)url, state);
        } else {
            this.remove(url);
        }
    }

    public void remove(String url) throws IOException {
        this.myMap.remove((Object)url);
    }

    public T getState(String url) throws IOException {
        return (T)this.myMap.get((Object)url);
    }

    public Collection<String> getUrls() throws IOException {
        return this.myMap.getAllKeysWithExistingMapping();
    }

    public Iterator<String> getUrlsIterator() throws IOException {
        return this.myMap.getAllKeysWithExistingMapping().iterator();
    }

    private PersistentHashMap<String, T> createMap(File file2) throws IOException {
        return new PersistentHashMap(file2, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, new DataExternalizer<T>(){

            public void save(@NotNull DataOutput out, T value2) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/compiler/impl/StateCache$1", "save"));
                }
                StateCache.this.write(value2, out);
            }

            public T read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/compiler/impl/StateCache$1", "read"));
                }
                return StateCache.this.read(in);
            }
        });
    }
}

