/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.options.ProcessorProfilePanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.SmartList;
import com.intellij.util.ui.EditableTreeModel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.compiler.ProcessorConfigProfileImpl;

public class AnnotationProcessorsPanel
extends JPanel {
    private final ProcessorConfigProfile myDefaultProfile = new ProcessorConfigProfileImpl("");
    private final List<ProcessorConfigProfile> myModuleProfiles = new ArrayList<ProcessorConfigProfile>();
    private final Map<String, Module> myAllModulesMap = new HashMap<String, Module>();
    private final Project myProject;
    private final Tree myTree;
    private final ProcessorProfilePanel myProfilePanel;
    private ProcessorConfigProfile mySelectedProfile = null;

    public AnnotationProcessorsPanel(Project project2) {
        super(new BorderLayout());
        Splitter splitter = new Splitter(false, 0.3f);
        this.add((Component)splitter, "Center");
        this.myProject = project2;
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            this.myAllModulesMap.put(module2.getName(), module2);
        }
        this.myTree = new Tree((TreeModel)new MyTreeModel());
        this.myTree.setRootVisible(false);
        JPanel treePanel = ToolbarDecorator.createDecorator((JTree)this.myTree).addExtraAction(new AnActionButton("Move to", AllIcons.Actions.Nextfile){

            public void actionPerformed(AnActionEvent e) {
                MyModuleNode node = (MyModuleNode)AnnotationProcessorsPanel.this.myTree.getSelectionPath().getLastPathComponent();
                TreePath[] selectedNodes = AnnotationProcessorsPanel.this.myTree.getSelectionPaths();
                ProcessorConfigProfile nodeProfile = ((ProfileNode)node.getParent()).myProfile;
                ArrayList<ProcessorConfigProfile> profiles = new ArrayList<ProcessorConfigProfile>();
                profiles.add(AnnotationProcessorsPanel.this.myDefaultProfile);
                for (ProcessorConfigProfile profile2 : AnnotationProcessorsPanel.this.myModuleProfiles) {
                    profiles.add(profile2);
                }
                profiles.remove(nodeProfile);
                JBList list2 = new JBList(profiles);
                JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle("Move to").setItemChoosenCallback(() -> {
                    Object value2 = list2.getSelectedValue();
                    if (value2 instanceof ProcessorConfigProfile) {
                        ProcessorConfigProfile chosenProfile = (ProcessorConfigProfile)value2;
                        Module toSelect2 = (Module)node.getUserObject();
                        if (selectedNodes != null) {
                            for (TreePath selectedNode : selectedNodes) {
                                Object node1 = selectedNode.getLastPathComponent();
                                if (!(node1 instanceof MyModuleNode)) continue;
                                Module module2 = (Module)((MyModuleNode)node1).getUserObject();
                                if (nodeProfile != AnnotationProcessorsPanel.this.myDefaultProfile) {
                                    nodeProfile.removeModuleName(module2.getName());
                                }
                                if (chosenProfile == AnnotationProcessorsPanel.this.myDefaultProfile) continue;
                                chosenProfile.addModuleName(module2.getName());
                            }
                        }
                        RootNode root = (RootNode)AnnotationProcessorsPanel.this.myTree.getModel().getRoot();
                        root.sync();
                        DefaultMutableTreeNode node1 = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)toSelect2);
                        if (node1 != null) {
                            TreeUtil.selectNode((JTree)AnnotationProcessorsPanel.this.myTree, (TreeNode)node1);
                        }
                    }
                }).createPopup();
                RelativePoint point = e.getInputEvent() instanceof MouseEvent ? this.getPreferredPopupPoint() : TreeUtil.getPointForSelection((JTree)AnnotationProcessorsPanel.this.myTree);
                popup.show(point);
            }

            public ShortcutSet getShortcut() {
                return ActionManager.getInstance().getAction("Move").getShortcutSet();
            }

            public boolean isEnabled() {
                return AnnotationProcessorsPanel.this.myTree.getSelectionPath() != null && AnnotationProcessorsPanel.this.myTree.getSelectionPath().getLastPathComponent() instanceof MyModuleNode && !AnnotationProcessorsPanel.this.myModuleProfiles.isEmpty();
            }
        }).createPanel();
        splitter.setFirstComponent((JComponent)treePanel);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new MyCellRenderer()));
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = AnnotationProcessorsPanel.this.myTree.getSelectionPath();
                if (path != null) {
                    ProcessorConfigProfile selectedProfile;
                    ProcessorConfigProfile nodeProfile;
                    Object node = path.getLastPathComponent();
                    if (node instanceof MyModuleNode) {
                        node = ((MyModuleNode)node).getParent();
                    }
                    if (node instanceof ProfileNode && (nodeProfile = ((ProfileNode)node).myProfile) != (selectedProfile = AnnotationProcessorsPanel.this.mySelectedProfile)) {
                        if (selectedProfile != null) {
                            AnnotationProcessorsPanel.this.myProfilePanel.saveTo(selectedProfile);
                        }
                        AnnotationProcessorsPanel.this.mySelectedProfile = nodeProfile;
                        AnnotationProcessorsPanel.this.myProfilePanel.setProfile(nodeProfile);
                    }
                }
            }
        });
        this.myProfilePanel = new ProcessorProfilePanel(project2);
        this.myProfilePanel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)6, (int)0, (int)0));
        splitter.setSecondComponent((JComponent)this.myProfilePanel);
    }

    public void initProfiles(ProcessorConfigProfile defaultProfile, Collection<ProcessorConfigProfile> moduleProfiles) {
        this.myDefaultProfile.initFrom(defaultProfile);
        this.myModuleProfiles.clear();
        for (ProcessorConfigProfile profile2 : moduleProfiles) {
            ProcessorConfigProfileImpl copy = new ProcessorConfigProfileImpl("");
            copy.initFrom(profile2);
            this.myModuleProfiles.add((ProcessorConfigProfile)copy);
        }
        RootNode root = (RootNode)this.myTree.getModel().getRoot();
        root.sync();
        DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)this.myDefaultProfile);
        if (node != null) {
            TreeUtil.selectNode((JTree)this.myTree, (TreeNode)node);
        }
    }

    public ProcessorConfigProfile getDefaultProfile() {
        ProcessorConfigProfile selectedProfile = this.mySelectedProfile;
        if (this.myDefaultProfile == selectedProfile) {
            this.myProfilePanel.saveTo(selectedProfile);
        }
        return this.myDefaultProfile;
    }

    public List<ProcessorConfigProfile> getModuleProfiles() {
        ProcessorConfigProfile selectedProfile = this.mySelectedProfile;
        if (this.myDefaultProfile != selectedProfile) {
            this.myProfilePanel.saveTo(selectedProfile);
        }
        return this.myModuleProfiles;
    }

    private static class ModuleComparator
    implements Comparator<Module> {
        static final ModuleComparator INSTANCE = new ModuleComparator();

        private ModuleComparator() {
        }

        @Override
        public int compare(Module o1, Module o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class MyCellRenderer
    extends ColoredTreeCellRenderer {
        private MyCellRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value2 instanceof ProfileNode) {
                this.append(((ProfileNode)value2).myProfile.getName());
            } else if (value2 instanceof MyModuleNode) {
                Module module2 = (Module)((MyModuleNode)value2).getUserObject();
                this.setIcon(AllIcons.Nodes.Module);
                this.append(module2.getName());
            }
        }
    }

    private static class MyModuleNode
    extends DefaultMutableTreeNode {
        public MyModuleNode(Module module2, ProfileNode parent) {
            super(module2);
            this.setParent(parent);
            this.setAllowsChildren(false);
        }
    }

    private class ProfileNode
    extends DefaultMutableTreeNode
    implements DataSynchronizable {
        private final ProcessorConfigProfile myProfile;
        private final boolean myIsDefault;

        public ProfileNode(ProcessorConfigProfile profile2, RootNode parent, boolean isDefault) {
            super(profile2);
            this.setParent(parent);
            this.myIsDefault = isDefault;
            this.myProfile = profile2;
        }

        @Override
        public DataSynchronizable sync() {
            ArrayList<Object> nodeModules = new ArrayList<Object>();
            if (this.myIsDefault) {
                HashSet nonDefaultProfileModules = new HashSet();
                for (ProcessorConfigProfile processorConfigProfile : AnnotationProcessorsPanel.this.myModuleProfiles) {
                    nonDefaultProfileModules.addAll(processorConfigProfile.getModuleNames());
                }
                for (Map.Entry entry : AnnotationProcessorsPanel.this.myAllModulesMap.entrySet()) {
                    if (nonDefaultProfileModules.contains(entry.getKey())) continue;
                    nodeModules.add(entry.getValue());
                }
            } else {
                for (String moduleName : this.myProfile.getModuleNames()) {
                    Module module2 = (Module)AnnotationProcessorsPanel.this.myAllModulesMap.get(moduleName);
                    if (module2 == null) continue;
                    nodeModules.add(module2);
                }
            }
            Collections.sort(nodeModules, ModuleComparator.INSTANCE);
            Vector<MyModuleNode> vector = new Vector<MyModuleNode>();
            for (Module module3 : nodeModules) {
                vector.add(new MyModuleNode(module3, this));
            }
            this.children = vector;
            return this;
        }
    }

    private static interface DataSynchronizable {
        public DataSynchronizable sync();
    }

    private class RootNode
    extends DefaultMutableTreeNode
    implements DataSynchronizable {
        private RootNode() {
        }

        @Override
        public DataSynchronizable sync() {
            Vector<DataSynchronizable> newKids = new Vector<DataSynchronizable>();
            newKids.add(new ProfileNode(AnnotationProcessorsPanel.this.myDefaultProfile, this, true).sync());
            for (ProcessorConfigProfile profile2 : AnnotationProcessorsPanel.this.myModuleProfiles) {
                newKids.add(new ProfileNode(profile2, this, false).sync());
            }
            this.children = newKids;
            ((DefaultTreeModel)AnnotationProcessorsPanel.this.myTree.getModel()).reload();
            TreeUtil.expandAll((JTree)AnnotationProcessorsPanel.this.myTree);
            return this;
        }
    }

    private class MyTreeModel
    extends DefaultTreeModel
    implements EditableTreeModel {
        public MyTreeModel() {
            super(new RootNode());
        }

        public TreePath addNode(TreePath parentOrNeighbour) {
            String newProfileName = Messages.showInputDialog((Project)AnnotationProcessorsPanel.this.myProject, (String)"Profile name", (String)"Create new profile", null, (String)"", (InputValidator)new InputValidatorEx(){

                public boolean checkInput(String inputString) {
                    if (StringUtil.isEmpty((String)inputString) || Comparing.equal((String)inputString, (String)AnnotationProcessorsPanel.this.myDefaultProfile.getName())) {
                        return false;
                    }
                    for (ProcessorConfigProfile profile2 : AnnotationProcessorsPanel.this.myModuleProfiles) {
                        if (!Comparing.equal((String)inputString, (String)profile2.getName())) continue;
                        return false;
                    }
                    return true;
                }

                public boolean canClose(String inputString) {
                    return this.checkInput(inputString);
                }

                public String getErrorText(String inputString) {
                    if (this.checkInput(inputString)) {
                        return null;
                    }
                    return StringUtil.isEmpty((String)inputString) ? "Profile name shouldn't be empty" : "Profile " + inputString + " already exists";
                }
            });
            if (newProfileName != null) {
                ProcessorConfigProfileImpl profile2 = new ProcessorConfigProfileImpl(newProfileName);
                AnnotationProcessorsPanel.this.myModuleProfiles.add(profile2);
                ((DataSynchronizable)this.getRoot()).sync();
                DefaultMutableTreeNode object = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.getRoot()), (Object)profile2);
                if (object != null) {
                    TreeUtil.selectNode((JTree)AnnotationProcessorsPanel.this.myTree, (TreeNode)object);
                }
            }
            return null;
        }

        public void removeNode(TreePath nodePath) {
            this.removeNodes(Collections.singleton(nodePath));
        }

        public void removeNodes(Collection<TreePath> paths) {
            SmartList toRemove2 = new SmartList();
            for (TreePath treePath : paths) {
                ProcessorConfigProfile nodeProfile;
                Object node = treePath.getLastPathComponent();
                if (!(node instanceof ProfileNode) || (nodeProfile = ((ProfileNode)node).myProfile) == AnnotationProcessorsPanel.this.myDefaultProfile) continue;
                toRemove2.add(nodeProfile);
            }
            if (!toRemove2.isEmpty()) {
                boolean changed = false;
                for (ProcessorConfigProfile nodeProfile : toRemove2) {
                    if (AnnotationProcessorsPanel.this.mySelectedProfile == nodeProfile) {
                        AnnotationProcessorsPanel.this.mySelectedProfile = null;
                    }
                    changed |= AnnotationProcessorsPanel.this.myModuleProfiles.remove(nodeProfile);
                }
                if (changed) {
                    ((DataSynchronizable)this.getRoot()).sync();
                    DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.getRoot()), (Object)AnnotationProcessorsPanel.this.myDefaultProfile);
                    if (defaultMutableTreeNode != null) {
                        TreeUtil.selectNode((JTree)AnnotationProcessorsPanel.this.myTree, (TreeNode)defaultMutableTreeNode);
                    }
                }
            }
        }

        public void moveNodeTo(TreePath parentOrNeighbour) {
        }
    }
}

