/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.options.ValidationConfiguration;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.generic.GenericCompiler;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfigurable;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ValidationConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myPanel;
    private JCheckBox myValidateBox;
    private ElementsChooser<Compiler> myValidators;
    private JPanel myExcludedEntriesPanel;
    private final Project myProject;
    private final ValidationConfiguration myConfiguration;
    private final ExcludedEntriesConfigurable myExcludedConfigurable;

    public ValidationConfigurable(Project project2) {
        this.myProject = project2;
        this.$$$setupUI$$$();
        this.myConfiguration = ValidationConfiguration.getInstance(this.myProject);
        this.myExcludedConfigurable = ValidationConfigurable.createExcludedConfigurable(project2);
        this.myValidators.getEmptyText().setText(CompilerBundle.message((String)"no.validators", (Object[])new Object[0]));
    }

    private static ExcludedEntriesConfigurable createExcludedConfigurable(final Project project2) {
        ExcludesConfiguration configuration = ValidationConfiguration.getExcludedEntriesConfiguration(project2);
        final ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true){

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                return super.isFileVisible(file2, showHiddenFiles) && (project2.isDefault() || !index.isExcluded(file2));
            }
        };
        ArrayList allContentRoots = new ArrayList();
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            VirtualFile[] moduleContentRoots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
            Collections.addAll(allContentRoots, moduleContentRoots);
        }
        descriptor.setRoots(allContentRoots);
        return new ExcludedEntriesConfigurable(project2, descriptor, configuration);
    }

    @NotNull
    public String getId() {
        if ("project.validation" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/options/ValidationConfigurable", "getId"));
        }
        return "project.validation";
    }

    public String getDisplayName() {
        return CompilerBundle.message((String)"validation.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.projectsettings.compiler.validation";
    }

    public JComponent createComponent() {
        GridConstraints constraints = new GridConstraints();
        constraints.setFill(3);
        this.myExcludedEntriesPanel.add((Component)this.myExcludedConfigurable.createComponent(), constraints);
        return this.myPanel;
    }

    public boolean isModified() {
        List<Compiler> selectedElements = this.myValidators.getMarkedElements();
        List<Compiler> markedValidators = this.getMarkedValidators();
        if (markedValidators.size() != selectedElements.size()) {
            return true;
        }
        THashSet set2 = new THashSet(selectedElements, (TObjectHashingStrategy)new TObjectHashingStrategy<Compiler>(){

            public int computeHashCode(Compiler object) {
                return object.getDescription().hashCode();
            }

            public boolean equals(Compiler o1, Compiler o2) {
                return o1.getDescription().equals(o2.getDescription());
            }
        });
        return this.myConfiguration.VALIDATE_ON_BUILD != this.myValidateBox.isSelected() || set2.retainAll(markedValidators) || this.myExcludedConfigurable.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myConfiguration.VALIDATE_ON_BUILD = this.myValidateBox.isSelected();
        for (int i2 = 0; i2 < this.myValidators.getElementCount(); ++i2) {
            Compiler validator = (Compiler)this.myValidators.getElementAt(i2);
            this.myConfiguration.setSelected(validator, this.myValidators.isElementMarked(validator));
        }
        this.myExcludedConfigurable.apply();
    }

    public void reset() {
        this.myValidateBox.setSelected(this.myConfiguration.VALIDATE_ON_BUILD);
        List<Compiler> validators = this.getValidators();
        Collections.sort(validators, Comparator.comparing(Compiler::getDescription));
        this.myValidators.setElements(validators, false);
        this.myValidators.markElements(this.getMarkedValidators());
        this.myExcludedConfigurable.reset();
    }

    private List<Compiler> getMarkedValidators() {
        List<Compiler> validators = this.getValidators();
        return ContainerUtil.mapNotNull(validators, (Function)((NullableFunction)validator -> this.myConfiguration.isSelected((Compiler)validator) ? validator : null));
    }

    private List<Compiler> getValidators() {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        ArrayList<Compiler> validators = new ArrayList<Compiler>();
        validators.addAll(Arrays.asList(compilerManager.getCompilers(Validator.class)));
        for (GenericCompiler compiler : (GenericCompiler[])compilerManager.getCompilers(GenericCompiler.class)) {
            if (compiler.getOrderPlace() != GenericCompiler.CompileOrderPlace.VALIDATING) continue;
            validators.add(compiler);
        }
        return validators;
    }

    public void disposeUIResources() {
        this.myExcludedConfigurable.disposeUIResources();
    }

    private void createUIComponents() {
        this.myValidators = new ElementsChooser<Compiler>(true){

            @Override
            protected String getItemText(@NotNull Compiler validator) {
                if (validator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "com/intellij/compiler/options/ValidationConfigurable$3", "getItemText"));
                }
                String description = validator.getDescription();
                return description.replace(" Validator", "").replace(" validator", "");
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myValidateBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Validate on build");
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndentWithoutInsets.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Validators", (int)0, (int)0, null, null));
        ElementsChooser<Compiler> elementsChooser = this.myValidators;
        elementsChooser.setColorUnmarkedElements(false);
        jPanel4.add(elementsChooser, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 50), null));
        this.myExcludedEntriesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndentWithoutInsets.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Exclude From Validation", (int)0, (int)0, null, null));
        Splitter splitter = new Splitter();
        splitter.setOrientation(true);
        jPanel3.add((Component)splitter, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        splitter.setFirstComponent((JComponent)jPanel4);
        splitter.setSecondComponent((JComponent)jPanel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

