/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ProjectStateStorageManager;
import com.intellij.configurationStore.ProjectStoreBase;
import com.intellij.configurationStore.ProjectStoreImplKt;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectNameProvider;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.PathKt;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0003\n\u0002\b\b\b\u0012\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u0010H\u0014JH\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00102\u0018\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u00152\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0014J\b\u0010\u0019\u001a\u00020\u0005H\u0004J\b\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\bH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/configurationStore/ProjectStoreImpl;", "Lcom/intellij/configurationStore/ProjectStoreBase;", "project", "Lcom/intellij/openapi/project/impl/ProjectImpl;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "(Lcom/intellij/openapi/project/impl/ProjectImpl;Lcom/intellij/openapi/components/PathMacroManager;)V", "lastSavedProjectName", "", "storageManager", "Lcom/intellij/configurationStore/ProjectStateStorageManager;", "getStorageManager", "()Lcom/intellij/configurationStore/ProjectStateStorageManager;", "beforeSave", "", "readonlyFiles", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/components/StateStorage$SaveSession;", "Lcom/intellij/openapi/vfs/VirtualFile;", "doSave", "", "", "saveSessions", "prevErrors", "getPathMacroManagerForDefaults", "getProjectName", "saveProjectName", "setPath", "filePath", "configuration-store-impl"})
class ProjectStoreImpl
extends ProjectStoreBase {
    private String lastSavedProjectName;
    @NotNull
    private final ProjectStateStorageManager storageManager;
    private final PathMacroManager pathMacroManager;

    @Override
    @NotNull
    protected final PathMacroManager getPathMacroManagerForDefaults() {
        return this.pathMacroManager;
    }

    @Override
    @NotNull
    public ProjectStateStorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public void setPath(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        this.setPath(filePath, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getProjectName() {
        String string;
        String string2;
        String baseDir;
        block25: {
            Object[] $receiver$iv;
            if (!this.isDirectoryBased()) {
                return StringsKt.removeSuffix((String)PathUtilRt.getFileName((String)this.getProjectFilePath()), (CharSequence)".ipr");
            }
            baseDir = this.getProjectBasePath();
            Path nameFile = ProjectStoreImplKt.getNameFile(this);
            if (PathKt.exists((Path)nameFile)) {
                $receiver$iv = ComponentStoreImplKt.getLOG();
                try {
                    BufferedReader bufferedReader;
                    Closeable closeable = PathKt.inputStream((Path)nameFile);
                    Object object = Charsets.UTF_8;
                    Reader $receiver$iv2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                    object = $receiver$iv2;
                    int n = 8192;
                    object = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
                    n = 0;
                    try {
                        String string3;
                        Object v0;
                        Object $receiver$iv3;
                        BufferedReader it$iv;
                        block23: {
                            Sequence it;
                            it$iv = (BufferedReader)object;
                            $receiver$iv3 = it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                            for (Object element$iv : $receiver$iv3) {
                                String it2 = (String)element$iv;
                                CharSequence charSequence = it2;
                                if (!(!(charSequence.length() == 0))) continue;
                                v0 = element$iv;
                                break block23;
                            }
                            v0 = null;
                        }
                        String string4 = v0;
                        if (string4 != null) {
                            Object object2 = $receiver$iv3 = string4;
                            if (object2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            string3 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
                        } else {
                            string3 = null;
                        }
                        it$iv = string3;
                        bufferedReader = it$iv;
                    }
                    catch (Exception it$iv) {
                        n = 1;
                        try {
                            object.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw (Throwable)it$iv;
                    }
                    finally {
                        if (n == 0) {
                            object.close();
                        }
                    }
                    if (bufferedReader != null) {
                        Closeable it = closeable = bufferedReader;
                        this.lastSavedProjectName = it;
                        return it;
                    }
                }
                catch (ProcessCanceledException e$iv) {
                }
                catch (Throwable e$iv) {
                    $receiver$iv.error(e$iv);
                }
            }
            $receiver$iv = ProjectNameProvider.EP_NAME.getExtensions();
            for (int j = 0; j < $receiver$iv.length; ++j) {
                String result$iv;
                String string5;
                Object file$iv = $receiver$iv[j];
                ProjectNameProvider it = (ProjectNameProvider)file$iv;
                Logger $receiver$iv4 = ComponentStoreImplKt.getLOG();
                try {
                    string5 = it.getDefaultName(this.getProject$configuration_store_impl());
                }
                catch (ProcessCanceledException e$iv) {
                    string5 = null;
                }
                catch (Throwable e$iv) {
                    $receiver$iv4.error(e$iv);
                    string5 = result$iv = null;
                }
                if (result$iv == null) continue;
                string2 = result$iv;
                break block25;
            }
            string2 = string = null;
        }
        if (string2 == null) {
            string = StringsKt.replace$default((String)PathUtilRt.getFileName((String)baseDir), (String)":", (String)"", (boolean)false, (int)4, null);
        }
        return string;
    }

    private final void saveProjectName() {
        if (!this.isDirectoryBased()) {
            return;
        }
        String currentProjectName = this.getProject$configuration_store_impl().getName();
        if (Intrinsics.areEqual((Object)this.lastSavedProjectName, (Object)currentProjectName)) {
            return;
        }
        this.lastSavedProjectName = currentProjectName;
        String basePath = this.getProjectBasePath();
        if (Intrinsics.areEqual((Object)currentProjectName, (Object)PathUtilRt.getFileName((String)basePath))) {
            PathKt.delete((Path)ProjectStoreImplKt.getNameFile(this));
        } else if (PathKt.isDirectory((Path)Paths.get(basePath, new String[0]))) {
            String string = currentProjectName;
            Path path = ProjectStoreImplKt.getNameFile(this);
            Charset charset = Charsets.UTF_8;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            PathKt.write$default((Path)path, (byte[])byArray2, (int)0, (int)0, (int)6, null);
        }
    }

    @Override
    @Nullable
    protected List<Throwable> doSave(@NotNull List<? extends StateStorage.SaveSession> saveSessions, @NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles, @Nullable List<Throwable> prevErrors) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull(saveSessions, (String)"saveSessions");
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
        try {
            this.saveProjectName();
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Unable to store project name", e);
        }
        List<Throwable> errors = prevErrors;
        this.beforeSave(readonlyFiles);
        errors = super.doSave(saveSessions, readonlyFiles, errors);
        ProjectManagerImpl.UnableToSaveProjectNotification[] notifications = (ProjectManagerImpl.UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectManagerImpl.UnableToSaveProjectNotification.class, (Project)this.getProject$configuration_store_impl());
        if (readonlyFiles.isEmpty()) {
            for (int j = 0; j < notifications.length; ++j) {
                ProjectManagerImpl.UnableToSaveProjectNotification notification = notifications[j];
                notification.expire();
            }
            return errors;
        }
        Object[] notification = (Object[])notifications;
        if (!(notification.length == 0)) {
            throw (Throwable)new IComponentStore.SaveCancelledException();
        }
        ReadonlyStatusHandler.OperationStatus status = (ReadonlyStatusHandler.OperationStatus)ApplicationManager.getApplication().runReadAction(new Computable<T>(this, readonlyFiles){
            final /* synthetic */ ProjectStoreImpl this$0;
            final /* synthetic */ List $readonlyFiles$inlined;
            {
                this.this$0 = projectStoreImpl;
                this.$readonlyFiles$inlined = list2;
            }

            public final T compute() {
                VirtualFile[] virtualFileArray = ProjectStoreImplKt.access$getFilesList(this.$readonlyFiles$inlined);
                return (T)ReadonlyStatusHandler.getInstance((Project)this.this$0.getProject$configuration_store_impl()).ensureFilesWritable(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
            }
        });
        if (status.hasReadonlyFiles()) {
            Project project2 = this.getProject$configuration_store_impl();
            VirtualFile[] virtualFileArray = status.getReadonlyFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"status.readonlyFiles");
            ProjectStoreImplKt.access$dropUnableToSaveProjectNotification(project2, virtualFileArray);
            throw (Throwable)new IComponentStore.SaveCancelledException();
        }
        Collection thisCollection$iv = $receiver$iv = (Collection)readonlyFiles;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[thisCollection$iv.size()]);
        if (pairArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Pair[] oldList = pairArray;
        readonlyFiles.clear();
        for (int j = 0; j < oldList.length; ++j) {
            Pair entry = oldList[j];
            Object object = entry.first;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"entry.first");
            errors = ComponentStoreImplKt.executeSave((StateStorage.SaveSession)object, readonlyFiles, errors);
        }
        CompoundRuntimeException.throwIfNotEmpty(errors);
        if (!readonlyFiles.isEmpty()) {
            ProjectStoreImplKt.access$dropUnableToSaveProjectNotification(this.getProject$configuration_store_impl(), ProjectStoreImplKt.access$getFilesList(readonlyFiles));
            throw (Throwable)new IComponentStore.SaveCancelledException();
        }
        return errors;
    }

    protected void beforeSave(@NotNull List<? extends Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
    }

    public ProjectStoreImpl(@NotNull ProjectImpl project2, @NotNull PathMacroManager pathMacroManager) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)pathMacroManager, (String)"pathMacroManager");
        super(project2);
        this.pathMacroManager = pathMacroManager;
        boolean bl2 = bl = !project2.isDefault();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        TrackingPathMacroSubstitutor trackingPathMacroSubstitutor = this.pathMacroManager.createTrackingSubstitutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)trackingPathMacroSubstitutor, (String)"pathMacroManager.createTrackingSubstitutor()");
        this.storageManager = new ProjectStateStorageManager(trackingPathMacroSubstitutor, project2, false, 4, null);
    }
}

