/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ReloadComponentStoreStatus;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\b\u001a\u0014\u0010\u0011\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f\u001a\u001c\u0010\u0013\u001a\u00020\u00142\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\t\u001a\u00020\u0003\"9\u0010\u0000\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004 \u0005*\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"CHANGED_FILES_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "Lcom/intellij/openapi/components/StateStorage;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "askToRestart", "", "store", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "notReloadableComponents", "", "", "changedStorages", "", "isApp", "reloadAppStore", "changes", "reloadStore", "Lcom/intellij/configurationStore/ReloadComponentStoreStatus;", "configuration-store-impl"})
public final class StoreAwareProjectManagerKt {
    private static final Key<MultiMap<ComponentStoreImpl, StateStorage>> CHANGED_FILES_KEY = Key.create((String)"CHANGED_FILES_KEY");

    public static final boolean reloadAppStore(@NotNull Set<? extends StateStorage> changes) {
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication());
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        }
        ReloadComponentStoreStatus status = StoreAwareProjectManagerKt.reloadStore(changes, (ComponentStoreImpl)iComponentStore);
        if (Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ReloadComponentStoreStatus.RESTART_AGREED))) {
            ApplicationManagerEx.getApplicationEx().restart(true);
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ReloadComponentStoreStatus.SUCCESS)) || Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ReloadComponentStoreStatus.RESTART_CANCELLED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ReloadComponentStoreStatus reloadStore(@NotNull Set<? extends StateStorage> changedStorages, @NotNull ComponentStoreImpl store) {
        Intrinsics.checkParameterIsNotNull(changedStorages, (String)"changedStorages");
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        boolean willBeReloaded = false;
        try {
            Collection<String> notReloadableComponents;
            try {
                notReloadableComponents = store.reload(changedStorages);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().warn(e);
                Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.ERROR;
                if (!willBeReloaded) {
                    for (StateStorage stateStorage : changedStorages) {
                        if (!(stateStorage instanceof StateStorageBase)) continue;
                        ((StateStorageBase)stateStorage).enableSaving();
                    }
                }
                return reloadComponentStoreStatus;
            }
            if (notReloadableComponents == null || notReloadableComponents.isEmpty()) {
                ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.SUCCESS;
                return reloadComponentStoreStatus;
            }
            willBeReloaded = StoreAwareProjectManagerKt.askToRestart(store, notReloadableComponents, changedStorages, store.getProject$configuration_store_impl() == null);
            ReloadComponentStoreStatus reloadComponentStoreStatus = willBeReloaded ? ReloadComponentStoreStatus.RESTART_AGREED : ReloadComponentStoreStatus.RESTART_CANCELLED;
            return reloadComponentStoreStatus;
        }
        finally {
            if (!willBeReloaded) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).enableSaving();
                }
            }
        }
    }

    public static final boolean askToRestart(@NotNull IComponentStore store, @NotNull Collection<String> notReloadableComponents, @Nullable Set<? extends StateStorage> changedStorages, boolean isApp) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Intrinsics.checkParameterIsNotNull(notReloadableComponents, (String)"notReloadableComponents");
        StringBuilder message2 = new StringBuilder();
        String storeName = store instanceof IProjectStore ? "Project '" + ((IProjectStore)store).getProjectName() + "'" : "Application";
        message2.append(storeName).append(' ');
        message2.append("components were changed externally and cannot be reloaded:\n\n");
        int count = 0;
        for (String string : notReloadableComponents) {
            if (count == 10) {
                message2.append('\n').append("and ").append(notReloadableComponents.size() - count).append(" more").append('\n');
                continue;
            }
            message2.append(string).append('\n');
            ++count;
        }
        message2.append("\nWould you like to ");
        if (isApp) {
            message2.append(ApplicationManager.getApplication().isRestartCapable() ? "restart" : "shutdown").append(' ');
            message2.append(ApplicationNamesInfo.getInstance().getProductName()).append('?');
        } else {
            message2.append("reload project?");
        }
        if (Messages.showYesNoDialog((String)message2.toString(), (String)(storeName + " Files Changed"), (Icon)Messages.getQuestionIcon()) == 0) {
            if (changedStorages != null) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).disableSaving();
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static final /* synthetic */ Key access$getCHANGED_FILES_KEY$p() {
        return CHANGED_FILES_KEY;
    }
}

