/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Comparing;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CoreProjectJdkTable
extends ProjectJdkTable {
    private final List<Sdk> mySdks = new ArrayList<Sdk>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sdk findJdk(String name2) {
        List<Sdk> list2 = this.mySdks;
        synchronized (list2) {
            for (Sdk jdk : this.mySdks) {
                if (!Comparing.strEqual((String)name2, (String)jdk.getName())) continue;
                return jdk;
            }
        }
        return null;
    }

    public Sdk findJdk(String name2, String type2) {
        return this.findJdk(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Sdk[] getAllJdks() {
        List<Sdk> list2 = this.mySdks;
        // MONITORENTER : list2
        Sdk[] sdkArray = this.mySdks.toArray(new Sdk[this.mySdks.size()]);
        // MONITOREXIT : list2
        if (sdkArray != null) return sdkArray;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectJdkTable", "getAllJdks"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Sdk> getSdksOfType(@NotNull SdkTypeId type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/core/CoreProjectJdkTable", "getSdksOfType"));
        }
        ArrayList<Sdk> result2 = new ArrayList<Sdk>();
        List<Sdk> list2 = this.mySdks;
        synchronized (list2) {
            for (Sdk sdk : this.mySdks) {
                if (sdk.getSdkType() != type2) continue;
                result2.add(sdk);
            }
        }
        ArrayList<Sdk> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectJdkTable", "getSdksOfType"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/core/CoreProjectJdkTable", "addJdk"));
        }
        List<Sdk> list2 = this.mySdks;
        synchronized (list2) {
            this.mySdks.add(jdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/core/CoreProjectJdkTable", "removeJdk"));
        }
        List<Sdk> list2 = this.mySdks;
        synchronized (list2) {
            this.mySdks.remove(jdk);
        }
    }

    public void updateJdk(@NotNull Sdk originalJdk, @NotNull Sdk modifiedJdk) {
        if (originalJdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalJdk", "com/intellij/core/CoreProjectJdkTable", "updateJdk"));
        }
        if (modifiedJdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiedJdk", "com/intellij/core/CoreProjectJdkTable", "updateJdk"));
        }
        throw new UnsupportedOperationException();
    }

    public void addListener(@NotNull ProjectJdkTable.Listener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/core/CoreProjectJdkTable", "addListener"));
        }
    }

    public void removeListener(@NotNull ProjectJdkTable.Listener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/core/CoreProjectJdkTable", "removeListener"));
        }
    }

    @NotNull
    public SdkTypeId getDefaultSdkType() {
        CoreSdkType coreSdkType = CoreSdkType.INSTANCE;
        if (coreSdkType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectJdkTable", "getDefaultSdkType"));
        }
        return coreSdkType;
    }

    @NotNull
    public SdkTypeId getSdkTypeByName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreProjectJdkTable", "getSdkTypeByName"));
        }
        CoreSdkType coreSdkType = CoreSdkType.INSTANCE;
        if (coreSdkType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectJdkTable", "getSdkTypeByName"));
        }
        return coreSdkType;
    }

    @NotNull
    public Sdk createSdk(@NotNull String name2, @NotNull SdkTypeId sdkType) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreProjectJdkTable", "createSdk"));
        }
        if (sdkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkType", "com/intellij/core/CoreProjectJdkTable", "createSdk"));
        }
        throw new UnsupportedOperationException();
    }
}

