/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.ViewAsGroup;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.UserRenderersConfigurable;
import com.intellij.debugger.ui.tree.render.CompoundTypeRenderer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableBase;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Type;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateRendererAction
extends AnAction {
    public void update(AnActionEvent e) {
        List<JavaValue> values = ViewAsGroup.getSelectedValues(e);
        if (values.size() != 1) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/actions/CreateRendererAction", "actionPerformed"));
        }
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(event.getDataContext());
        List<JavaValue> values = ViewAsGroup.getSelectedValues(event);
        if (values.size() != 1) {
            return;
        }
        final JavaValue javaValue = values.get(0);
        DebugProcessImpl process2 = debuggerContext.getDebugProcess();
        if (process2 == null) {
            return;
        }
        final Project project2 = event.getProject();
        process2.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

            @Override
            public void threadAction() {
                Type type2 = javaValue.getDescriptor().getType();
                String name2 = type2 != null ? type2.name() : null;
                DebuggerUIUtil.invokeLater(() -> {
                    final UserRenderersConfigurable ui = new UserRenderersConfigurable();
                    ConfigurableBase<UserRenderersConfigurable, NodeRendererSettings> configurable = new ConfigurableBase<UserRenderersConfigurable, NodeRendererSettings>("reference.idesettings.debugger.typerenderers", DebuggerBundle.message((String)"user.renderers.configurable.display.name", (Object[])new Object[0]), "reference.idesettings.debugger.typerenderers"){

                        @NotNull
                        protected NodeRendererSettings getSettings() {
                            NodeRendererSettings nodeRendererSettings = NodeRendererSettings.getInstance();
                            if (nodeRendererSettings == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/CreateRendererAction$1$1", "getSettings"));
                            }
                            return nodeRendererSettings;
                        }

                        protected UserRenderersConfigurable createUi() {
                            return ui;
                        }
                    };
                    SingleConfigurableEditor editor = new SingleConfigurableEditor(project2, (Configurable)configurable);
                    if (name2 != null) {
                        CompoundTypeRenderer renderer = NodeRendererSettings.getInstance().createCompoundTypeRenderer(name2, name2, null, null);
                        renderer.setEnabled(true);
                        ui.addRenderer(renderer);
                    }
                    editor.show();
                });
            }
        });
    }
}

