/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.ViewAsGroup;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.memory.ui.StackFramePopup;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ShowRelatedStackAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        List<StackFrameItem> stack = ShowRelatedStackAction.getRelatedStack(e);
        if (project2 != null && stack != null) {
            DebugProcessImpl debugProcess = DebuggerAction.getDebuggerContext(e.getDataContext()).getDebugProcess();
            if (debugProcess == null) {
                return;
            }
            StackFramePopup.show(stack, debugProcess);
        }
    }

    public void update(AnActionEvent e) {
        List<StackFrameItem> stack = ShowRelatedStackAction.getRelatedStack(e);
        e.getPresentation().setEnabledAndVisible(stack != null);
    }

    @Nullable
    private static List<StackFrameItem> getRelatedStack(AnActionEvent e) {
        Value value2;
        List<JavaValue> values = ViewAsGroup.getSelectedValues(e);
        if (values.size() == 1 && (value2 = values.get(0).getDescriptor().getValue()) instanceof ObjectReference) {
            DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
            return StackCapturingLineBreakpoint.getRelatedStack((ObjectReference)value2, debuggerContext.getDebugProcess());
        }
        return null;
    }
}

