/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerEx;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundPositionManager
extends PositionManagerEx
implements MultiRequestPositionManager {
    private static final Logger LOG = Logger.getInstance(CompoundPositionManager.class);
    public static final CompoundPositionManager EMPTY = new CompoundPositionManager();
    private final ArrayList<PositionManager> myPositionManagers = new ArrayList();
    private final Map<Location, SourcePosition> mySourcePositionCache = new WeakHashMap<Location, SourcePosition>();

    public CompoundPositionManager() {
    }

    public CompoundPositionManager(PositionManager manager) {
        this.appendPositionManager(manager);
    }

    public void appendPositionManager(PositionManager manager) {
        this.myPositionManagers.remove(manager);
        this.myPositionManagers.add(0, manager);
        this.clearCache();
    }

    public void clearCache() {
        this.mySourcePositionCache.clear();
    }

    private <T> T iterate(Processor<T> processor2, T defaultValue, SourcePosition position) {
        return this.iterate(processor2, defaultValue, position, true);
    }

    private <T> T iterate(Processor<T> processor2, T defaultValue, SourcePosition position, boolean ignorePCE) {
        for (PositionManager positionManager : this.myPositionManagers) {
            Set types;
            if (position != null && (types = positionManager.getAcceptedFileTypes()) != null && !types.contains(position.getFile().getFileType())) continue;
            try {
                if (!ignorePCE) {
                    ProgressManager.checkCanceled();
                }
                return DebuggerUtilsImpl.suppressExceptions(() -> processor2.process(positionManager), defaultValue, ignorePCE, NoDataException.class);
            }
            catch (NoDataException noDataException) {
            }
        }
        return defaultValue;
    }

    @Nullable
    public SourcePosition getSourcePosition(Location location) {
        if (location == null) {
            return null;
        }
        SourcePosition res = null;
        try {
            res = this.mySourcePositionCache.get(location);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (CompoundPositionManager.checkCacheEntry(res, location)) {
            return res;
        }
        return (SourcePosition)DebuggerUtilsImpl.runInReadActionWithWriteActionPriorityWithRetries(() -> this.iterate(positionManager -> {
            SourcePosition res1 = positionManager.getSourcePosition(location);
            this.mySourcePositionCache.put(location, res1);
            return res1;
        }, null, null, false));
    }

    private static boolean checkCacheEntry(@Nullable SourcePosition position, @NotNull Location location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/debugger/engine/CompoundPositionManager", "checkCacheEntry"));
        }
        if (position == null) {
            return false;
        }
        PsiFile psiFile = position.getFile();
        if (!psiFile.isValid()) {
            return false;
        }
        String url = DebuggerUtilsEx.getAlternativeSourceUrl(location.declaringType().name(), psiFile.getProject());
        if (url == null) {
            return true;
        }
        VirtualFile file2 = psiFile.getVirtualFile();
        return file2 != null && url.equals(file2.getUrl());
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition classPosition) {
        if (classPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPosition", "com/intellij/debugger/engine/CompoundPositionManager", "getAllClasses"));
        }
        List<ReferenceType> list2 = this.iterate(positionManager -> {
            if (classPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPosition", "com/intellij/debugger/engine/CompoundPositionManager", "lambda$getAllClasses$3"));
            }
            return positionManager.getAllClasses(classPosition);
        }, Collections.emptyList(), classPosition);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/CompoundPositionManager", "getAllClasses"));
        }
        return list2;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type2, @NotNull SourcePosition position) {
        int line;
        LineNumbersMapping mapping;
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/debugger/engine/CompoundPositionManager", "locationsOfLine"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/CompoundPositionManager", "locationsOfLine"));
        }
        VirtualFile file2 = position.getFile().getVirtualFile();
        if (file2 != null && (mapping = (LineNumbersMapping)file2.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY)) != null && (line = mapping.sourceToBytecode(position.getLine() + 1)) > -1) {
            position = SourcePosition.createFromLine((PsiFile)position.getFile(), (int)(line - 1));
        }
        SourcePosition finalPosition = position;
        List<Location> list2 = this.iterate(positionManager -> {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/debugger/engine/CompoundPositionManager", "lambda$locationsOfLine$4"));
            }
            return positionManager.locationsOfLine(type2, finalPosition);
        }, Collections.emptyList(), position);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/CompoundPositionManager", "locationsOfLine"));
        }
        return list2;
    }

    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/debugger/engine/CompoundPositionManager", "createPrepareRequest"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/CompoundPositionManager", "createPrepareRequest"));
        }
        return this.iterate(positionManager -> {
            if (requestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/debugger/engine/CompoundPositionManager", "lambda$createPrepareRequest$5"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/CompoundPositionManager", "lambda$createPrepareRequest$5"));
            }
            return positionManager.createPrepareRequest(requestor, position);
        }, null, position);
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/debugger/engine/CompoundPositionManager", "createPrepareRequests"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/CompoundPositionManager", "createPrepareRequests"));
        }
        List<ClassPrepareRequest> list2 = this.iterate(positionManager -> {
            if (requestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/debugger/engine/CompoundPositionManager", "lambda$createPrepareRequests$6"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/CompoundPositionManager", "lambda$createPrepareRequests$6"));
            }
            if (positionManager instanceof MultiRequestPositionManager) {
                return ((MultiRequestPositionManager)positionManager).createPrepareRequests(requestor, position);
            }
            ClassPrepareRequest prepareRequest = positionManager.createPrepareRequest(requestor, position);
            if (prepareRequest == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(prepareRequest);
        }, Collections.emptyList(), position);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/CompoundPositionManager", "createPrepareRequests"));
        }
        return list2;
    }

    @Override
    @Nullable
    public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl frame, @NotNull DebugProcessImpl debugProcess, @NotNull Location location) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/debugger/engine/CompoundPositionManager", "createStackFrame"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/engine/CompoundPositionManager", "createStackFrame"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/debugger/engine/CompoundPositionManager", "createStackFrame"));
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            if (!(positionManager instanceof PositionManagerEx)) continue;
            try {
                XStackFrame xStackFrame = ((PositionManagerEx)positionManager).createStackFrame(frame, debugProcess, location);
                if (xStackFrame == null) continue;
                return xStackFrame;
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return null;
    }

    @Override
    public ThreeState evaluateCondition(@NotNull EvaluationContext context, @NotNull StackFrameProxyImpl frame, @NotNull Location location, @NotNull String expression2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/engine/CompoundPositionManager", "evaluateCondition"));
        }
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/debugger/engine/CompoundPositionManager", "evaluateCondition"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/debugger/engine/CompoundPositionManager", "evaluateCondition"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/debugger/engine/CompoundPositionManager", "evaluateCondition"));
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            if (!(positionManager instanceof PositionManagerEx)) continue;
            try {
                ThreeState result2 = ((PositionManagerEx)positionManager).evaluateCondition(context, frame, location, expression2);
                if (result2 == ThreeState.UNSURE) continue;
                return result2;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return ThreeState.UNSURE;
    }

    private static interface Processor<T> {
        public T process(PositionManager var1) throws NoDataException;
    }
}

