/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaBreakpointHandler;
import com.intellij.debugger.engine.JavaBreakpointHandlerFactory;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValueMarker;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SourceCodeChecker;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.ui.ClassesFilteredView;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.AlternativeSourceNotificationProvider;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.ThreadsPanel;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

public class JavaDebugProcess
extends XDebugProcess {
    private final DebuggerSession myJavaSession;
    private final JavaDebuggerEditorsProvider myEditorsProvider;
    private final XBreakpointHandler<?>[] myBreakpointHandlers;
    private final NodeManagerImpl myNodeManager;
    private static final JavaBreakpointHandlerFactory[] ourDefaultBreakpointHandlerFactories = new JavaBreakpointHandlerFactory[]{JavaBreakpointHandler.JavaLineBreakpointHandler::new, JavaBreakpointHandler.JavaExceptionBreakpointHandler::new, JavaBreakpointHandler.JavaFieldBreakpointHandler::new, JavaBreakpointHandler.JavaMethodBreakpointHandler::new, JavaBreakpointHandler.JavaWildcardBreakpointHandler::new};

    public static JavaDebugProcess create(@NotNull XDebugSession session2, DebuggerSession javaSession) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/debugger/engine/JavaDebugProcess", "create"));
        }
        JavaDebugProcess res = new JavaDebugProcess(session2, javaSession);
        javaSession.getProcess().setXDebugProcess(res);
        return res;
    }

    protected JavaDebugProcess(final @NotNull XDebugSession session2, final DebuggerSession javaSession) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/debugger/engine/JavaDebugProcess", "<init>"));
        }
        super(session2);
        this.myJavaSession = javaSession;
        this.myEditorsProvider = new JavaDebuggerEditorsProvider();
        final DebugProcessImpl process2 = javaSession.getProcess();
        this.myBreakpointHandlers = (XBreakpointHandler[])StreamEx.of((Object[])ourDefaultBreakpointHandlerFactories).append(Extensions.getExtensions(JavaBreakpointHandlerFactory.EP_NAME)).map(factory -> factory.createHandler(process2)).toArray(XBreakpointHandler[]::new);
        this.myJavaSession.getContextManager().addListener(new DebuggerContextListener(){

            @Override
            public void changeEvent(final @NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
                if (newContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/engine/JavaDebugProcess$1", "changeEvent"));
                }
                if (event == DebuggerSession.Event.PAUSE || event == DebuggerSession.Event.CONTEXT || event == DebuggerSession.Event.REFRESH || event == DebuggerSession.Event.REFRESH_WITH_STACK && JavaDebugProcess.this.myJavaSession.isPaused()) {
                    final SuspendContextImpl newSuspendContext = newContext.getSuspendContext();
                    if (newSuspendContext != null && (JavaDebugProcess.this.shouldApplyContext(newContext) || event == DebuggerSession.Event.REFRESH_WITH_STACK)) {
                        process2.getManagerThread().schedule(new SuspendContextCommandImpl(newSuspendContext){

                            @Override
                            public void contextAction() throws Exception {
                                ThreadReferenceProxyImpl threadProxy = newContext.getThreadProxy();
                                newSuspendContext.initExecutionStacks(threadProxy);
                                Pair item = (Pair)ContainerUtil.getFirstItem(DebuggerUtilsEx.getEventDescriptors(newSuspendContext));
                                if (item != null) {
                                    XBreakpoint xBreakpoint = ((Breakpoint)item.getFirst()).getXBreakpoint();
                                    Event second = (Event)item.getSecond();
                                    if (xBreakpoint != null && second instanceof LocatableEvent && threadProxy != null && ((LocatableEvent)second).thread() == threadProxy.getThreadReference()) {
                                        ((XDebugSessionImpl)JavaDebugProcess.this.getSession()).breakpointReachedNoProcessing(xBreakpoint, newSuspendContext);
                                        JavaDebugProcess.this.unsetPausedIfNeeded(newContext);
                                        SourceCodeChecker.checkSource(newContext);
                                        return;
                                    }
                                }
                                JavaDebugProcess.this.getSession().positionReached((XSuspendContext)newSuspendContext);
                                JavaDebugProcess.this.unsetPausedIfNeeded(newContext);
                                SourceCodeChecker.checkSource(newContext);
                            }
                        });
                    }
                } else if (event == DebuggerSession.Event.ATTACHED) {
                    JavaDebugProcess.this.getSession().rebuildViews();
                }
            }
        });
        this.myNodeManager = new NodeManagerImpl(session2.getProject(), null){

            @Override
            @NotNull
            public DebuggerTreeNodeImpl createNode(NodeDescriptor descriptor, EvaluationContext evaluationContext) {
                DebuggerTreeNodeImpl debuggerTreeNodeImpl = new DebuggerTreeNodeImpl(null, descriptor);
                if (debuggerTreeNodeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaDebugProcess$2", "createNode"));
                }
                return debuggerTreeNodeImpl;
            }

            @Override
            public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor descriptor) {
                return new DebuggerTreeNodeImpl(null, descriptor);
            }

            @Override
            @NotNull
            public DebuggerTreeNodeImpl createMessageNode(String message2) {
                DebuggerTreeNodeImpl debuggerTreeNodeImpl = new DebuggerTreeNodeImpl(null, new MessageDescriptor(message2));
                if (debuggerTreeNodeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaDebugProcess$2", "createMessageNode"));
                }
                return debuggerTreeNodeImpl;
            }
        };
        session2.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                JavaDebugProcess.this.saveNodeHistory();
                this.showAlternativeNotification(session2.getCurrentStackFrame());
            }

            public void stackFrameChanged() {
                XStackFrame frame = session2.getCurrentStackFrame();
                if (frame instanceof JavaStackFrame) {
                    this.showAlternativeNotification(frame);
                    StackFrameProxyImpl frameProxy = ((JavaStackFrame)frame).getStackFrameProxy();
                    DebuggerContextUtil.setStackFrame(javaSession.getContextManager(), frameProxy);
                    JavaDebugProcess.this.saveNodeHistory(frameProxy);
                }
            }

            private void showAlternativeNotification(@Nullable XStackFrame frame) {
                VirtualFile file2;
                XSourcePosition position;
                if (frame != null && (position = frame.getSourcePosition()) != null && !AlternativeSourceNotificationProvider.fileProcessed(file2 = position.getFile())) {
                    EditorNotifications.getInstance((Project)session2.getProject()).updateNotifications(file2);
                }
            }
        });
    }

    private void unsetPausedIfNeeded(DebuggerContextImpl context) {
        SuspendContextImpl suspendContext = context.getSuspendContext();
        if (suspendContext != null && !suspendContext.suspends(context.getThreadProxy())) {
            ((XDebugSessionImpl)this.getSession()).unsetPaused();
        }
    }

    private boolean shouldApplyContext(DebuggerContextImpl context) {
        SuspendContextImpl suspendContext = context.getSuspendContext();
        SuspendContextImpl currentContext = (SuspendContextImpl)this.getSession().getSuspendContext();
        if (suspendContext != null && !((Object)((Object)suspendContext)).equals((Object)currentContext)) {
            return true;
        }
        JavaExecutionStack currentExecutionStack = currentContext != null ? currentContext.getActiveExecutionStack() : null;
        return currentExecutionStack == null || !Comparing.equal((Object)context.getThreadProxy(), (Object)currentExecutionStack.getThreadProxy());
    }

    public void saveNodeHistory() {
        this.saveNodeHistory(this.getDebuggerStateManager().getContext().getFrameProxy());
    }

    private void saveNodeHistory(final StackFrameProxyImpl frameProxy) {
        this.myJavaSession.getProcess().getManagerThread().invoke(new DebuggerCommandImpl(){

            @Override
            protected void action() throws Exception {
                JavaDebugProcess.this.myNodeManager.setHistoryByContext(frameProxy);
            }

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }
        });
    }

    private DebuggerStateManager getDebuggerStateManager() {
        return this.myJavaSession.getContextManager();
    }

    public DebuggerSession getDebuggerSession() {
        return this.myJavaSession;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        JavaDebuggerEditorsProvider javaDebuggerEditorsProvider = this.myEditorsProvider;
        if (javaDebuggerEditorsProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaDebugProcess", "getEditorsProvider"));
        }
        return javaDebuggerEditorsProvider;
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.myJavaSession.stepOver(false);
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        this.myJavaSession.stepInto(false, null);
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        this.myJavaSession.stepInto(true, null);
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.myJavaSession.stepOut();
    }

    public void stop() {
        this.myJavaSession.dispose();
        this.myNodeManager.dispose();
    }

    public void startPausing() {
        this.myJavaSession.pause();
    }

    public void resume(@Nullable XSuspendContext context) {
        this.myJavaSession.resume();
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/JavaDebugProcess", "runToPosition"));
        }
        this.myJavaSession.runToCursor(position, false);
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (this.myBreakpointHandlers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaDebugProcess", "getBreakpointHandlers"));
        }
        return this.myBreakpointHandlers;
    }

    public boolean checkCanInitBreakpoints() {
        return false;
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return this.myJavaSession.getProcess().getProcessHandler();
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionConsole console = this.myJavaSession.getProcess().getExecutionResult().getExecutionConsole();
        if (console != null) {
            ExecutionConsole executionConsole = console;
            if (executionConsole == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaDebugProcess", "createConsole"));
            }
            return executionConsole;
        }
        ExecutionConsole executionConsole = super.createConsole();
        if (executionConsole == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaDebugProcess", "createConsole"));
        }
        return executionConsole;
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        XDebugTabLayouter xDebugTabLayouter = new XDebugTabLayouter(){

            public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
                if (ui == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/debugger/engine/JavaDebugProcess$5", "registerAdditionalContent"));
                }
                this.registerThreadsPanel(ui);
                this.registerMemoryViewPanel(ui);
            }

            @NotNull
            public Content registerConsoleContent(@NotNull RunnerLayoutUi ui, @NotNull ExecutionConsole console) {
                if (ui == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/debugger/engine/JavaDebugProcess$5", "registerConsoleContent"));
                }
                if (console == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/debugger/engine/JavaDebugProcess$5", "registerConsoleContent"));
                }
                Content content = null;
                if (console instanceof ExecutionConsoleEx) {
                    ((ExecutionConsoleEx)console).buildUi(ui);
                    content = ui.findContent("ConsoleContent");
                }
                if (content == null) {
                    content = super.registerConsoleContent(ui, console);
                }
                Content content2 = content;
                if (content2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaDebugProcess$5", "registerConsoleContent"));
                }
                return content2;
            }

            private void registerThreadsPanel(@NotNull RunnerLayoutUi ui) {
                if (ui == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/debugger/engine/JavaDebugProcess$5", "registerThreadsPanel"));
                }
                final ThreadsPanel panel2 = new ThreadsPanel(JavaDebugProcess.this.myJavaSession.getProject(), JavaDebugProcess.this.getDebuggerStateManager());
                final Content threadsContent = ui.createContent("ThreadsContent", (JComponent)panel2, XDebuggerBundle.message((String)"debugger.session.tab.threads.title", (Object[])new Object[0]), AllIcons.Debugger.Threads, null);
                threadsContent.setCloseable(false);
                ui.addContent(threadsContent, 0, PlaceInGrid.left, true);
                ui.addListener((ContentManagerListener)new ContentManagerAdapter(){

                    public void selectionChanged(ContentManagerEvent event) {
                        if (event.getContent() == threadsContent) {
                            if (threadsContent.isSelected()) {
                                panel2.setUpdateEnabled(true);
                                if (panel2.isRefreshNeeded()) {
                                    panel2.rebuildIfVisible(DebuggerSession.Event.CONTEXT);
                                }
                            } else {
                                panel2.setUpdateEnabled(false);
                            }
                        }
                    }
                }, (Disposable)threadsContent);
            }

            private void registerMemoryViewPanel(@NotNull RunnerLayoutUi ui) {
                if (ui == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/debugger/engine/JavaDebugProcess$5", "registerMemoryViewPanel"));
                }
                if (!Registry.get((String)"debugger.enable.memory.view").asBoolean()) {
                    return;
                }
                final XDebugSession session2 = JavaDebugProcess.this.getSession();
                DebugProcessImpl process2 = JavaDebugProcess.this.myJavaSession.getProcess();
                InstancesTracker tracker = InstancesTracker.getInstance(JavaDebugProcess.this.myJavaSession.getProject());
                final ClassesFilteredView classesFilteredView = new ClassesFilteredView(session2, process2, tracker);
                final Content memoryViewContent = ui.createContent("MemoryView", (JComponent)((Object)classesFilteredView), "Memory View", AllIcons.Debugger.MemoryView.Active, null);
                memoryViewContent.setCloseable(false);
                memoryViewContent.setShouldDisposeContent(true);
                final MemoryViewDebugProcessData data = new MemoryViewDebugProcessData();
                process2.putUserData(MemoryViewDebugProcessData.KEY, data);
                session2.addSessionListener(new XDebugSessionListener(){

                    public void sessionStopped() {
                        session2.removeSessionListener((XDebugSessionListener)this);
                        data.getTrackedStacks().clear();
                    }
                });
                ui.addContent(memoryViewContent, 0, PlaceInGrid.right, true);
                final DebuggerManagerThreadImpl managerThread = process2.getManagerThread();
                ui.addListener((ContentManagerListener)new ContentManagerAdapter(){

                    public void selectionChanged(ContentManagerEvent event) {
                        if (event != null && event.getContent() == memoryViewContent) {
                            classesFilteredView.setActive(memoryViewContent.isSelected(), managerThread);
                        }
                    }
                }, (Disposable)memoryViewContent);
            }
        };
        if (xDebugTabLayouter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaDebugProcess", "createTabLayouter"));
        }
        return xDebugTabLayouter;
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        if (leftToolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftToolbar", "com/intellij/debugger/engine/JavaDebugProcess", "registerAdditionalActions"));
        }
        if (topToolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topToolbar", "com/intellij/debugger/engine/JavaDebugProcess", "registerAdditionalActions"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/debugger/engine/JavaDebugProcess", "registerAdditionalActions"));
        }
        Constraints beforeRunner = new Constraints(Anchor.BEFORE, "Runner.Layout");
        leftToolbar.add((AnAction)Separator.getInstance(), beforeRunner);
        leftToolbar.add(ActionManager.getInstance().getAction("DumpThreads"), beforeRunner);
        leftToolbar.add((AnAction)Separator.getInstance(), beforeRunner);
        Constraints beforeSort = new Constraints(Anchor.BEFORE, "XDebugger.ToggleSortValues");
        settings.addAction((AnAction)new WatchLastMethodReturnValueAction(), beforeSort);
        settings.addAction((AnAction)new AutoVarsSwitchAction(), beforeSort);
    }

    @Nullable
    private static DebugProcessImpl getCurrentDebugProcess(@Nullable Project project2) {
        XDebugProcess process2;
        XDebugSession session2;
        if (project2 != null && (session2 = XDebuggerManager.getInstance((Project)project2).getCurrentSession()) != null && (process2 = session2.getDebugProcess()) instanceof JavaDebugProcess) {
            return ((JavaDebugProcess)process2).getDebuggerSession().getProcess();
        }
        return null;
    }

    public NodeManagerImpl getNodeManager() {
        return this.myNodeManager;
    }

    public String getCurrentStateMessage() {
        String description = this.myJavaSession.getStateDescription();
        return description != null ? description : super.getCurrentStateMessage();
    }

    @Nullable
    public XValueMarkerProvider<?, ?> createValueMarkerProvider() {
        return new JavaValueMarker();
    }

    public boolean isLibraryFrameFilterSupported() {
        return true;
    }

    private static class WatchLastMethodReturnValueAction
    extends ToggleAction {
        private volatile boolean myWatchesReturnValues;
        private final String myText;
        private final String myTextUnavailable;

        public WatchLastMethodReturnValueAction() {
            super("", DebuggerBundle.message((String)"action.watch.method.return.value.description", (Object[])new Object[0]), null);
            this.myWatchesReturnValues = DebuggerSettings.getInstance().WATCH_RETURN_VALUES;
            this.myText = DebuggerBundle.message((String)"action.watches.method.return.value.enable", (Object[])new Object[0]);
            this.myTextUnavailable = DebuggerBundle.message((String)"action.watches.method.return.value.unavailable.reason", (Object[])new Object[0]);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/engine/JavaDebugProcess$WatchLastMethodReturnValueAction", "update"));
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            DebugProcessImpl process2 = JavaDebugProcess.getCurrentDebugProcess(e.getProject());
            if (process2 == null || process2.canGetMethodReturnValue()) {
                presentation.setEnabled(true);
                presentation.setText(this.myText);
            } else {
                presentation.setEnabled(false);
                presentation.setText(this.myTextUnavailable);
            }
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myWatchesReturnValues;
        }

        public void setSelected(AnActionEvent e, boolean watch) {
            this.myWatchesReturnValues = watch;
            DebuggerSettings.getInstance().WATCH_RETURN_VALUES = watch;
            DebugProcessImpl process2 = JavaDebugProcess.getCurrentDebugProcess(e.getProject());
            if (process2 != null) {
                process2.setWatchMethodReturnValuesEnabled(watch);
            }
        }
    }

    private static class AutoVarsSwitchAction
    extends ToggleAction {
        private volatile boolean myAutoModeEnabled;

        public AutoVarsSwitchAction() {
            super(DebuggerBundle.message((String)"action.auto.variables.mode", (Object[])new Object[0]), DebuggerBundle.message((String)"action.auto.variables.mode.description", (Object[])new Object[0]), null);
            this.myAutoModeEnabled = DebuggerSettings.getInstance().AUTO_VARIABLES_MODE;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myAutoModeEnabled;
        }

        public void setSelected(AnActionEvent e, boolean enabled) {
            this.myAutoModeEnabled = enabled;
            DebuggerSettings.getInstance().AUTO_VARIABLES_MODE = enabled;
            XDebuggerUtilImpl.rebuildAllSessionsViews(e.getProject());
        }
    }
}

