/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.configurations.ConfigurationWithAlternativeJre;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlternativeJreClassFinder
extends NonClasspathClassFinder {
    public AlternativeJreClassFinder(Project project2, DebuggerManagerEx manager) {
        super(project2, new String[0]);
        manager.addDebuggerManagerListener(new DebuggerManagerListener(){

            @Override
            public void sessionCreated(DebuggerSession session2) {
                AlternativeJreClassFinder.this.clearCache();
            }

            @Override
            public void sessionRemoved(DebuggerSession session2) {
                AlternativeJreClassFinder.this.clearCache();
            }
        });
    }

    @Override
    protected List<VirtualFile> calcClassRoots() {
        Collection<DebuggerSession> sessions = DebuggerManagerEx.getInstanceEx(this.myProject).getSessions();
        if (sessions.isEmpty()) {
            return Collections.emptyList();
        }
        List res = ContainerUtil.newSmartList();
        for (DebuggerSession session2 : sessions) {
            Sdk jre = session2.getAlternativeJre();
            if (jre == null) continue;
            res.addAll(AlternativeJreClassFinder.getClassRoots(jre));
        }
        return res;
    }

    @Nullable
    public static Sdk getAlternativeJre(RunProfile profile2) {
        ConfigurationWithAlternativeJre appConfig;
        if (profile2 instanceof ConfigurationWithAlternativeJre && (appConfig = (ConfigurationWithAlternativeJre)profile2).isAlternativeJrePathEnabled()) {
            return ProjectJdkTable.getInstance().findJdk(appConfig.getAlternativeJrePath());
        }
        return null;
    }

    @NotNull
    private static Collection<VirtualFile> getClassRoots(@NotNull Sdk jre) {
        if (jre == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jre", "com/intellij/debugger/impl/AlternativeJreClassFinder", "getClassRoots"));
        }
        List<VirtualFile> list2 = Arrays.asList(jre.getRootProvider().getFiles(OrderRootType.CLASSES));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/AlternativeJreClassFinder", "getClassRoots"));
        }
        return list2;
    }

    @NotNull
    public static Collection<VirtualFile> getSourceRoots(@NotNull Sdk jre) {
        if (jre == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jre", "com/intellij/debugger/impl/AlternativeJreClassFinder", "getSourceRoots"));
        }
        List<VirtualFile> list2 = Arrays.asList(jre.getRootProvider().getFiles(OrderRootType.SOURCES));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/AlternativeJreClassFinder", "getSourceRoots"));
        }
        return list2;
    }

    @NotNull
    public static GlobalSearchScope getSearchScope(@NotNull Sdk jre) {
        if (jre == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jre", "com/intellij/debugger/impl/AlternativeJreClassFinder", "getSearchScope"));
        }
        NonClasspathDirectoriesScope nonClasspathDirectoriesScope = new NonClasspathDirectoriesScope(AlternativeJreClassFinder.getClassRoots(jre));
        if (nonClasspathDirectoriesScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/AlternativeJreClassFinder", "getSearchScope"));
        }
        return nonClasspathDirectoriesScope;
    }
}

