/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.jdi.ThreadGroupReferenceProxy;
import com.intellij.debugger.jdi.ObjectReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class ThreadGroupReferenceProxyImpl
extends ObjectReferenceProxyImpl
implements ThreadGroupReferenceProxy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl");
    private ThreadGroupReferenceProxyImpl myParentThreadGroupProxy;
    private boolean myIsParentGroupCached = false;
    private String myName;

    public ThreadGroupReferenceProxyImpl(VirtualMachineProxyImpl virtualMachineProxy, ThreadGroupReference threadGroupReference) {
        super(virtualMachineProxy, threadGroupReference);
    }

    public ThreadGroupReference getThreadGroupReference() {
        return (ThreadGroupReference)this.getObjectReference();
    }

    public String name() {
        this.checkValid();
        if (this.myName == null) {
            this.myName = this.getThreadGroupReference().name();
        }
        return this.myName;
    }

    public ThreadGroupReferenceProxyImpl parent() {
        this.checkValid();
        if (!this.myIsParentGroupCached) {
            this.myParentThreadGroupProxy = this.getVirtualMachineProxy().getThreadGroupReferenceProxy(this.getThreadGroupReference().parent());
            this.myIsParentGroupCached = true;
        }
        return this.myParentThreadGroupProxy;
    }

    @Override
    @NonNls
    public String toString() {
        return "ThreadGroupReferenceProxy: " + this.getThreadGroupReference().toString();
    }

    public void suspend() {
        this.getThreadGroupReference().suspend();
    }

    public void resume() {
        this.getThreadGroupReference().resume();
    }

    public List<ThreadReferenceProxyImpl> threads() {
        List<ThreadReference> list2 = this.getThreadGroupReference().threads();
        ArrayList<ThreadReferenceProxyImpl> proxies = new ArrayList<ThreadReferenceProxyImpl>(list2.size());
        for (ThreadReference threadReference : list2) {
            proxies.add(this.getVirtualMachineProxy().getThreadReferenceProxy(threadReference));
        }
        return proxies;
    }

    public List<ThreadGroupReferenceProxyImpl> threadGroups() {
        List<ThreadGroupReference> list2 = this.getThreadGroupReference().threadGroups();
        ArrayList<ThreadGroupReferenceProxyImpl> proxies = new ArrayList<ThreadGroupReferenceProxyImpl>(list2.size());
        for (ThreadGroupReference threadGroupReference : list2) {
            proxies.add(this.getVirtualMachineProxy().getThreadGroupReferenceProxy(threadGroupReference));
        }
        return proxies;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
    }
}

