/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.component;

import com.intellij.debugger.memory.event.InstancesTrackerListener;
import com.intellij.debugger.memory.tracking.TrackingType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="InstancesTracker", storages={@Storage(value="$WORKSPACE_FILE$")})
public class InstancesTracker
extends AbstractProjectComponent
implements PersistentStateComponent<MyState> {
    private final EventDispatcher<InstancesTrackerListener> myDispatcher = EventDispatcher.create(InstancesTrackerListener.class);
    private MyState myState = new MyState();

    public InstancesTracker(Project project2) {
        super(project2);
    }

    public static InstancesTracker getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/memory/component/InstancesTracker", "getInstance"));
        }
        return (InstancesTracker)((Object)project2.getComponent(InstancesTracker.class));
    }

    public boolean isTracked(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/debugger/memory/component/InstancesTracker", "isTracked"));
        }
        return this.myState.classes.containsKey(className);
    }

    public boolean isBackgroundTrackingEnabled() {
        return this.myState.isBackgroundTrackingEnabled;
    }

    @Nullable
    public TrackingType getTrackingType(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/debugger/memory/component/InstancesTracker", "getTrackingType"));
        }
        return this.myState.classes.getOrDefault(className, null);
    }

    @NotNull
    public Map<String, TrackingType> getTrackedClasses() {
        HashMap hashMap = new HashMap(this.myState.classes);
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/memory/component/InstancesTracker", "getTrackedClasses"));
        }
        return hashMap;
    }

    public void add(@NotNull String name2, @NotNull TrackingType type2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/memory/component/InstancesTracker", "add"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/debugger/memory/component/InstancesTracker", "add"));
        }
        if (type2.equals(this.myState.classes.getOrDefault(name2, null))) {
            return;
        }
        this.myState.classes.put(name2, type2);
        ((InstancesTrackerListener)this.myDispatcher.getMulticaster()).classChanged(name2, type2);
    }

    public void remove(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/memory/component/InstancesTracker", "remove"));
        }
        TrackingType removed = this.myState.classes.remove(name2);
        if (removed != null) {
            ((InstancesTrackerListener)this.myDispatcher.getMulticaster()).classRemoved(name2);
        }
    }

    public void addTrackerListener(@NotNull InstancesTrackerListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/debugger/memory/component/InstancesTracker", "addTrackerListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addTrackerListener(@NotNull InstancesTrackerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/debugger/memory/component/InstancesTracker", "addTrackerListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/debugger/memory/component/InstancesTracker", "addTrackerListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeTrackerListener(@NotNull InstancesTrackerListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/debugger/memory/component/InstancesTracker", "removeTrackerListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void setBackgroundTackingEnabled(boolean state) {
        boolean oldState = this.myState.isBackgroundTrackingEnabled;
        if (state != oldState) {
            this.myState.isBackgroundTrackingEnabled = state;
            ((InstancesTrackerListener)this.myDispatcher.getMulticaster()).backgroundTrackingValueChanged(state);
        }
    }

    @Nullable
    public MyState getState() {
        return new MyState(this.myState);
    }

    public void loadState(MyState state) {
        this.myState = new MyState(state);
    }

    static class MyState {
        boolean isBackgroundTrackingEnabled;
        @AbstractCollection(surroundWithTag=false, elementTypes={Map.Entry.class})
        final Map<String, TrackingType> classes;

        MyState() {
            this.isBackgroundTrackingEnabled = false;
            this.classes = new ConcurrentHashMap<String, TrackingType>();
        }

        MyState(@NotNull MyState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/debugger/memory/component/InstancesTracker$MyState", "<init>"));
            }
            this.isBackgroundTrackingEnabled = false;
            this.classes = new ConcurrentHashMap<String, TrackingType>();
            this.isBackgroundTrackingEnabled = state.isBackgroundTrackingEnabled;
            for (Map.Entry<String, TrackingType> classState : state.classes.entrySet()) {
                this.classes.put(classState.getKey(), classState.getValue());
            }
        }
    }
}

