/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.filtering;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.memory.filtering.CheckingResult;
import com.intellij.debugger.memory.filtering.ConditionChecker;
import com.intellij.debugger.memory.filtering.ConditionCheckerImpl;
import com.intellij.debugger.memory.filtering.FilteringResult;
import com.intellij.debugger.memory.filtering.FilteringTaskCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XExpression;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class FilteringTask
implements Runnable {
    private final ValuesList myValues;
    private final ConditionChecker myChecker;
    private final FilteringTaskCallback myCallback;
    private volatile boolean myIsCancelled;

    public FilteringTask(@NotNull String className, @NotNull DebugProcessImpl debugProcess, @NotNull XExpression expression2, @NotNull ValuesList values, @NotNull FilteringTaskCallback callback) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/debugger/memory/filtering/FilteringTask", "<init>"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/memory/filtering/FilteringTask", "<init>"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/debugger/memory/filtering/FilteringTask", "<init>"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/debugger/memory/filtering/FilteringTask", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/memory/filtering/FilteringTask", "<init>"));
        }
        this.myIsCancelled = false;
        this.myChecker = StringUtil.isEmptyOrSpaces((String)expression2.getExpression()) ? ConditionChecker.ALL_MATCHED_CHECKER : new ConditionCheckerImpl(debugProcess, expression2, className);
        this.myValues = values;
        this.myCallback = callback;
    }

    public void cancel() {
        this.myIsCancelled = true;
    }

    public boolean isCancelled() {
        return this.myIsCancelled;
    }

    @Override
    public void run() {
        int proceedCount;
        this.myCallback.started(this.myValues.size());
        for (proceedCount = 0; proceedCount < this.myValues.size() && !this.myIsCancelled; ++proceedCount) {
            Value value2 = this.myValues.get(proceedCount);
            CheckingResult result2 = this.myChecker.check(value2);
            FilteringTaskCallback.Action action = FilteringTaskCallback.Action.CONTINUE;
            switch (result2.getResult()) {
                case MATCH: {
                    action = this.myCallback.matched(value2);
                    break;
                }
                case NO_MATCH: {
                    action = this.myCallback.notMatched(value2);
                    break;
                }
                case ERROR: {
                    action = this.myCallback.error(value2, result2.getFailureDescription());
                }
            }
            if (action == FilteringTaskCallback.Action.STOP) break;
        }
        FilteringResult reason = this.myIsCancelled ? FilteringResult.INTERRUPTED : (proceedCount == this.myValues.size() ? FilteringResult.ALL_CHECKED : FilteringResult.LIMIT_REACHED);
        this.myCallback.completed(reason);
    }

    public static interface ValuesList {
        public int size();

        public Value get(int var1);
    }
}

