/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.memory.ui.StackFrameList;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class StackFramePopup {
    public static void show(@NotNull List<StackFrameItem> stack, DebugProcessImpl debugProcess) {
        if (stack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "com/intellij/debugger/memory/ui/StackFramePopup", "show"));
        }
        StackFrameList list2 = new StackFrameList(debugProcess);
        list2.setFrameItems(stack, () -> DebuggerUIUtil.invokeLater(() -> {
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)((Object)list2)).setTitle("Select stack frame").setAutoSelectIfEmpty(true).setResizable(false).setItemChoosenCallback(() -> list2.navigateToSelectedValue(true)).createPopup();
            list2.setSelectedIndex(1);
            popup.showInFocusCenter();
        }));
    }
}

