/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.DebuggerTreeCreatorImpl;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.InspectDebuggerTree;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.sun.jdi.Method;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nullable;

public class ValueHint
extends AbstractValueHint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.ValueHint");
    private PsiElement myCurrentExpression = null;
    private Value myValueToShow = null;

    private ValueHint(Project project2, Editor editor, Point point, ValueHintType type2, PsiElement selectedExpression, TextRange textRange) {
        super(project2, editor, point, type2, textRange);
        this.myCurrentExpression = selectedExpression;
    }

    public static ValueHint createValueHint(Project project2, Editor editor, Point point, ValueHintType type2) {
        Trinity<PsiElement, TextRange, Value> trinity = ValueHint.getSelectedExpression(project2, editor, point, type2);
        ValueHint hint = new ValueHint(project2, editor, point, type2, (PsiElement)trinity.getFirst(), (TextRange)trinity.getSecond());
        hint.myValueToShow = (Value)trinity.getThird();
        return hint;
    }

    @Override
    protected boolean canShowHint() {
        return this.myCurrentExpression != null;
    }

    @Nullable
    private ExpressionEvaluator getExpressionEvaluator(DebuggerContextImpl debuggerContext) throws EvaluateException {
        if (this.myCurrentExpression instanceof PsiExpression) {
            return EvaluatorBuilderImpl.getInstance().build(this.myCurrentExpression, debuggerContext.getSourcePosition());
        }
        TextWithImportsImpl textWithImports = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, this.myCurrentExpression.getText());
        CodeFragmentFactory factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(textWithImports, this.myCurrentExpression);
        JavaCodeFragment codeFragment = factory.createCodeFragment((TextWithImports)textWithImports, this.myCurrentExpression.getContext(), this.getProject());
        return factory.getEvaluatorBuilder().build((PsiElement)codeFragment, debuggerContext.getSourcePosition());
    }

    @Override
    protected void evaluateAndShowHint() {
        final DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(this.getProject()).getContext();
        DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
        if (debuggerSession == null || !debuggerSession.isPaused()) {
            return;
        }
        try {
            final ExpressionEvaluator evaluator = this.getExpressionEvaluator(debuggerContext);
            if (evaluator == null) {
                return;
            }
            debuggerContext.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }

                @Override
                public void threadAction() {
                    try {
                        EvaluationContextImpl evaluationContext = debuggerContext.createEvaluationContext();
                        String expressionText = (String)ReadAction.compute(() -> ValueHint.this.myCurrentExpression.getText());
                        TextWithImportsImpl text2 = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expressionText);
                        final Value value2 = ValueHint.this.myValueToShow != null ? ValueHint.this.myValueToShow : evaluator.evaluate((EvaluationContext)evaluationContext);
                        final WatchItemDescriptor descriptor = new WatchItemDescriptor(ValueHint.this.getProject(), (TextWithImports)text2, value2);
                        if (!ValueHint.isActiveTooltipApplicable(value2) || ValueHint.this.getType() == ValueHintType.MOUSE_OVER_HINT) {
                            if (ValueHint.this.getType() == ValueHintType.MOUSE_OVER_HINT) {
                                descriptor.setRenderer(DebugProcessImpl.getDefaultRenderer(value2));
                            }
                            descriptor.updateRepresentation(evaluationContext, new DescriptorLabelListener(){

                                @Override
                                public void labelChanged() {
                                    if (ValueHint.this.getCurrentRange() != null && (ValueHint.this.getType() != ValueHintType.MOUSE_OVER_HINT || descriptor.isValueValid())) {
                                        SimpleColoredText simpleColoredText = DebuggerTreeRenderer.getDescriptorText(debuggerContext, descriptor, true);
                                        if (ValueHint.isActiveTooltipApplicable(value2)) {
                                            simpleColoredText.append(" (" + DebuggerBundle.message((String)"active.tooltip.suggestion", (Object[])new Object[0]) + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                                        }
                                        ValueHint.this.showHint(simpleColoredText, descriptor);
                                    }
                                }
                            });
                        } else {
                            ValueHint.this.createAndShowTree(expressionText, descriptor);
                        }
                    }
                    catch (EvaluateException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            });
        }
        catch (EvaluateException e) {
            LOG.debug((Throwable)e);
        }
    }

    private void createAndShowTree(String expressionText, NodeDescriptorImpl descriptor) {
        DebuggerTreeCreatorImpl creator = new DebuggerTreeCreatorImpl(this.getProject());
        DebuggerInvocationUtil.invokeLater(this.getProject(), () -> this.showTreePopup(creator, Pair.create((Object)descriptor, (Object)expressionText)));
    }

    private static boolean isActiveTooltipApplicable(Value value2) {
        return value2 != null && !(value2 instanceof PrimitiveValue);
    }

    private void showHint(SimpleColoredText text2, final WatchItemDescriptor descriptor) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), () -> {
            if (!this.isHintHidden()) {
                JComponent component = !ValueHint.isActiveTooltipApplicable(descriptor.getValue()) ? HintUtil.createInformationLabel(text2) : this.createExpandableHintComponent(text2, () -> {
                    DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(this.getProject()).getContext();
                    final DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
                    debugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                        @Override
                        public void threadAction() {
                            descriptor.setRenderer(debugProcess.getAutoRenderer(descriptor));
                            String expressionText = (String)ReadAction.compute(() -> ValueHint.this.myCurrentExpression.getText());
                            ValueHint.this.createAndShowTree(expressionText, descriptor);
                        }
                    });
                });
                if (!this.showHint(component)) {
                    return;
                }
                if (this.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                    HintUtil.createInformationLabel(text2).requestFocusInWindow();
                }
            }
        });
    }

    public static InspectDebuggerTree createInspectTree(NodeDescriptorImpl descriptor, Project project2) {
        final InspectDebuggerTree tree = new InspectDebuggerTree(project2);
        final AnAction setValueAction = ActionManager.getInstance().getAction("Debugger.SetValue");
        setValueAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)), (JComponent)((Object)tree));
        Disposer.register((Disposable)tree, (Disposable)new Disposable(){

            public void dispose() {
                setValueAction.unregisterCustomShortcutSet((JComponent)((Object)tree));
            }
        });
        tree.setInspectDescriptor(descriptor);
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project2).getContext();
        tree.rebuild(context);
        return tree;
    }

    @Nullable
    private static Pair<PsiElement, TextRange> findExpression(PsiElement element, boolean allowMethodCalls) {
        EditorTextProvider textProvider = (EditorTextProvider)EditorTextProvider.EP.forLanguage(element.getLanguage());
        if (textProvider != null) {
            return textProvider.findExpression(element, allowMethodCalls);
        }
        return null;
    }

    private static Trinity<PsiElement, TextRange, Value> getSelectedExpression(Project project2, Editor editor, Point point, ValueHintType type2) {
        Ref selectedExpression = Ref.create(null);
        Ref currentRange = Ref.create(null);
        Ref preCalculatedValue = Ref.create(null);
        PsiDocumentManager.getInstance((Project)project2).commitAndRunReadAction(() -> {
            int offset = ValueHint.calculateOffset(editor, point);
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (psiFile == null || !psiFile.isValid()) {
                return;
            }
            int selectionStart = editor.getSelectionModel().getSelectionStart();
            int selectionEnd = editor.getSelectionModel().getSelectionEnd();
            if ((type2 == ValueHintType.MOUSE_CLICK_HINT || type2 == ValueHintType.MOUSE_ALT_OVER_HINT) && selectionStart <= offset && offset <= selectionEnd) {
                PsiElement ctx = selectionStart > 0 ? psiFile.findElementAt(selectionStart - 1) : psiFile.findElementAt(selectionStart);
                try {
                    String text2 = editor.getSelectionModel().getSelectedText();
                    if (text2 != null && ctx != null) {
                        JVMElementFactory factory = JVMElementFactories.getFactory((Language)ctx.getLanguage(), (Project)project2);
                        if (factory == null) {
                            return;
                        }
                        selectedExpression.set((Object)factory.createExpressionFromText(text2, ctx));
                        currentRange.set((Object)new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd()));
                    }
                }
                catch (IncorrectOperationException text2) {
                    // empty catch block
                }
            }
            if (currentRange.get() == null) {
                PsiMethodCallExpression methodCallExpression;
                PsiMethod psiMethod;
                Pair<PsiElement, TextRange> expressionPair;
                Method method;
                Pair<Method, Value> lastExecuted;
                DebuggerSession debuggerSession;
                PsiElement elementAtCursor = psiFile.findElementAt(offset);
                if (elementAtCursor == null) {
                    return;
                }
                Pair<PsiElement, TextRange> pair2 = ValueHint.findExpression(elementAtCursor, type2 == ValueHintType.MOUSE_CLICK_HINT || type2 == ValueHintType.MOUSE_ALT_OVER_HINT);
                if (pair2 == null && type2 == ValueHintType.MOUSE_OVER_HINT && (debuggerSession = DebuggerManagerEx.getInstanceEx(project2).getContext().getDebuggerSession()) != null && debuggerSession.isPaused() && (lastExecuted = debuggerSession.getProcess().getLastExecutedMethod()) != null && (method = (Method)lastExecuted.getFirst()) != null && (expressionPair = ValueHint.findExpression(elementAtCursor, true)) != null && expressionPair.getFirst() instanceof PsiMethodCallExpression && (psiMethod = (methodCallExpression = (PsiMethodCallExpression)expressionPair.getFirst()).resolveMethod()) != null) {
                    JVMName jvmSignature = JVMNameUtil.getJVMSignature(psiMethod);
                    try {
                        if (method.name().equals(psiMethod.getName()) && method.signature().equals(jvmSignature.getName(debuggerSession.getProcess()))) {
                            pair2 = expressionPair;
                            preCalculatedValue.set(lastExecuted.getSecond());
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        // empty catch block
                    }
                }
                if (pair2 == null) {
                    return;
                }
                selectedExpression.set(pair2.getFirst());
                currentRange.set(pair2.getSecond());
            }
        });
        return Trinity.create((Object)selectedExpression.get(), (Object)currentRange.get(), (Object)preCalculatedValue.get());
    }
}

