/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.ui.breakpoints.EditClassFiltersDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.classFilter.ClassFilter;
import java.util.ArrayList;
import java.util.Arrays;
import one.util.streamex.StreamEx;

public class ClassFiltersField
extends TextFieldWithBrowseButton {
    private ClassFilter[] myClassFilters = ClassFilter.EMPTY_ARRAY;
    private ClassFilter[] myClassExclusionFilters = ClassFilter.EMPTY_ARRAY;

    public ClassFiltersField(Project project2) {
        this.addActionListener(e -> {
            this.reloadFilters();
            EditClassFiltersDialog dialog2 = new EditClassFiltersDialog(project2);
            dialog2.setFilters(this.myClassFilters, this.myClassExclusionFilters);
            dialog2.show();
            if (dialog2.getExitCode() == 0) {
                this.myClassFilters = dialog2.getFilters();
                this.myClassExclusionFilters = dialog2.getExclusionFilters();
                this.updateEditor();
            }
        });
    }

    public void setClassFilters(ClassFilter[] includeFilters, ClassFilter[] excludeFilters) {
        this.myClassFilters = includeFilters;
        this.myClassExclusionFilters = excludeFilters;
        this.updateEditor();
    }

    public ClassFilter[] getClassFilters() {
        this.reloadFilters();
        return this.myClassFilters;
    }

    public ClassFilter[] getClassExclusionFilters() {
        this.reloadFilters();
        return this.myClassExclusionFilters;
    }

    private void reloadFilters() {
        String filtersText = this.getText();
        ArrayList<ClassFilter> classFilters = new ArrayList<ClassFilter>();
        ArrayList<ClassFilter> exclusionFilters = new ArrayList<ClassFilter>();
        int startFilter = -1;
        for (int i2 = 0; i2 <= filtersText.length(); ++i2) {
            if (i2 < filtersText.length() && !Character.isWhitespace(filtersText.charAt(i2))) {
                if (startFilter != -1) continue;
                startFilter = i2;
                continue;
            }
            if (startFilter < 0) continue;
            if (filtersText.charAt(startFilter) == '-') {
                exclusionFilters.add(new ClassFilter(filtersText.substring(startFilter + 1, i2)));
            } else {
                classFilters.add(new ClassFilter(filtersText.substring(startFilter, i2)));
            }
            startFilter = -1;
        }
        Arrays.stream(this.myClassFilters).filter(f -> !f.isEnabled()).forEach(classFilters::add);
        Arrays.stream(this.myClassExclusionFilters).filter(f -> !f.isEnabled()).forEach(classFilters::add);
        this.myClassFilters = classFilters.toArray(new ClassFilter[classFilters.size()]);
        this.myClassExclusionFilters = exclusionFilters.toArray(new ClassFilter[exclusionFilters.size()]);
    }

    private void updateEditor() {
        String enabledStr = ((StreamEx)StreamEx.of((Object[])this.myClassFilters).filter(ClassFilter::isEnabled)).map(ClassFilter::getPattern).joining((CharSequence)" ");
        String disabledStr = ((StreamEx)StreamEx.of((Object[])this.myClassExclusionFilters).filter(ClassFilter::isEnabled)).map(f -> "-" + f.getPattern()).joining((CharSequence)" ");
        if (!enabledStr.isEmpty() && !disabledStr.isEmpty()) {
            enabledStr = enabledStr + " ";
        }
        this.setText(enabledStr + disabledStr);
    }
}

