/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.ui.InstanceFilterEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class EditInstanceFiltersDialog
extends DialogWrapper {
    private InstanceFilterEditor myInstanceFilterEditor;
    private final Project myProject;

    public EditInstanceFiltersDialog(Project project2) {
        super(project2, true);
        this.myProject = project2;
        this.setTitle(DebuggerBundle.message((String)"instance.filters.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    protected JComponent createCenterPanel() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        Box mainPanel = Box.createHorizontalBox();
        this.myInstanceFilterEditor = new InstanceFilterEditor(this.myProject);
        this.myInstanceFilterEditor.setPreferredSize((Dimension)JBUI.size((int)400, (int)200));
        this.myInstanceFilterEditor.setBorder((Border)IdeBorderFactory.createTitledBorder((String)DebuggerBundle.message((String)"instance.filters.dialog.instance.filters.group", (Object[])new Object[0]), (boolean)false));
        mainPanel.add((Component)((Object)this.myInstanceFilterEditor));
        contentPanel.add((Component)mainPanel, "Center");
        return contentPanel;
    }

    public void dispose() {
        this.myInstanceFilterEditor.stopEditing();
        super.dispose();
    }

    public void setFilters(InstanceFilter[] filters) {
        ClassFilter[] cFilters = InstanceFilter.createClassFilters(filters);
        this.myInstanceFilterEditor.setFilters(cFilters);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.debugger.ui.breakpoints.EditInstanceFiltersDialog";
    }

    public InstanceFilter[] getFilters() {
        ClassFilter[] cFilters = this.myInstanceFilterEditor.getFilters();
        InstanceFilter[] ifilters = new InstanceFilter[cFilters.length];
        for (int i2 = 0; i2 < ifilters.length; ++i2) {
            ifilters[i2] = InstanceFilter.create(cFilters[i2]);
        }
        return ifilters;
    }
}

