/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.sun.jdi.event.LocatableEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;

public class RunToCursorBreakpoint
extends LineBreakpoint<JavaLineBreakpointProperties> {
    private final boolean myRestoreBreakpoints;
    @NotNull
    protected final SourcePosition myCustomPosition;
    private String mySuspendPolicy;
    private final JavaLineBreakpointProperties myProperties;

    protected RunToCursorBreakpoint(@NotNull Project project2, @NotNull SourcePosition pos, boolean restoreBreakpoints) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "<init>"));
        }
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "<init>"));
        }
        super(project2, (XBreakpoint)null);
        this.myProperties = new JavaLineBreakpointProperties();
        this.myCustomPosition = pos;
        this.setVisible(false);
        this.myRestoreBreakpoints = restoreBreakpoints;
    }

    @Override
    @NotNull
    public SourcePosition getSourcePosition() {
        SourcePosition sourcePosition = this.myCustomPosition;
        if (sourcePosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "getSourcePosition"));
        }
        return sourcePosition;
    }

    @Override
    public int getLineIndex() {
        return this.myCustomPosition.getLine();
    }

    @Override
    public void reload() {
    }

    @Override
    public String getSuspendPolicy() {
        return this.mySuspendPolicy;
    }

    @Override
    public void setSuspendPolicy(String policy) {
        this.mySuspendPolicy = policy;
    }

    @Override
    protected boolean isLogEnabled() {
        return false;
    }

    @Override
    protected boolean isLogExpressionEnabled() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isCountFilterEnabled() {
        return false;
    }

    @Override
    public boolean isClassFiltersEnabled() {
        return false;
    }

    @Override
    public boolean isConditionEnabled() {
        return false;
    }

    public boolean isRestoreBreakpoints() {
        return this.myRestoreBreakpoints;
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        return DebuggerBundle.message((String)"status.stopped.at.cursor", (Object[])new Object[0]);
    }

    @Override
    protected boolean isVisible() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @NotNull
    protected JavaLineBreakpointProperties getProperties() {
        JavaLineBreakpointProperties javaLineBreakpointProperties = this.myProperties;
        if (javaLineBreakpointProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "getProperties"));
        }
        return javaLineBreakpointProperties;
    }

    @Override
    protected void fireBreakpointChanged() {
    }

    @Override
    protected boolean isMuted(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "isMuted"));
        }
        return false;
    }

    @Override
    @Nullable
    protected JavaLineBreakpointType getXBreakpointType() {
        SourcePosition position = this.getSourcePosition();
        VirtualFile file2 = position.getFile().getVirtualFile();
        int line = position.getLine();
        for (XLineBreakpointType type2 : XDebuggerUtil.getInstance().getLineBreakpointTypes()) {
            if (!(type2 instanceof JavaLineBreakpointType) || !type2.canPutAt(file2, line, this.myProject)) continue;
            return (JavaLineBreakpointType)type2;
        }
        return null;
    }

    @Nullable
    protected static RunToCursorBreakpoint create(@NotNull Project project2, @NotNull XSourcePosition position, boolean restoreBreakpoints) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "create"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "create"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(position.getFile());
        if (psiFile == null) {
            return null;
        }
        return new RunToCursorBreakpoint(project2, SourcePosition.createFromOffset((PsiFile)psiFile, (int)position.getOffset()), restoreBreakpoints);
    }
}

