/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.breakpoints.WildcardMethodBreakpoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class StackCapturingLineBreakpoint
extends WildcardMethodBreakpoint {
    private static final Logger LOG = Logger.getInstance(StackCapturingLineBreakpoint.class);
    private final CapturePoint myCapturePoint;
    private final String mySignature;
    private final MyEvaluator myCaptureEvaluator;
    private final MyEvaluator myInsertEvaluator;
    public static final Key<List<StackCapturingLineBreakpoint>> CAPTURE_BREAKPOINTS = Key.create((String)"CAPTURE_BREAKPOINTS");
    private static final Key<Map<Object, List<StackFrameItem>>> CAPTURED_STACKS = Key.create((String)"CAPTURED_STACKS");
    private static final int MAX_STORED_STACKS = 1000;
    public static final int MAX_STACK_LENGTH = 500;
    private final JavaMethodBreakpointProperties myProperties = new JavaMethodBreakpointProperties();

    public StackCapturingLineBreakpoint(Project project2, CapturePoint capturePoint) {
        super(project2, (XBreakpoint<JavaMethodBreakpointProperties>)null);
        this.myCapturePoint = capturePoint;
        this.mySignature = null;
        this.myProperties.EMULATED = true;
        this.myProperties.WATCH_EXIT = false;
        this.myProperties.myClassPattern = this.myCapturePoint.myClassName;
        this.myProperties.myMethodName = this.myCapturePoint.myMethodName;
        this.myCaptureEvaluator = new MyEvaluator(this.myCapturePoint.myCaptureKeyExpression);
        this.myInsertEvaluator = new MyEvaluator(this.myCapturePoint.myInsertKeyExpression);
    }

    @Override
    @NotNull
    protected JavaMethodBreakpointProperties getProperties() {
        JavaMethodBreakpointProperties javaMethodBreakpointProperties = this.myProperties;
        if (javaMethodBreakpointProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/StackCapturingLineBreakpoint", "getProperties"));
        }
        return javaMethodBreakpointProperties;
    }

    @Override
    public String getSuspendPolicy() {
        return "SuspendThread";
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
        ThreadReferenceProxyImpl thread;
        SuspendContextImpl suspendContext = action.getSuspendContext();
        if (suspendContext != null && (thread = suspendContext.getThread()) != null) {
            DebugProcessImpl process2 = suspendContext.getDebugProcess();
            try {
                StackFrameProxyImpl frameProxy = (StackFrameProxyImpl)ContainerUtil.getFirstItem(thread.forceFrames());
                if (frameProxy != null) {
                    Value key2;
                    Map stacks = (Map)process2.getUserData(CAPTURED_STACKS);
                    if (stacks == null) {
                        stacks = new CapturedStacksMap();
                        StackCapturingLineBreakpoint.putProcessUserData(CAPTURED_STACKS, Collections.synchronizedMap(stacks), process2);
                    }
                    if ((key2 = this.myCaptureEvaluator.evaluate(new EvaluationContextImpl(suspendContext, frameProxy))) instanceof ObjectReference) {
                        List<StackFrameItem> frames = StackFrameItem.createFrames(suspendContext, true);
                        if (frames.size() > 500) {
                            frames = frames.subList(0, 500);
                        }
                        stacks.put(StackCapturingLineBreakpoint.getKey((ObjectReference)key2), frames);
                    }
                }
            }
            catch (EvaluateException e) {
                LOG.debug((Throwable)e);
                process2.printToConsole(DebuggerBundle.message((String)"error.unable.to.evaluate.capture.expression", (Object[])new Object[]{e.getMessage()}) + "\n");
            }
        }
        return false;
    }

    @Override
    protected void fireBreakpointChanged() {
    }

    @Override
    public StreamEx matchingMethods(StreamEx<Method> methods, DebugProcessImpl debugProcess) {
        String methodName = this.getMethodName();
        return (StreamEx)((StreamEx)methods.filter(m -> Comparing.equal((String)methodName, (String)m.name()) && (this.mySignature == null || Comparing.equal((String)this.mySignature, (String)m.signature())))).limit(1L);
    }

    public static void recreateAll(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        List bpts = (List)debugProcess.getUserData(CAPTURE_BREAKPOINTS);
        if (!ContainerUtil.isEmpty((Collection)bpts)) {
            bpts.forEach(debugProcess.getRequestsManager()::deleteRequest);
            bpts.clear();
        }
        if (Registry.is((String)"debugger.capture.points")) {
            DebuggerSettings.getInstance().getCapturePoints().stream().filter(c -> c.myEnabled).forEach(c -> StackCapturingLineBreakpoint.track(debugProcess, c));
        }
    }

    public static void clearCaches(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        List bpts = (List)debugProcess.getUserData(CAPTURE_BREAKPOINTS);
        if (!ContainerUtil.isEmpty((Collection)bpts)) {
            bpts.forEach(b -> {
                b.myCaptureEvaluator.clearCache();
                b.myInsertEvaluator.clearCache();
            });
        }
    }

    @Override
    public void createRequest(DebugProcessImpl debugProcess) {
        if (!StringUtil.isEmpty((String)this.getClassName())) {
            super.createRequest(debugProcess);
        }
    }

    private static void track(DebugProcessImpl debugProcess, CapturePoint capturePoint) {
        StackCapturingLineBreakpoint breakpoint = new StackCapturingLineBreakpoint(debugProcess.getProject(), capturePoint);
        breakpoint.createRequest(debugProcess);
        CopyOnWriteArrayList<StackCapturingLineBreakpoint> bpts = (CopyOnWriteArrayList<StackCapturingLineBreakpoint>)debugProcess.getUserData(CAPTURE_BREAKPOINTS);
        if (bpts == null) {
            bpts = new CopyOnWriteArrayList<StackCapturingLineBreakpoint>();
            StackCapturingLineBreakpoint.putProcessUserData(CAPTURE_BREAKPOINTS, bpts, debugProcess);
        }
        bpts.add(breakpoint);
    }

    public static <T> void putProcessUserData(final @NotNull Key<T> key2, @Nullable T value2, DebugProcessImpl debugProcess) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/debugger/ui/breakpoints/StackCapturingLineBreakpoint", "putProcessUserData"));
        }
        debugProcess.putUserData(key2, value2);
        debugProcess.addDebugProcessListener(new DebugProcessListener(){

            public void processDetached(DebugProcess process2, boolean closedByUser) {
                process2.putUserData(key2, null);
            }
        });
    }

    @Nullable
    public static CapturePoint getMatchingDisabledInsertionPoint(@NotNull StackFrameProxyImpl frame) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/debugger/ui/breakpoints/StackCapturingLineBreakpoint", "getMatchingDisabledInsertionPoint"));
        }
        List<CapturePoint> capturePoints = DebuggerSettings.getInstance().getCapturePoints();
        if (!capturePoints.isEmpty()) {
            try {
                Location location = frame.location();
                String className = location.declaringType().name();
                String methodName = location.method().name();
                for (CapturePoint c : capturePoints) {
                    if (c.myEnabled || !StringUtil.equals((CharSequence)c.myInsertClassName, (CharSequence)className) || !StringUtil.equals((CharSequence)c.myInsertMethodName, (CharSequence)methodName)) continue;
                    return c;
                }
            }
            catch (EvaluateException | InternalException e) {
                LOG.debug(e);
            }
        }
        return null;
    }

    @Nullable
    public static List<StackFrameItem> getRelatedStack(@NotNull StackFrameProxyImpl frame, @NotNull SuspendContextImpl suspendContext) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/debugger/ui/breakpoints/StackCapturingLineBreakpoint", "getRelatedStack"));
        }
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/breakpoints/StackCapturingLineBreakpoint", "getRelatedStack"));
        }
        DebugProcessImpl debugProcess = suspendContext.getDebugProcess();
        Map capturedStacks = (Map)debugProcess.getUserData(CAPTURED_STACKS);
        if (ContainerUtil.isEmpty((Map)capturedStacks)) {
            return null;
        }
        List captureBreakpoints = (List)debugProcess.getUserData(CAPTURE_BREAKPOINTS);
        if (ContainerUtil.isEmpty((Collection)captureBreakpoints)) {
            return null;
        }
        try {
            Location location = frame.location();
            String className = location.declaringType().name();
            String methodName = location.method().name();
            for (StackCapturingLineBreakpoint b : captureBreakpoints) {
                String insertClassName = b.myCapturePoint.myInsertClassName;
                if (!StringUtil.isEmpty((String)insertClassName) && !StringUtil.equals((CharSequence)insertClassName, (CharSequence)className) || !StringUtil.equals((CharSequence)b.myCapturePoint.myInsertMethodName, (CharSequence)methodName)) continue;
                try {
                    Value key2 = b.myInsertEvaluator.evaluate(new EvaluationContextImpl(suspendContext, frame));
                    if (!(key2 instanceof ObjectReference)) continue;
                    return (List)capturedStacks.get(StackCapturingLineBreakpoint.getKey((ObjectReference)key2));
                }
                catch (EvaluateException e) {
                    LOG.debug((Throwable)e);
                    debugProcess.printToConsole(DebuggerBundle.message((String)"error.unable.to.evaluate.insert.expression", (Object[])new Object[]{e.getMessage()}) + "\n");
                }
            }
        }
        catch (EvaluateException e) {
            LOG.debug((Throwable)e);
        }
        return null;
    }

    @Nullable
    public static List<StackFrameItem> getRelatedStack(@Nullable ObjectReference key2, @Nullable DebugProcessImpl process2) {
        Map data;
        if (process2 != null && key2 != null && (data = (Map)process2.getUserData(CAPTURED_STACKS)) != null) {
            return (List)data.get(key2);
        }
        return null;
    }

    private static Object getKey(ObjectReference reference) {
        return reference instanceof StringReference ? ((StringReference)reference).value() : reference;
    }

    private static class MyEvaluator {
        private final String myExpression;
        private ExpressionEvaluator myEvaluator;
        private final WeakHashMap<Location, ExpressionEvaluator> myEvaluatorCache = new WeakHashMap();

        public MyEvaluator(String expression2) {
            boolean paramEvaluator;
            this.myExpression = expression2;
            final int paramId = DecompiledLocalVariable.getParamId(this.myExpression);
            boolean bl = paramEvaluator = paramId > -1;
            if (paramEvaluator) {
                this.myEvaluator = new ExpressionEvaluatorImpl(new Evaluator(){

                    @Override
                    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
                        List<Value> argumentValues = context.getFrameProxy().getArgumentValues();
                        if (paramId >= argumentValues.size()) {
                            throw new EvaluateException("Param index " + paramId + " requested, but only " + argumentValues.size() + " available");
                        }
                        return argumentValues.get(paramId);
                    }
                });
            }
        }

        @Nullable
        Value evaluate(EvaluationContext context) throws EvaluateException {
            Location location;
            ExpressionEvaluator evaluator = this.myEvaluator;
            if (evaluator == null && (evaluator = (ExpressionEvaluator)this.myEvaluatorCache.get((Object)(location = context.getFrameProxy().location()))) == null && !StringUtil.isEmpty((String)this.myExpression)) {
                evaluator = (ExpressionEvaluator)ApplicationManager.getApplication().runReadAction(() -> {
                    SourcePosition sourcePosition = ContextUtil.getSourcePosition((StackFrameContext)context);
                    PsiElement contextElement = ContextUtil.getContextElement(sourcePosition);
                    return EvaluatorBuilderImpl.build(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, this.myExpression), contextElement, sourcePosition, context.getProject());
                });
                this.myEvaluatorCache.put((Object)location, (Object)evaluator);
            }
            if (evaluator != null) {
                return evaluator.evaluate(context);
            }
            return null;
        }

        void clearCache() {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            this.myEvaluatorCache.clear();
        }
    }

    private static class CapturedStacksMap
    extends LinkedHashMap<Object, List<StackFrameItem>> {
        private CapturedStacksMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1000;
        }
    }
}

