/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiType;
import com.intellij.reference.SoftReference;
import org.jetbrains.annotations.Nullable;

public abstract class CachedEvaluator {
    private final CodeFragmentFactory myDefaultFragmentFactory;
    SoftReference<Cache> myCache = new SoftReference(null);
    private TextWithImports myReferenceExpression;

    public CachedEvaluator() {
        this.myDefaultFragmentFactory = new CodeFragmentFactoryContextWrapper(DefaultCodeFragmentFactory.getInstance());
    }

    protected abstract String getClassName();

    public TextWithImports getReferenceExpression() {
        return this.myReferenceExpression != null ? this.myReferenceExpression : DebuggerUtils.getInstance().createExpressionWithImports("");
    }

    public void setReferenceExpression(TextWithImports referenceExpression) {
        this.myReferenceExpression = referenceExpression;
        this.clear();
    }

    public void clear() {
        this.myCache.clear();
    }

    protected Cache initEvaluatorAndChildrenExpression(Project project2) {
        Cache cache = new Cache();
        try {
            Pair<PsiElement, PsiType> psiClassAndType = DebuggerUtilsImpl.getPsiClassAndType(this.getClassName(), project2);
            if (psiClassAndType.first == null) {
                throw EvaluateExceptionUtil.CANNOT_FIND_SOURCE_CLASS;
            }
            cache.myPsiChildrenExpression = null;
            JavaCodeFragment codeFragment = this.myDefaultFragmentFactory.createCodeFragment(this.myReferenceExpression, this.overrideContext((PsiElement)psiClassAndType.first), project2);
            codeFragment.setThisType((PsiType)psiClassAndType.second);
            DebuggerUtils.checkSyntax((PsiCodeFragment)codeFragment);
            cache.myPsiChildrenExpression = codeFragment instanceof PsiExpressionCodeFragment ? ((PsiExpressionCodeFragment)codeFragment).getExpression() : null;
            cache.myEvaluator = this.myDefaultFragmentFactory.getEvaluatorBuilder().build((PsiElement)codeFragment, null);
        }
        catch (EvaluateException e) {
            cache.myException = e;
        }
        this.myCache = new SoftReference((Object)cache);
        return cache;
    }

    protected PsiElement overrideContext(PsiElement context) {
        return context;
    }

    protected ExpressionEvaluator getEvaluator(Project project2) throws EvaluateException {
        Cache cache = (Cache)this.myCache.get();
        if (cache == null) {
            cache = (Cache)PsiDocumentManager.getInstance((Project)project2).commitAndRunReadAction(() -> this.initEvaluatorAndChildrenExpression(project2));
        }
        if (cache.myException != null) {
            throw cache.myException;
        }
        return cache.myEvaluator;
    }

    @Nullable
    protected PsiExpression getPsiExpression(Project project2) {
        Cache cache = (Cache)this.myCache.get();
        if (cache == null) {
            cache = this.initEvaluatorAndChildrenExpression(project2);
        }
        return cache.myPsiChildrenExpression;
    }

    private static class Cache {
        protected ExpressionEvaluator myEvaluator;
        protected EvaluateException myException;
        protected PsiExpression myPsiChildrenExpression;

        private Cache() {
        }
    }
}

