/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.debugger.ui.tree.render.TypeRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CompoundTypeRenderer
extends CompoundNodeRenderer {
    @NonNls
    public static final String UNIQUE_ID = "CompoundTypeRenderer";
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer");
    private static final AutoToStringRenderer AUTO_TO_STRING_RENDERER = new AutoToStringRenderer();

    public CompoundTypeRenderer(NodeRendererSettings rendererSettings, String name2, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        super(rendererSettings, name2, labelRenderer, childrenRenderer);
        this.myProperties.setClassName("java.lang.Object");
        LOG.assertTrue(labelRenderer == null || labelRenderer instanceof TypeRenderer);
        LOG.assertTrue(childrenRenderer == null || childrenRenderer instanceof TypeRenderer);
    }

    @Override
    public void setLabelRenderer(ValueLabelRenderer labelRenderer) {
        ValueLabelRenderer prevRenderer = this.getLabelRenderer();
        super.setLabelRenderer(this.isBaseRenderer(labelRenderer) ? null : labelRenderer);
        ValueLabelRenderer currentRenderer = this.getLabelRenderer();
        if (prevRenderer != currentRenderer && currentRenderer instanceof TypeRenderer) {
            ((TypeRenderer)((Object)currentRenderer)).setClassName(this.getClassName());
        }
    }

    @Override
    public void setChildrenRenderer(ChildrenRenderer childrenRenderer) {
        ChildrenRenderer prevRenderer = this.getChildrenRenderer();
        super.setChildrenRenderer(this.isBaseRenderer(childrenRenderer) ? null : childrenRenderer);
        ChildrenRenderer currentRenderer = this.getChildrenRenderer();
        if (prevRenderer != currentRenderer && currentRenderer instanceof TypeRenderer) {
            ((TypeRenderer)((Object)currentRenderer)).setClassName(this.getClassName());
        }
    }

    @Override
    public ChildrenRenderer getChildrenRenderer() {
        ChildrenRenderer childrenRenderer = super.getChildrenRenderer();
        return childrenRenderer != null ? childrenRenderer : this.getDefaultRenderer();
    }

    private NodeRenderer getDefaultRenderer() {
        String name2 = this.getClassName();
        if (TypeConversionUtil.isPrimitive((String)name2)) {
            return this.myRendererSettings.getPrimitiveRenderer();
        }
        return name2.endsWith("]") ? this.myRendererSettings.getArrayRenderer() : AUTO_TO_STRING_RENDERER;
    }

    @Override
    public ValueLabelRenderer getLabelRenderer() {
        ValueLabelRenderer labelRenderer = super.getLabelRenderer();
        return labelRenderer != null ? labelRenderer : this.getDefaultRenderer();
    }

    private ChildrenRenderer getRawChildrenRenderer() {
        NodeRenderer classRenderer = this.getDefaultRenderer();
        ChildrenRenderer originalRenderer = super.getChildrenRenderer();
        return originalRenderer == classRenderer ? null : originalRenderer;
    }

    private ValueLabelRenderer getRawLabelRenderer() {
        NodeRenderer classRenderer = this.getDefaultRenderer();
        ValueLabelRenderer originalRenderer = super.getLabelRenderer();
        return originalRenderer == classRenderer ? null : originalRenderer;
    }

    @Override
    public boolean isApplicable(Type type2) {
        if (DebuggerUtils.instanceOf((Type)type2, (String)this.getClassName())) {
            return super.isApplicable(type2);
        }
        return false;
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    public void setClassName(@NotNull String name2) {
        ChildrenRenderer originalChildrenRenderer;
        ValueLabelRenderer originalLabelRenderer;
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/ui/tree/render/CompoundTypeRenderer", "setClassName"));
        }
        this.myProperties.setClassName(name2);
        if (this.getRawLabelRenderer() != null && (originalLabelRenderer = super.getLabelRenderer()) instanceof TypeRenderer) {
            ((TypeRenderer)((Object)originalLabelRenderer)).setClassName(name2);
        }
        if (this.getRawChildrenRenderer() != null && (originalChildrenRenderer = super.getChildrenRenderer()) instanceof TypeRenderer) {
            ((TypeRenderer)((Object)originalChildrenRenderer)).setClassName(name2);
        }
    }

    @NotNull
    public String getClassName() {
        String string = this.myProperties.getClassName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/tree/render/CompoundTypeRenderer", "getClassName"));
        }
        return string;
    }

    protected final PsiElement getContext(Project project2, DebuggerContext context) {
        DebugProcess process2 = context.getDebugProcess();
        GlobalSearchScope scope = process2 != null ? process2.getSearchScope() : GlobalSearchScope.allScope((Project)project2);
        return DebuggerUtils.findClass((String)this.getClassName(), (Project)project2, (GlobalSearchScope)scope);
    }

    protected final PsiElement getChildValueExpression(String text2, DebuggerTreeNode node, DebuggerContext context) {
        Project project2 = node.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        return elementFactory.createExpressionFromText(text2, this.getContext(project2, context));
    }

    public boolean isBaseRenderer(Renderer renderer) {
        return renderer == AUTO_TO_STRING_RENDERER || renderer == this.myRendererSettings.getClassRenderer() || renderer == this.myRendererSettings.getPrimitiveRenderer() || renderer == this.myRendererSettings.getArrayRenderer();
    }

    private static class AutoToStringRenderer
    extends ToStringRenderer {
        private AutoToStringRenderer() {
        }

        @Override
        public String getUniqueId() {
            return "AutoToString";
        }

        @Override
        public boolean isApplicable(Type type2) {
            return type2 instanceof ReferenceType;
        }

        @Override
        public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener2) throws EvaluateException {
            NodeRendererSettings nodeRendererSettings = NodeRendererSettings.getInstance();
            ToStringRenderer toStringRenderer = nodeRendererSettings.getToStringRenderer();
            if (toStringRenderer.isEnabled() && toStringRenderer.isApplicable(descriptor.getType())) {
                return toStringRenderer.calcLabel(descriptor, evaluationContext, listener2);
            }
            return nodeRendererSettings.getClassRenderer().calcLabel(descriptor, evaluationContext, listener2);
        }
    }
}

