/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.feedbacks;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class LineFeedback
extends JComponent {
    protected final Color myColor;
    private final int myLine;
    protected boolean myHorizontal;

    public LineFeedback(Color color, int line, boolean horizontal) {
        this.myColor = color;
        this.myLine = line;
        this.myHorizontal = horizontal;
    }

    public void size(int width, int height) {
        if (this.myHorizontal) {
            this.setSize(width, this.myLine);
        } else {
            this.setSize(this.myLine, height);
        }
    }

    public void horizontal(int x, int y, int width) {
        this.myHorizontal = true;
        this.setBounds(x, y, width, this.myLine);
        this.setVisible(true);
    }

    public void vertical(int x, int y, int height) {
        this.myHorizontal = false;
        this.setBounds(x, y, this.myLine, height);
        this.setVisible(true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.myColor);
        this.paintLines(g);
    }

    protected void paintLines(Graphics g) {
        Dimension size = this.getSize();
        if (this.myHorizontal) {
            this.paintHorizontal(g, size);
        } else {
            this.paintVertical(g, size);
        }
    }

    protected void paintHorizontal(Graphics g, Dimension size) {
        for (int i2 = 0; i2 < this.myLine; ++i2) {
            g.drawLine(0, i2, size.width, i2);
        }
    }

    protected void paintVertical(Graphics g, Dimension size) {
        for (int i2 = 0; i2 < this.myLine; ++i2) {
            g.drawLine(i2, 0, i2, size.height);
        }
    }
}

