/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.DefaultLogFilterModel;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LogConsoleImpl
extends LogConsoleBase {
    private final String myPath;
    @NotNull
    private final File myFile;
    @NotNull
    private final Charset myCharset;
    private FileSnapshot myOldSnapshot;

    /*
     * WARNING - void declaration
     */
    public LogConsoleImpl(Project project2, @NotNull File file2, @NotNull Charset charset, long skippedContents, @NotNull String title, boolean buildInActions, GlobalSearchScope globalSearchScope) {
        void searchScope;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diagnostic/logging/LogConsoleImpl", "<init>"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/diagnostic/logging/LogConsoleImpl", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diagnostic/logging/LogConsoleImpl", "<init>"));
        }
        super(project2, LogConsoleImpl.getReader(file2, charset, skippedContents), title, buildInActions, new DefaultLogFilterModel(project2), (GlobalSearchScope)searchScope);
        this.myPath = file2.getAbsolutePath();
        this.myFile = file2;
        this.myCharset = charset;
        this.myOldSnapshot = new FileSnapshot();
    }

    @Nullable
    private static Reader getReader(@NotNull File file2, @NotNull Charset charset, long skippedContents) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diagnostic/logging/LogConsoleImpl", "getReader"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/diagnostic/logging/LogConsoleImpl", "getReader"));
        }
        try {
            try {
                FileInputStream inputStream = new FileInputStream(file2);
                if (file2.length() >= skippedContents) {
                    for (long skipped = 0L; skipped < skippedContents; skipped += inputStream.skip(skippedContents - skipped)) {
                    }
                }
                return new BufferedReader(new InputStreamReader((InputStream)inputStream, charset));
            }
            catch (FileNotFoundException ignored) {
                if (FileUtilRt.createIfNotExists((File)file2)) {
                    return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), charset));
                }
                return null;
            }
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Nullable
    public String getTooltip() {
        return this.myPath;
    }

    public String getPath() {
        return this.myPath;
    }

    @Override
    @Nullable
    protected BufferedReader updateReaderIfNeeded(@Nullable BufferedReader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        FileSnapshot snapshot = new FileSnapshot();
        if (this.myOldSnapshot.rolloverDetected(snapshot)) {
            reader.close();
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.myFile), this.myCharset));
        }
        this.myOldSnapshot = snapshot;
        return reader;
    }

    private class FileSnapshot {
        final long length;
        final byte[] firstBytes;

        FileSnapshot() {
            this.length = LogConsoleImpl.this.myFile.length();
            byte[] bytes = new byte[20];
            try (FileInputStream stream = new FileInputStream(LogConsoleImpl.this.myFile);){
                stream.read(bytes);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.firstBytes = bytes;
        }

        boolean rolloverDetected(FileSnapshot current) {
            return current.length < this.length || !Arrays.equals(this.firstBytes, current.firstBytes);
        }
    }
}

