/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.actions.DocumentFragmentContent;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DiffPsiFileSupport;
import com.intellij.diff.contents.DirectoryContentImpl;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.contents.FileContentImpl;
import com.intellij.diff.contents.FileDocumentContentImpl;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.LightColors;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffContentFactoryImpl
extends DiffContentFactoryEx {
    private static final Logger LOG = Logger.getInstance(DiffContentFactoryImpl.class);

    @NotNull
    public EmptyContent createEmpty() {
        EmptyContent emptyContent = new EmptyContent();
        if (emptyContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createEmpty"));
        }
        return emptyContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = this.create(null, text2);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text2, @Nullable FileType type2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = this.create(null, text2, type2);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text2, @Nullable FileType type2, boolean respectLineSeparators) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = this.create(null, text2, type2, respectLineSeparators);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text2, @Nullable VirtualFile highlightFile) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = this.create(null, text2, highlightFile);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text2, @Nullable DocumentContent referent) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = this.create(null, text2, referent);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = this.create(project2, text2, (FileType)null);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2, @Nullable FileType type2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = this.create(project2, text2, type2, true);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2, @Nullable FileType type2, boolean respectLineSeparators) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, text2, type2, null, null, respectLineSeparators, true);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2, @NotNull FilePath filePath) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, text2, filePath.getFileType(), filePath.getName(), filePath.getVirtualFile(), true, true);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2, @Nullable VirtualFile highlightFile) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        FileType fileType = highlightFile != null ? highlightFile.getFileType() : null;
        String fileName = highlightFile != null ? highlightFile.getName() : null;
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, text2, fileType, fileName, highlightFile, true, true);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2, @Nullable DocumentContent referent) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        if (referent == null) {
            DocumentContent documentContent = this.create(text2);
            if (documentContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
            }
            return documentContent;
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, text2, referent.getContentType(), null, referent.getHighlightFile(), false, true);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull Document document, @Nullable DocumentContent referent) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = this.create(null, document, referent);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = this.create(project2, document, (FileType)null);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document, @Nullable FileType fileType) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null) {
            DocumentContentImpl documentContentImpl = new DocumentContentImpl(project2, document, fileType, null, null, null, null);
            if (documentContentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
            }
            return documentContentImpl;
        }
        DocumentContent documentContent = this.create(project2, document, file2);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document, @Nullable VirtualFile file2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        if (file2 != null) {
            FileDocumentContentImpl fileDocumentContentImpl = new FileDocumentContentImpl(project2, document, file2);
            if (fileDocumentContentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
            }
            return fileDocumentContentImpl;
        }
        DocumentContentImpl documentContentImpl = new DocumentContentImpl(document);
        if (documentContentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContentImpl;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document, @Nullable DocumentContent referent) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        if (referent == null) {
            DocumentContentImpl documentContentImpl = new DocumentContentImpl(document);
            if (documentContentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
            }
            return documentContentImpl;
        }
        DocumentContentImpl documentContentImpl = new DocumentContentImpl(project2, document, referent.getContentType(), referent.getHighlightFile(), null, null, null);
        if (documentContentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContentImpl;
    }

    @NotNull
    public DiffContent create(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DiffContent diffContent = DiffContentFactoryImpl.createContentFromFile(project2, file2);
        if (diffContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return diffContent;
    }

    @Nullable
    public DocumentContent createDocument(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/DiffContentFactoryImpl", "createDocument"));
        }
        return (DocumentContent)ObjectUtils.tryCast((Object)DiffContentFactoryImpl.createContentFromFile(project2, file2), DocumentContent.class);
    }

    @Nullable
    public FileContent createFile(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/DiffContentFactoryImpl", "createFile"));
        }
        if (file2.isDirectory()) {
            return null;
        }
        return (FileContent)this.create(project2, file2);
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project2, @NotNull Document document, @NotNull TextRange range) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/DiffContentFactoryImpl", "createFragment"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/DiffContentFactoryImpl", "createFragment"));
        }
        DocumentContent content = this.create(project2, document);
        DocumentFragmentContent documentFragmentContent = new DocumentFragmentContent(project2, content, range);
        if (documentFragmentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createFragment"));
        }
        return documentFragmentContent;
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project2, @NotNull DocumentContent content, @NotNull TextRange range) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createFragment"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/DiffContentFactoryImpl", "createFragment"));
        }
        DocumentFragmentContent documentFragmentContent = new DocumentFragmentContent(project2, content, range);
        if (documentFragmentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createFragment"));
        }
        return documentFragmentContent;
    }

    @NotNull
    public DiffContent createClipboardContent() {
        DocumentContent documentContent = this.createClipboardContent(null, null);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createClipboardContent"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable DocumentContent referent) {
        DocumentContent documentContent = this.createClipboardContent(null, referent);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createClipboardContent"));
        }
        return documentContent;
    }

    @NotNull
    public DiffContent createClipboardContent(@Nullable Project project2) {
        DocumentContent documentContent = this.createClipboardContent(project2, null);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createClipboardContent"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable Project project2, @Nullable DocumentContent referent) {
        String text2 = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        FileType type2 = referent != null ? referent.getContentType() : null;
        VirtualFile highlightFile = referent != null ? referent.getHighlightFile() : null;
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, StringUtil.notNullize((String)text2), type2, "Clipboard.txt", highlightFile, false, false);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createClipboardContent"));
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull FilePath filePath) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        if (DiffContentFactoryImpl.isBinaryContent(content, filePath.getFileType())) {
            DiffContent diffContent = DiffContentFactoryImpl.createBinaryImpl(project2, content, filePath.getFileType(), filePath.getName(), filePath.getVirtualFile());
            if (diffContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
            }
            return diffContent;
        }
        DocumentContent documentContent = this.createDocumentFromBytes(project2, content, filePath);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        return documentContent;
    }

    @NotNull
    public DiffContent createFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull FileType fileType, @NotNull String fileName) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        if (DiffContentFactoryImpl.isBinaryContent(content, fileType)) {
            DiffContent diffContent = DiffContentFactoryImpl.createBinaryImpl(project2, content, fileType, fileName, null);
            if (diffContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
            }
            return diffContent;
        }
        DocumentContent documentContent = this.createDocumentFromBytes(project2, content, fileType, fileName);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull VirtualFile highlightFile) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        if (highlightFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightFile", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        if (DiffContentFactoryImpl.isBinaryContent(content, highlightFile.getFileType())) {
            DiffContent diffContent = DiffContentFactoryImpl.createBinaryImpl(project2, content, highlightFile.getFileType(), highlightFile.getName(), highlightFile);
            if (diffContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
            }
            return diffContent;
        }
        DocumentContent documentContent = this.createDocumentFromBytes(project2, content, highlightFile);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull FileType fileType, @NotNull String fileName) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createDocumentFromBytes"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/diff/DiffContentFactoryImpl", "createDocumentFromBytes"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/diff/DiffContentFactoryImpl", "createDocumentFromBytes"));
        }
        EncodingManager e = project2 != null ? EncodingProjectManager.getInstance((Project)project2) : EncodingManager.getInstance();
        DocumentContent documentContent = DiffContentFactoryImpl.createFromBytesImpl(project2, content, fileType, fileName, null, e.getDefaultCharset());
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createDocumentFromBytes"));
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull FilePath filePath) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createDocumentFromBytes"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/diff/DiffContentFactoryImpl", "createDocumentFromBytes"));
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createFromBytesImpl(project2, content, filePath.getFileType(), filePath.getName(), filePath.getVirtualFile(), filePath.getCharset());
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createDocumentFromBytes"));
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull VirtualFile highlightFile) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createDocumentFromBytes"));
        }
        if (highlightFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightFile", "com/intellij/diff/DiffContentFactoryImpl", "createDocumentFromBytes"));
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createFromBytesImpl(project2, content, highlightFile.getFileType(), highlightFile.getName(), highlightFile, highlightFile.getCharset());
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createDocumentFromBytes"));
        }
        return documentContent;
    }

    @NotNull
    public DiffContent createBinary(@Nullable Project project2, @NotNull byte[] content, @NotNull FileType type2, @NotNull String fileName) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createBinary"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/DiffContentFactoryImpl", "createBinary"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/diff/DiffContentFactoryImpl", "createBinary"));
        }
        DiffContent diffContent = DiffContentFactoryImpl.createBinaryImpl(project2, content, type2, fileName, null);
        if (diffContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createBinary"));
        }
        return diffContent;
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/DiffContentFactoryImpl", "createContentFromFile"));
        }
        DiffContent diffContent = DiffContentFactoryImpl.createContentFromFile(project2, file2, file2);
        if (diffContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createContentFromFile"));
        }
        return diffContent;
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project2, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/DiffContentFactoryImpl", "createContentFromFile"));
        }
        if (file2.isDirectory()) {
            DirectoryContentImpl directoryContentImpl = new DirectoryContentImpl(project2, file2, highlightFile);
            if (directoryContentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createContentFromFile"));
            }
            return directoryContentImpl;
        }
        Document document = (Document)ReadAction.compute(() -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/DiffContentFactoryImpl", "lambda$createContentFromFile$0"));
            }
            return FileDocumentManager.getInstance().getDocument(file2);
        });
        if (document != null) {
            FileDocumentContentImpl fileDocumentContentImpl = new FileDocumentContentImpl(project2, document, file2, highlightFile);
            if (fileDocumentContentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createContentFromFile"));
            }
            return fileDocumentContentImpl;
        }
        FileContentImpl fileContentImpl = new FileContentImpl(project2, file2, highlightFile);
        if (fileContentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createContentFromFile"));
        }
        return fileContentImpl;
    }

    @NotNull
    private static DiffContent createBinaryImpl(@Nullable Project project2, @NotNull byte[] content, @NotNull FileType type2, @NotNull String fileName, @Nullable VirtualFile highlightFile) throws IOException {
        VirtualFile file2;
        boolean useTemporalFile;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createBinaryImpl"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/DiffContentFactoryImpl", "createBinaryImpl"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/diff/DiffContentFactoryImpl", "createBinaryImpl"));
        }
        boolean bl = useTemporalFile = type2 instanceof ArchiveFileType || BinaryFileTypeDecompilers.INSTANCE.forFileType(type2) != null;
        if (useTemporalFile) {
            file2 = DiffContentFactoryImpl.createTemporalFile(project2, "tmp", fileName, content);
        } else {
            file2 = new BinaryLightVirtualFile(fileName, type2, content);
            file2.setWritable(false);
        }
        file2.putUserData(DiffUtil.TEMP_FILE_KEY, (Object)Boolean.TRUE);
        DiffContent diffContent = DiffContentFactoryImpl.createContentFromFile(project2, file2, highlightFile);
        if (diffContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createBinaryImpl"));
        }
        return diffContent;
    }

    @NotNull
    private static DocumentContent createImpl(@Nullable Project project2, @NotNull String text2, @Nullable FileType fileType, @Nullable String fileName, @Nullable VirtualFile highlightFile, boolean respectLineSeparators, boolean readOnly) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "createImpl"));
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, text2, fileType, fileName, highlightFile, null, null, respectLineSeparators, readOnly);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createImpl"));
        }
        return documentContent;
    }

    @NotNull
    private static DocumentContent createImpl(@Nullable Project project2, @NotNull String text2, @Nullable FileType fileType, @Nullable String fileName, @Nullable VirtualFile highlightFile, @Nullable Charset charset, @Nullable Boolean bom, boolean respectLineSeparators, boolean readOnly) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "createImpl"));
        }
        if (FileTypes.UNKNOWN.equals(fileType)) {
            fileType = PlainTextFileType.INSTANCE;
        }
        LineSeparator separator = respectLineSeparators ? StringUtil.detectSeparators((CharSequence)text2) : null;
        String correctedContent = StringUtil.convertLineSeparators((String)text2);
        Document document = DiffContentFactoryImpl.createDocument(project2, correctedContent, fileType, fileName, readOnly);
        DocumentContentImpl content = new DocumentContentImpl(project2, document, (FileType)fileType, highlightFile, separator, charset, bom);
        if (fileName != null) {
            content.putUserData(DiffUserDataKeysEx.FILE_NAME, fileName);
        }
        DocumentContentImpl documentContentImpl = content;
        if (documentContentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createImpl"));
        }
        return documentContentImpl;
    }

    @NotNull
    private static DocumentContent createFromBytesImpl(@Nullable Project project2, @NotNull byte[] content, @NotNull FileType fileType, @NotNull String fileName, @Nullable VirtualFile highlightFile, @NotNull Charset charset) {
        String text2;
        Charset bomCharset;
        boolean isBOM;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytesImpl"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytesImpl"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytesImpl"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytesImpl"));
        }
        if (fileType.isBinary()) {
            fileType = PlainTextFileType.INSTANCE;
            Charset guessedCharset = DiffContentFactoryImpl.guessCharsetFromContent(content);
            if (guessedCharset != null) {
                charset = guessedCharset;
            }
        }
        boolean bl = isBOM = (bomCharset = CharsetToolkit.guessFromBOM((byte[])content)) != null;
        if (isBOM) {
            charset = bomCharset;
        }
        boolean malformedContent = false;
        try {
            text2 = CharsetToolkit.tryDecodeString((byte[])content, (Charset)charset);
        }
        catch (CharacterCodingException e) {
            text2 = CharsetToolkit.decodeString((byte[])content, (Charset)charset);
            malformedContent = true;
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, text2, fileType, fileName, highlightFile, charset, isBOM, true, true);
        if (malformedContent) {
            String notificationText = "Content was decoded with errors (using '" + charset.name() + "' charset)";
            DiffUtil.addNotification(DiffNotifications.createNotification(notificationText, LightColors.RED), (UserDataHolder)documentContent);
        }
        DocumentContent documentContent2 = documentContent;
        if (documentContent2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytesImpl"));
        }
        return documentContent2;
    }

    @NotNull
    private static VirtualFile createTemporalFile(@Nullable Project project2, @NotNull String prefix, @NotNull String suffix, @NotNull byte[] content) throws IOException {
        VirtualFile file2;
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/diff/DiffContentFactoryImpl", "createTemporalFile"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/diff/DiffContentFactoryImpl", "createTemporalFile"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createTemporalFile"));
        }
        File tempFile = FileUtil.createTempFile((String)PathUtil.suggestFileName((String)(prefix + "_"), (boolean)true, (boolean)false), (String)PathUtil.suggestFileName((String)("_" + suffix), (boolean)true, (boolean)false), (boolean)true);
        if (content.length != 0) {
            FileUtil.writeToFile((File)tempFile, (byte[])content);
        }
        if (!tempFile.setWritable(false, false)) {
            LOG.warn("Can't set writable attribute of temporal file");
        }
        if ((file2 = VfsUtil.findFileByIoFile((File)tempFile, (boolean)true)) == null) {
            throw new IOException("Can't create temp file for revision content");
        }
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file2});
        VirtualFile virtualFile = file2;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createTemporalFile"));
        }
        return virtualFile;
    }

    @NotNull
    private static Document createDocument(@Nullable Project project2, @NotNull String content, @Nullable FileType fileType, @Nullable String fileName, boolean readOnly) {
        Document document;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createDocument"));
        }
        if (project2 != null && !project2.isDefault() && fileType != null && !fileType.isBinary() && Registry.is((String)"diff.enable.psi.highlighting")) {
            if (fileName == null) {
                fileName = "diff." + StringUtil.defaultIfEmpty((String)fileType.getDefaultExtension(), (String)"txt");
            }
            if ((document = DiffContentFactoryImpl.createPsiDocument(project2, content, fileType, fileName, readOnly)) != null) {
                Document document2 = document;
                if (document2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createDocument"));
                }
                return document2;
            }
        }
        document = EditorFactory.getInstance().createDocument((CharSequence)content);
        document.setReadOnly(readOnly);
        Document document3 = document;
        if (document3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createDocument"));
        }
        return document3;
    }

    @Nullable
    private static Document createPsiDocument(@NotNull Project project2, @NotNull String content, @NotNull FileType fileType, @NotNull String fileName, boolean readOnly) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diff/DiffContentFactoryImpl", "createPsiDocument"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createPsiDocument"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/diff/DiffContentFactoryImpl", "createPsiDocument"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/diff/DiffContentFactoryImpl", "createPsiDocument"));
        }
        return (Document)ReadAction.compute(() -> {
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/diff/DiffContentFactoryImpl", "lambda$createPsiDocument$1"));
            }
            if (fileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/diff/DiffContentFactoryImpl", "lambda$createPsiDocument$1"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "lambda$createPsiDocument$1"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diff/DiffContentFactoryImpl", "lambda$createPsiDocument$1"));
            }
            LightVirtualFile file2 = new LightVirtualFile(fileName, fileType, (CharSequence)content);
            file2.setWritable(!readOnly);
            file2.putUserData(DiffPsiFileSupport.KEY, (Object)true);
            Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)file2);
            if (document == null) {
                return null;
            }
            PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
            return document;
        });
    }

    private static boolean isBinaryContent(@NotNull byte[] content, @NotNull FileType fileType) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "isBinaryContent"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/diff/DiffContentFactoryImpl", "isBinaryContent"));
        }
        if (UnknownFileType.INSTANCE.equals(fileType)) {
            return DiffContentFactoryImpl.guessCharsetFromContent(content) == null;
        }
        return fileType.isBinary();
    }

    @Nullable
    private static Charset guessCharsetFromContent(@NotNull byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "guessCharsetFromContent"));
        }
        CharsetToolkit toolkit = new CharsetToolkit(content);
        Charset fromBOM = toolkit.guessFromBOM();
        if (fromBOM != null) {
            return fromBOM;
        }
        CharsetToolkit.GuessedEncoding guessedEncoding = toolkit.guessFromContent(content.length);
        switch (guessedEncoding) {
            case SEVEN_BIT: {
                return Charset.forName("US-ASCII");
            }
            case VALID_UTF8: {
                return CharsetToolkit.UTF8_CHARSET;
            }
        }
        return null;
    }
}

