/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ComparisonUtil {
    private static final int UNIMPORTANT_LINE_CHAR_COUNT = Registry.intValue((String)"diff.unimportant.line.char.count");

    @Contract(pure=true)
    public static boolean isEquals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonUtil", "isEquals"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonUtil", "isEquals"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonUtil", "isEquals"));
        }
        switch (policy) {
            case DEFAULT: {
                return StringUtil.equals((CharSequence)text1, (CharSequence)text2);
            }
            case TRIM_WHITESPACES: {
                return ComparisonUtil.equalsTrimWhitespaces(text1, text2);
            }
            case IGNORE_WHITESPACES: {
                return StringUtil.equalsIgnoreWhitespaces((CharSequence)text1, (CharSequence)text2);
            }
        }
        throw new IllegalArgumentException(policy.name());
    }

    @Contract(pure=true)
    public static boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        boolean lastLine1;
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/intellij/diff/comparison/ComparisonUtil", "equalsTrimWhitespaces"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/intellij/diff/comparison/ComparisonUtil", "equalsTrimWhitespaces"));
        }
        int index1 = 0;
        int index2 = 0;
        do {
            CharSequence line2;
            lastLine1 = false;
            boolean lastLine2 = false;
            int end1 = StringUtil.indexOf((CharSequence)s1, (char)'\n', (int)index1) + 1;
            int end2 = StringUtil.indexOf((CharSequence)s2, (char)'\n', (int)index2) + 1;
            if (end1 == 0) {
                end1 = s1.length();
                lastLine1 = true;
            }
            if (end2 == 0) {
                end2 = s2.length();
                lastLine2 = true;
            }
            if (lastLine1 ^ lastLine2) {
                return false;
            }
            CharSequence line1 = s1.subSequence(index1, end1);
            if (!StringUtil.equalsTrimWhitespaces((CharSequence)line1, (CharSequence)(line2 = s2.subSequence(index2, end2)))) {
                return false;
            }
            index1 = end1;
            index2 = end2;
        } while (!lastLine1);
        return true;
    }

    public static int getUnimportantLineCharCount() {
        return UNIMPORTANT_LINE_CHAR_COUNT;
    }
}

