/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.merge.TextMergeViewer;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMergeChange
extends ThreesideDiffChangeBase {
    private static final String CTRL_CLICK_TO_RESOLVE = "Ctrl+click to resolve conflict";
    @NotNull
    private final TextMergeViewer myMergeViewer;
    @NotNull
    private final TextMergeViewer.MyThreesideViewer myViewer;
    @NotNull
    private final List<MyGutterOperation> myOperations;
    private final int myIndex;
    @NotNull
    private final MergeLineFragment myFragment;
    private final boolean[] myResolved;
    private boolean myOnesideAppliedConflict;
    @Nullable
    private MergeInnerDifferences myInnerFragments;

    public TextMergeChange(int index, @NotNull MergeLineFragment fragment, @NotNull MergeConflictType conflictType, @NotNull TextMergeViewer viewer) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/merge/TextMergeChange", "<init>"));
        }
        if (conflictType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictType", "com/intellij/diff/merge/TextMergeChange", "<init>"));
        }
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/diff/merge/TextMergeChange", "<init>"));
        }
        super(conflictType);
        this.myOperations = new ArrayList<MyGutterOperation>();
        this.myResolved = new boolean[2];
        this.myMergeViewer = viewer;
        this.myViewer = viewer.getViewer();
        this.myIndex = index;
        this.myFragment = fragment;
        this.reinstallHighlighters();
    }

    public void destroy() {
        this.destroyHighlighters();
        this.destroyOperations();
        this.destroyInnerHighlighters();
    }

    public void reinstallHighlighters() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.destroyOperations();
        this.installOperations();
        this.myViewer.repaintDividers();
    }

    public int getIndex() {
        return this.myIndex;
    }

    void setResolved(@NotNull Side side, boolean value2) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "setResolved"));
        }
        this.myResolved[side.getIndex()] = value2;
        if (this.isResolved()) {
            this.destroyInnerHighlighters();
        } else {
            DocumentEx document = this.myViewer.getEditor((ThreeSide)side.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT)).getDocument();
            for (RangeHighlighter highlighter : this.myInnerHighlighters) {
                if (!document.equals(highlighter.getDocument())) continue;
                highlighter.dispose();
            }
        }
    }

    public boolean isResolved() {
        return this.myResolved[0] && this.myResolved[1];
    }

    public boolean isResolved(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "isResolved"));
        }
        return side.select(this.myResolved);
    }

    public boolean isOnesideAppliedConflict() {
        return this.myOnesideAppliedConflict;
    }

    public void markOnesideAppliedConflict() {
        this.myOnesideAppliedConflict = true;
    }

    @Override
    public boolean isResolved(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "isResolved"));
        }
        switch (side) {
            case LEFT: {
                return this.isResolved(Side.LEFT);
            }
            case BASE: {
                return this.isResolved();
            }
            case RIGHT: {
                return this.isResolved(Side.RIGHT);
            }
        }
        throw new IllegalArgumentException(side.toString());
    }

    public int getStartLine() {
        return this.myViewer.getModel().getLineStart(this.myIndex);
    }

    public int getEndLine() {
        return this.myViewer.getModel().getLineEnd(this.myIndex);
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "getStartLine"));
        }
        if (side == ThreeSide.BASE) {
            return this.getStartLine();
        }
        return this.myFragment.getStartLine(side);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "getEndLine"));
        }
        if (side == ThreeSide.BASE) {
            return this.getEndLine();
        }
        return this.myFragment.getEndLine(side);
    }

    @Override
    @NotNull
    protected Editor getEditor(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "getEditor"));
        }
        EditorEx editorEx = this.myViewer.getEditor(side);
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeChange", "getEditor"));
        }
        return editorEx;
    }

    @Override
    @Nullable
    protected MergeInnerDifferences getInnerFragments() {
        return this.myInnerFragments;
    }

    @NotNull
    public MergeLineFragment getFragment() {
        MergeLineFragment mergeLineFragment = this.myFragment;
        if (mergeLineFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeChange", "getFragment"));
        }
        return mergeLineFragment;
    }

    public void setInnerFragments(@Nullable MergeInnerDifferences innerFragments) {
        if (this.myInnerFragments == null && innerFragments == null) {
            return;
        }
        this.myInnerFragments = innerFragments;
        this.reinstallHighlighters();
        this.destroyInnerHighlighters();
        this.installInnerHighlighters();
    }

    private void installOperations() {
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(ThreeSide.BASE, OperationType.RESOLVE));
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(ThreeSide.LEFT, OperationType.APPLY));
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(ThreeSide.LEFT, OperationType.IGNORE));
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(ThreeSide.RIGHT, OperationType.APPLY));
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(ThreeSide.RIGHT, OperationType.IGNORE));
    }

    private void destroyOperations() {
        for (MyGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    @Nullable
    private MyGutterOperation createOperation(@NotNull ThreeSide side, @NotNull OperationType type2) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "createOperation"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/merge/TextMergeChange", "createOperation"));
        }
        if (this.isResolved(side)) {
            return null;
        }
        EditorEx editor = this.myViewer.getEditor(side);
        DocumentEx document = editor.getDocument();
        int line = this.getStartLine(side);
        int offset = line == DiffUtil.getLineCount(document) ? document.getTextLength() : document.getLineStartOffset(line);
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(offset, offset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
        return new MyGutterOperation(side, highlighter, type2);
    }

    public void updateGutterActions(boolean force) {
        for (MyGutterOperation operation : this.myOperations) {
            operation.update(force);
        }
    }

    @Nullable
    private GutterIconRenderer createApplyRenderer(@NotNull Side side, boolean modifier) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "createApplyRenderer"));
        }
        if (this.isResolved(side)) {
            return null;
        }
        Icon icon = this.isOnesideAppliedConflict() ? DiffUtil.getArrowDownIcon(side) : DiffUtil.getArrowIcon(side);
        return TextMergeChange.createIconRenderer(DiffBundle.message((String)"merge.dialog.apply.change.action.name", (Object[])new Object[0]), icon, this.isConflict(), () -> {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "lambda$createApplyRenderer$1"));
            }
            this.myViewer.executeMergeCommand("Accept change", Collections.singletonList(this), () -> {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "lambda$null$0"));
                }
                this.myViewer.replaceChange(this, side, modifier);
            });
        });
    }

    @Nullable
    private GutterIconRenderer createIgnoreRenderer(@NotNull Side side, boolean modifier) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "createIgnoreRenderer"));
        }
        if (this.isResolved(side)) {
            return null;
        }
        return TextMergeChange.createIconRenderer(DiffBundle.message((String)"merge.dialog.ignore.change.action.name", (Object[])new Object[0]), AllIcons.Diff.Remove, this.isConflict(), () -> {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "lambda$createIgnoreRenderer$3"));
            }
            this.myViewer.executeMergeCommand("Ignore change", Collections.singletonList(this), () -> {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange", "lambda$null$2"));
                }
                this.myViewer.ignoreChange(this, side, modifier);
            });
        });
    }

    @Nullable
    private GutterIconRenderer createResolveRenderer() {
        if (!this.isConflict() || !this.myViewer.canApplyNonConflictedChange(this, ThreeSide.BASE)) {
            return null;
        }
        return TextMergeChange.createIconRenderer(DiffBundle.message((String)"merge.dialog.resolve.change.action.name", (Object[])new Object[0]), AllIcons.Diff.MagicResolve, false, () -> this.myViewer.executeMergeCommand("Resolve conflict", Collections.singletonList(this), () -> this.myViewer.applyNonConflictedChange(this, ThreeSide.BASE)));
    }

    @NotNull
    private static GutterIconRenderer createIconRenderer(@NotNull String text2, @NotNull Icon icon, boolean ctrlClickVisible, final @NotNull Runnable perform) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/merge/TextMergeChange", "createIconRenderer"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/diff/merge/TextMergeChange", "createIconRenderer"));
        }
        if (perform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "perform", "com/intellij/diff/merge/TextMergeChange", "createIconRenderer"));
        }
        String tooltipText = DiffUtil.createTooltipText(text2, ctrlClickVisible ? CTRL_CLICK_TO_RESOLVE : null);
        DiffGutterRenderer diffGutterRenderer = new DiffGutterRenderer(icon, tooltipText){

            @Override
            protected void performAction(AnActionEvent e) {
                perform.run();
            }
        };
        if (diffGutterRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeChange", "createIconRenderer"));
        }
        return diffGutterRenderer;
    }

    @NotNull
    State storeState() {
        State state = new State(this.myIndex, this.getStartLine(), this.getEndLine(), this.myResolved[0], this.myResolved[1], this.myOnesideAppliedConflict);
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/TextMergeChange", "storeState"));
        }
        return state;
    }

    void restoreState(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/diff/merge/TextMergeChange", "restoreState"));
        }
        this.myResolved[0] = state.myResolved1;
        this.myResolved[1] = state.myResolved2;
        this.myOnesideAppliedConflict = state.myOnesideAppliedConflict;
    }

    public static class State
    extends MergeModelBase.State {
        private final boolean myResolved1;
        private final boolean myResolved2;
        private final boolean myOnesideAppliedConflict;

        public State(int index, int startLine, int endLine, boolean resolved1, boolean resolved2, boolean onesideAppliedConflict) {
            super(index, startLine, endLine);
            this.myResolved1 = resolved1;
            this.myResolved2 = resolved2;
            this.myOnesideAppliedConflict = onesideAppliedConflict;
        }
    }

    private static enum OperationType {
        APPLY,
        IGNORE,
        RESOLVE;

    }

    private class MyGutterOperation {
        @NotNull
        private final ThreeSide mySide;
        @NotNull
        private final RangeHighlighter myHighlighter;
        @NotNull
        private final OperationType myType;
        private boolean myCtrlPressed;
        private boolean myShiftPressed;

        private MyGutterOperation(@NotNull ThreeSide side, @NotNull RangeHighlighter highlighter, OperationType type2) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/merge/TextMergeChange$MyGutterOperation", "<init>"));
            }
            if (highlighter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/diff/merge/TextMergeChange$MyGutterOperation", "<init>"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/merge/TextMergeChange$MyGutterOperation", "<init>"));
            }
            this.mySide = side;
            this.myHighlighter = highlighter;
            this.myType = type2;
            this.update(true);
        }

        public void dispose() {
            this.myHighlighter.dispose();
        }

        public void update(boolean force) {
            if (!force && !this.areModifiersChanged()) {
                return;
            }
            if (this.myHighlighter.isValid()) {
                this.myHighlighter.setGutterIconRenderer(this.createRenderer());
            }
        }

        private boolean areModifiersChanged() {
            return this.myCtrlPressed != TextMergeChange.this.myViewer.getModifierProvider().isCtrlPressed() || this.myShiftPressed != TextMergeChange.this.myViewer.getModifierProvider().isShiftPressed();
        }

        @Nullable
        public GutterIconRenderer createRenderer() {
            this.myCtrlPressed = TextMergeChange.this.myViewer.getModifierProvider().isCtrlPressed();
            this.myShiftPressed = TextMergeChange.this.myViewer.getModifierProvider().isShiftPressed();
            if (this.mySide == ThreeSide.BASE) {
                switch (this.myType) {
                    case RESOLVE: {
                        if (!Registry.is((String)"diff.merge.resolve.conflict.action.visible")) {
                            return null;
                        }
                        return TextMergeChange.this.createResolveRenderer();
                    }
                }
                throw new IllegalArgumentException(this.myType.name());
            }
            Side versionSide = (Side)this.mySide.select((Object)Side.LEFT, null, (Object)Side.RIGHT);
            assert (versionSide != null);
            if (!TextMergeChange.this.isChange(versionSide)) {
                return null;
            }
            switch (this.myType) {
                case APPLY: {
                    return TextMergeChange.this.createApplyRenderer(versionSide, this.myCtrlPressed);
                }
                case IGNORE: {
                    return TextMergeChange.this.createIgnoreRenderer(versionSide, this.myCtrlPressed);
                }
            }
            throw new IllegalArgumentException(this.myType.name());
        }
    }
}

