/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import java.awt.Cursor;
import java.awt.Graphics;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffSplitter
extends Splitter {
    @Nullable
    private Painter myPainter;
    @Nullable
    private AnAction myTopAction;
    @Nullable
    private AnAction myBottomAction;

    public DiffSplitter() {
        this.setDividerWidth(JBUI.scale((int)30));
    }

    protected Divider createDivider() {
        return new Splitter.DividerImpl(){

            public void setOrientation(boolean isVerticalSplit) {
                this.removeAll();
                this.setCursor(Cursor.getPredefinedCursor(10));
                List actionComponents = ContainerUtil.list((Object[])new JComponent[]{DiffSplitter.createActionComponent(DiffSplitter.this.myTopAction), DiffSplitter.createActionComponent(DiffSplitter.this.myBottomAction)});
                List<JComponent> syncComponents = DiffUtil.createSyncHeightComponents(actionComponents);
                GridBag bag = new GridBag();
                if (syncComponents.get(0) != null) {
                    this.add(syncComponents.get(0), bag.nextLine());
                    this.add(Box.createVerticalStrut(JBUI.scale((int)20)), bag.nextLine());
                }
                this.add(new JLabel(AllIcons.General.SplitGlueH), bag.nextLine());
                if (syncComponents.get(1) != null) {
                    this.add(Box.createVerticalStrut(JBUI.scale((int)20)), bag.nextLine());
                    this.add(syncComponents.get(1), bag.nextLine());
                }
                this.revalidate();
                this.repaint();
            }

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (DiffSplitter.this.myPainter != null) {
                    DiffSplitter.this.myPainter.paint(g, (JComponent)((Object)this));
                }
            }
        };
    }

    public void setTopAction(@Nullable AnAction value2) {
        this.myTopAction = value2;
        this.setOrientation(false);
    }

    public void setBottomAction(@Nullable AnAction value2) {
        this.myBottomAction = value2;
        this.setOrientation(false);
    }

    public void setPainter(@Nullable Painter painter) {
        this.myPainter = painter;
    }

    public void repaintDivider() {
        this.getDivider().repaint();
    }

    @Nullable
    private static JComponent createActionComponent(@Nullable AnAction action) {
        if (action == null) {
            return null;
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DiffSplitter", (ActionGroup)new DefaultActionGroup(new AnAction[]{action}), true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.getComponent().setCursor(Cursor.getDefaultCursor());
        return toolbar.getComponent();
    }

    public static interface Painter {
        public void paint(@NotNull Graphics var1, @NotNull JComponent var2);
    }
}

