/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.DiffContext;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TransferableFileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ToggleActionButton;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransferableFileEditorStateSupport {
    @NotNull
    private static final Key<Map<String, Map<String, String>>> TRANSFERABLE_FILE_EDITOR_STATE = Key.create((String)"Diff.TransferableFileEditorState");
    private static final Condition<BinaryEditorHolder> IS_SUPPORTED = holder -> TransferableFileEditorStateSupport.getEditorState(holder.getEditor()) != null;
    @NotNull
    private final DiffSettingsHolder.DiffSettings mySettings;
    @NotNull
    private final List<BinaryEditorHolder> myHolders;
    private final boolean mySupported;

    public TransferableFileEditorStateSupport(@NotNull DiffSettingsHolder.DiffSettings settings, @NotNull List<BinaryEditorHolder> holders, @NotNull Disposable disposable) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport", "<init>"));
        }
        if (holders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holders", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport", "<init>"));
        }
        this.mySettings = settings;
        this.myHolders = holders;
        this.mySupported = ContainerUtil.or(this.myHolders, IS_SUPPORTED);
        new MySynchronizer(ContainerUtil.filter(this.myHolders, IS_SUPPORTED)).install(disposable);
    }

    public boolean isSupported() {
        return this.mySupported;
    }

    public boolean isEnabled() {
        return this.mySettings.isSyncBinaryEditorSettings();
    }

    public void setEnabled(boolean enabled) {
        this.mySettings.setSyncBinaryEditorSettings(enabled);
    }

    public void processContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport", "processContextHints"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport", "processContextHints"));
        }
        if (!this.isEnabled()) {
            return;
        }
        for (BinaryEditorHolder holder : this.myHolders) {
            FileEditor editor = holder.getEditor();
            TransferableFileEditorState state = TransferableFileEditorStateSupport.getEditorState(holder.getEditor());
            if (state == null) continue;
            TransferableFileEditorStateSupport.readContextData(context, editor, state);
        }
    }

    public void updateContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport", "updateContextHints"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport", "updateContextHints"));
        }
        if (!this.isEnabled()) {
            return;
        }
        HashSet updated = ContainerUtil.newHashSet();
        for (BinaryEditorHolder holder : this.myHolders) {
            boolean processed2;
            TransferableFileEditorState state = TransferableFileEditorStateSupport.getEditorState(holder.getEditor());
            if (state == null || (processed2 = !updated.add(state.getEditorId()))) continue;
            TransferableFileEditorStateSupport.writeContextData(context, state);
        }
    }

    @NotNull
    public AnAction createToggleAction() {
        ToggleSynchronousEditorStatesAction toggleSynchronousEditorStatesAction = new ToggleSynchronousEditorStatesAction(this);
        if (toggleSynchronousEditorStatesAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport", "createToggleAction"));
        }
        return toggleSynchronousEditorStatesAction;
    }

    private static void readContextData(@NotNull DiffContext context, @NotNull FileEditor editor, @NotNull TransferableFileEditorState state) {
        Map options;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport", "readContextData"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport", "readContextData"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport", "readContextData"));
        }
        Map map2 = (Map)context.getUserData(TRANSFERABLE_FILE_EDITOR_STATE);
        Map map3 = options = map2 != null ? (Map)map2.get(state.getEditorId()) : null;
        if (options == null) {
            return;
        }
        state.setTransferableOptions(options);
        editor.setState((FileEditorState)state);
    }

    private static void writeContextData(@NotNull DiffContext context, @NotNull TransferableFileEditorState state) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport", "writeContextData"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport", "writeContextData"));
        }
        Map map2 = (Map)context.getUserData(TRANSFERABLE_FILE_EDITOR_STATE);
        if (map2 == null) {
            map2 = ContainerUtil.newHashMap();
            context.putUserData(TRANSFERABLE_FILE_EDITOR_STATE, (Object)map2);
        }
        map2.put(state.getEditorId(), state.getTransferableOptions());
    }

    @Nullable
    private static TransferableFileEditorState getEditorState(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport", "getEditorState"));
        }
        FileEditorState state = editor.getState(FileEditorStateLevel.FULL);
        return state instanceof TransferableFileEditorState ? (TransferableFileEditorState)state : null;
    }

    private class ToggleSynchronousEditorStatesAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        private final TransferableFileEditorStateSupport mySupport;

        public ToggleSynchronousEditorStatesAction(TransferableFileEditorStateSupport support) {
            if (support == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport$ToggleSynchronousEditorStatesAction", "<init>"));
            }
            super("Synchronize Editors Settings", AllIcons.Actions.SyncPanels);
            this.mySupport = support;
        }

        public boolean isVisible() {
            return this.mySupport.isSupported();
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySupport.isEnabled();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySupport.setEnabled(state);
        }
    }

    private class MySynchronizer
    implements PropertyChangeListener {
        @NotNull
        private final List<? extends FileEditor> myEditors;
        private boolean myDuringUpdate;

        public MySynchronizer(List<BinaryEditorHolder> editors) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport$MySynchronizer", "<init>"));
            }
            this.myDuringUpdate = false;
            this.myEditors = ContainerUtil.map(editors, holder -> holder.getEditor());
        }

        public void install(@NotNull Disposable disposable) {
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport$MySynchronizer", "install"));
            }
            if (this.myEditors.size() < 2) {
                return;
            }
            for (FileEditor fileEditor : this.myEditors) {
                fileEditor.addPropertyChangeListener((PropertyChangeListener)this);
            }
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    for (FileEditor editor : MySynchronizer.this.myEditors) {
                        editor.removePropertyChangeListener((PropertyChangeListener)MySynchronizer.this);
                    }
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.myDuringUpdate || !TransferableFileEditorStateSupport.this.isEnabled()) {
                return;
            }
            if (!(evt.getSource() instanceof FileEditor)) {
                return;
            }
            TransferableFileEditorState sourceState = TransferableFileEditorStateSupport.getEditorState((FileEditor)evt.getSource());
            if (sourceState == null) {
                return;
            }
            Map options = sourceState.getTransferableOptions();
            String id = sourceState.getEditorId();
            for (FileEditor fileEditor : this.myEditors) {
                if (evt.getSource() == fileEditor) continue;
                this.updateEditor(fileEditor, id, options);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateEditor(@NotNull FileEditor editor, @NotNull String id, @NotNull Map<String, String> options) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport$MySynchronizer", "updateEditor"));
            }
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport$MySynchronizer", "updateEditor"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport$MySynchronizer", "updateEditor"));
            }
            try {
                this.myDuringUpdate = true;
                TransferableFileEditorState state = TransferableFileEditorStateSupport.getEditorState(editor);
                if (state != null && state.getEditorId().equals(id)) {
                    state.setTransferableOptions(options);
                    editor.setState((FileEditorState)state);
                }
            }
            finally {
                this.myDuringUpdate = false;
            }
        }
    }
}

