/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ListenerDiffViewerBase
extends DiffViewerBase {
    public ListenerDiffViewerBase(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase", "<init>"));
        }
        super(context, request);
    }

    @Override
    protected void onInit() {
        super.onInit();
        VirtualFileListener fileListener = this.createFileListener(this.myRequest);
        if (fileListener != null) {
            VirtualFileManager.getInstance().addVirtualFileListener(fileListener, (Disposable)this);
        }
        DocumentListener documentListener = this.createDocumentListener();
        List documents = ContainerUtil.mapNotNull((Collection)this.myRequest.getContents(), content -> content instanceof DocumentContent ? ((DocumentContent)content).getDocument() : null);
        TextDiffViewerUtil.installDocumentListeners(documentListener, documents, (Disposable)this);
    }

    @NotNull
    protected DocumentListener createDocumentListener() {
        DocumentListener documentListener = new DocumentListener(){

            public void beforeDocumentChange(DocumentEvent event) {
                ListenerDiffViewerBase.this.onBeforeDocumentChange(event);
            }

            public void documentChanged(DocumentEvent event) {
                ListenerDiffViewerBase.this.onDocumentChange(event);
            }
        };
        if (documentListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase", "createDocumentListener"));
        }
        return documentListener;
    }

    @Nullable
    protected VirtualFileListener createFileListener(@NotNull ContentDiffRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase", "createFileListener"));
        }
        final ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(0);
        for (DiffContent content : request.getContents()) {
            if (!(content instanceof FileContent) || content instanceof DocumentContent) continue;
            files.add(((FileContent)content).getFile());
        }
        if (files.isEmpty()) {
            return null;
        }
        return new VirtualFileListener(){

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase$2", "contentsChanged"));
                }
                if (files.contains(event.getFile())) {
                    ListenerDiffViewerBase.this.onFileChange(event);
                }
            }

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase$2", "propertyChanged"));
                }
                if (files.contains(event.getFile())) {
                    ListenerDiffViewerBase.this.onFileChange((VirtualFileEvent)event);
                }
            }
        };
    }

    protected void onDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase", "onDocumentChange"));
        }
        this.scheduleRediff();
    }

    protected void onBeforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase", "onBeforeDocumentChange"));
        }
    }

    protected void onFileChange(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/base/ListenerDiffViewerBase", "onFileChange"));
        }
        this.scheduleRediff();
    }
}

