/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffLineSeparatorRenderer
implements LineMarkerRendererEx,
LineSeparatorRenderer {
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final BooleanGetter myCondition;
    private static final ColorKey BACKGROUND = ColorKey.createColorKey((String)"DIFF_SEPARATORS_BACKGROUND");
    private static final ColorKey TOP_BORDER = ColorKey.createColorKey((String)"DIFF_SEPARATORS_TOP_BORDER");
    private static final ColorKey BOTTOM_BORDER = ColorKey.createColorKey((String)"DIFF_SEPARATORS_BOTTOM_BORDER");

    public DiffLineSeparatorRenderer(@NotNull Editor editor, @NotNull BooleanGetter condition2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffLineSeparatorRenderer", "<init>"));
        }
        if (condition2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/diff/util/DiffLineSeparatorRenderer", "<init>"));
        }
        this.myEditor = editor;
        this.myCondition = condition2;
    }

    public static void drawConnectorLine(@NotNull Graphics2D g, int x1, int x2, int y1, int y2, int lineHeight, @Nullable EditorColorsScheme scheme2) {
        int[] yPoints;
        int[] xPoints;
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffLineSeparatorRenderer", "drawConnectorLine"));
        }
        int step = DiffLineSeparatorRenderer.getStepSize(lineHeight);
        int height = DiffLineSeparatorRenderer.getHeight(lineHeight);
        int dx = DiffLineSeparatorRenderer.getDeltaX(lineHeight);
        int dy = DiffLineSeparatorRenderer.getDeltaY(lineHeight);
        int start1 = y1 + (lineHeight - height - step) / 2 + step / 2;
        int start2 = y2 + (lineHeight - height - step) / 2 + step / 2;
        int end1 = start1 + height - 1;
        int end2 = start2 + height - 1;
        if (Math.abs(x2 - x1) < Math.abs(y2 - y1)) {
            if (y2 < y1) {
                xPoints = new int[]{x1, x2 - dx, x2, x2, x1 + dx, x1};
                yPoints = new int[]{start1, start2 + dy, start2, end2, end1 - dy, end1};
            } else {
                xPoints = new int[]{x1, x1 + dx, x2, x2, x2 - dx, x1};
                yPoints = new int[]{start1, start1 + dy, start2, end2, end2 - dy, end1};
            }
        } else {
            xPoints = new int[]{x1, x2, x2, x1};
            yPoints = new int[]{start1, start2, end2, end1};
        }
        DiffLineSeparatorRenderer.paintConnectorLine(g, xPoints, yPoints, lineHeight, scheme2);
    }

    public void paint(Editor editor, Graphics g, Rectangle r) {
        if (!this.myCondition.get()) {
            return;
        }
        int y = r.y;
        int lineHeight = this.myEditor.getLineHeight();
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        int annotationsOffset = gutter.getAnnotationsAreaOffset();
        int annotationsWidth = gutter.getAnnotationsAreaWidth();
        if (annotationsWidth != 0) {
            g.setColor(editor.getColorsScheme().getColor(EditorColors.GUTTER_BACKGROUND));
            g.fillRect(annotationsOffset, y, annotationsWidth, lineHeight);
        }
        DiffLineSeparatorRenderer.draw(g, 0, y, lineHeight, this.myEditor.getColorsScheme());
    }

    public void drawLine(Graphics g, int x1, int x2, int y) {
        if (!this.myCondition.get()) {
            return;
        }
        ++y;
        int gutterWidth = ((EditorEx)this.myEditor).getGutterComponentEx().getWidth();
        int lineHeight = this.myEditor.getLineHeight();
        int interval = DiffLineSeparatorRenderer.getStepSize(lineHeight) * 2;
        int shiftX = -interval;
        if (DiffUtil.isMirrored(this.myEditor)) {
            int contentWidth = ((EditorEx)this.myEditor).getScrollPane().getViewport().getWidth();
            shiftX += contentWidth % interval - interval;
            shiftX += gutterWidth % interval - interval;
        } else {
            shiftX += -gutterWidth % interval - interval;
        }
        DiffLineSeparatorRenderer.draw(g, shiftX, y, lineHeight, this.myEditor.getColorsScheme());
    }

    @Override
    public LineMarkerRendererEx.Position getPosition() {
        return LineMarkerRendererEx.Position.CUSTOM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void draw(@NotNull Graphics g, int shiftX, int shiftY, int lineHeight, @Nullable EditorColorsScheme scheme2) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffLineSeparatorRenderer", "draw"));
        }
        int step = DiffLineSeparatorRenderer.getStepSize(lineHeight);
        int height = DiffLineSeparatorRenderer.getHeight(lineHeight);
        Rectangle clip = g.getClipBounds();
        if (clip.width <= 0) {
            return;
        }
        int count = clip.width / step + 3;
        int shift = (clip.x - shiftX) / step;
        int[] xPoints = new int[count];
        int[] yPoints = new int[count];
        shiftY += (lineHeight - height - step) / 2;
        for (int index = 0; index < count; ++index) {
            int absIndex = index + shift;
            int xPos = absIndex * step + shiftX;
            int yPos = absIndex == 0 ? step / 2 + shiftY : (absIndex % 2 == 0 ? shiftY : step + shiftY);
            xPoints[index] = xPos;
            yPoints[index] = yPos;
        }
        GraphicsConfig config = GraphicsUtil.disableAAPainting((Graphics)g);
        try {
            DiffLineSeparatorRenderer.paintLine(g, xPoints, yPoints, lineHeight, scheme2);
        }
        finally {
            config.restore();
        }
    }

    private static void paintLine(@NotNull Graphics g, @NotNull int[] xPoints, @NotNull int[] yPoints, int lineHeight, @Nullable EditorColorsScheme scheme2) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffLineSeparatorRenderer", "paintLine"));
        }
        if (xPoints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xPoints", "com/intellij/diff/util/DiffLineSeparatorRenderer", "paintLine"));
        }
        if (yPoints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yPoints", "com/intellij/diff/util/DiffLineSeparatorRenderer", "paintLine"));
        }
        int height = DiffLineSeparatorRenderer.getHeight(lineHeight);
        if (scheme2 == null) {
            scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        }
        Graphics2D gg = (Graphics2D)g;
        AffineTransform oldTransform = gg.getTransform();
        for (int i2 = 0; i2 < height; ++i2) {
            Color color = DiffLineSeparatorRenderer.getTopBorderColor(i2, lineHeight, scheme2);
            if (color == null) {
                color = DiffLineSeparatorRenderer.getBottomBorderColor(i2, lineHeight, scheme2);
            }
            if (color == null) {
                color = DiffLineSeparatorRenderer.getBackgroundColor(scheme2);
            }
            gg.setColor(color);
            gg.drawPolyline(xPoints, yPoints, xPoints.length);
            gg.translate(0, 1);
        }
        gg.setTransform(oldTransform);
    }

    private static void paintConnectorLine(@NotNull Graphics g, @NotNull int[] xPoints, @NotNull int[] yPoints, int lineHeight, @Nullable EditorColorsScheme scheme2) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffLineSeparatorRenderer", "paintConnectorLine"));
        }
        if (xPoints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xPoints", "com/intellij/diff/util/DiffLineSeparatorRenderer", "paintConnectorLine"));
        }
        if (yPoints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yPoints", "com/intellij/diff/util/DiffLineSeparatorRenderer", "paintConnectorLine"));
        }
        int height = DiffLineSeparatorRenderer.getHeight(lineHeight);
        if (scheme2 == null) {
            scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        }
        Graphics2D gg = (Graphics2D)g;
        AffineTransform oldTransform = gg.getTransform();
        gg.setColor(DiffLineSeparatorRenderer.getBackgroundColor(scheme2));
        gg.fillPolygon(xPoints, yPoints, xPoints.length);
        if (scheme2.getColor(TOP_BORDER) != null) {
            Color color;
            for (int i2 = 0; i2 < height && (color = DiffLineSeparatorRenderer.getTopBorderColor(i2, lineHeight, scheme2)) != null; ++i2) {
                gg.setColor(color);
                gg.drawPolyline(xPoints, yPoints, xPoints.length / 2);
                gg.translate(0, 1);
            }
            gg.setTransform(oldTransform);
        }
        if (scheme2.getColor(BOTTOM_BORDER) != null) {
            Color color;
            int[] xBottomPoints = Arrays.copyOfRange(xPoints, xPoints.length / 2, xPoints.length);
            int[] yBottomPoints = Arrays.copyOfRange(yPoints, xPoints.length / 2, xPoints.length);
            for (int i3 = height - 1; i3 >= 0 && (color = DiffLineSeparatorRenderer.getBottomBorderColor(i3, lineHeight, scheme2)) != null; --i3) {
                gg.setColor(color);
                gg.drawPolyline(xBottomPoints, yBottomPoints, xPoints.length / 2);
                gg.translate(0, -1);
            }
            gg.setTransform(oldTransform);
        }
    }

    private static int getStepSize(int lineHeight) {
        return Math.max(lineHeight / 3, 1);
    }

    private static int getHeight(int lineHeight) {
        return Math.max(lineHeight / 2, 1);
    }

    private static int getDeltaX(int lineHeight) {
        return Math.max(lineHeight / 4, 1);
    }

    private static int getDeltaY(int lineHeight) {
        return Math.max(lineHeight / 6, 1);
    }

    @NotNull
    private static Color getBackgroundColor(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/diff/util/DiffLineSeparatorRenderer", "getBackgroundColor"));
        }
        Color color = scheme2.getColor(BACKGROUND);
        Color color2 = color != null ? color : Gray._128;
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffLineSeparatorRenderer", "getBackgroundColor"));
        }
        return color2;
    }

    @Nullable
    private static Color getTopBorderColor(int i2, int lineHeight, @NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/diff/util/DiffLineSeparatorRenderer", "getTopBorderColor"));
        }
        int border = Math.max(lineHeight / 4, 1);
        double ratio = (double)i2 / (double)border;
        if (ratio > 1.0) {
            return null;
        }
        Color top = scheme2.getColor(TOP_BORDER);
        if (top == null) {
            return null;
        }
        Color background = DiffLineSeparatorRenderer.getBackgroundColor(scheme2);
        return ColorUtil.mix((Color)top, (Color)background, (double)ratio);
    }

    @Nullable
    private static Color getBottomBorderColor(int i2, int lineHeight, @NotNull EditorColorsScheme scheme2) {
        int border;
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/diff/util/DiffLineSeparatorRenderer", "getBottomBorderColor"));
        }
        int height = DiffLineSeparatorRenderer.getHeight(lineHeight);
        int index = height - i2 - 1;
        double ratio = (double)index / (double)(border = Math.max(lineHeight / 12, 1));
        if (ratio > 1.0) {
            return null;
        }
        Color bottom = scheme2.getColor(BOTTOM_BORDER);
        if (bottom == null) {
            return null;
        }
        Color background = DiffLineSeparatorRenderer.getBackgroundColor(scheme2);
        return ColorUtil.mix((Color)bottom, (Color)background, (double)ratio);
    }
}

