/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDiffTypeFactory {
    @NotNull
    public static final TextDiffTypeImpl INSERTED = new TextDiffTypeImpl(DiffColors.DIFF_INSERTED, DiffBundle.message((String)"diff.type.inserted.name", (Object[])new Object[0]));
    @NotNull
    public static final TextDiffTypeImpl DELETED = new TextDiffTypeImpl(DiffColors.DIFF_DELETED, DiffBundle.message((String)"diff.type.deleted.name", (Object[])new Object[0]));
    @NotNull
    public static final TextDiffTypeImpl MODIFIED = new TextDiffTypeImpl(DiffColors.DIFF_MODIFIED, DiffBundle.message((String)"diff.type.changed.name", (Object[])new Object[0]));
    @NotNull
    public static final TextDiffTypeImpl CONFLICT = new TextDiffTypeImpl(DiffColors.DIFF_CONFLICT, DiffBundle.message((String)"diff.type.conflict.name", (Object[])new Object[0]));
    private static final TextDiffTypeFactory ourInstance = new TextDiffTypeFactory();
    private final List<TextDiffTypeImpl> myTypes = new ArrayList<TextDiffTypeImpl>();
    private static final double MIDDLE_COLOR_FACTOR = 0.6;

    private TextDiffTypeFactory() {
        ContainerUtil.addAll(this.myTypes, (Object[])new TextDiffTypeImpl[]{INSERTED, DELETED, MODIFIED, CONFLICT});
    }

    @NotNull
    public synchronized TextDiffType createTextDiffType(@NonNls @NotNull TextAttributesKey key2, @NotNull String name2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/TextDiffTypeFactory", "createTextDiffType"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diff/util/TextDiffTypeFactory", "createTextDiffType"));
        }
        TextDiffTypeImpl type2 = new TextDiffTypeImpl(key2, name2);
        this.myTypes.add(type2);
        TextDiffTypeImpl textDiffTypeImpl = type2;
        if (textDiffTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory", "createTextDiffType"));
        }
        return textDiffTypeImpl;
    }

    public synchronized TextDiffTypeImpl[] getAllDiffTypes() {
        return (TextDiffTypeImpl[])ArrayUtil.toObjectArray(this.myTypes, TextDiffTypeImpl.class);
    }

    public static TextDiffTypeFactory getInstance() {
        return ourInstance;
    }

    @NotNull
    public static Color getMiddleColor(@NotNull Color fg, @NotNull Color bg) {
        if (fg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fg", "com/intellij/diff/util/TextDiffTypeFactory", "getMiddleColor"));
        }
        if (bg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bg", "com/intellij/diff/util/TextDiffTypeFactory", "getMiddleColor"));
        }
        Color color = ColorUtil.mix((Color)fg, (Color)bg, (double)0.6);
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory", "getMiddleColor"));
        }
        return color;
    }

    public static class TextDiffTypeImpl
    implements TextDiffType {
        @NotNull
        private final TextAttributesKey myKey;
        @NotNull
        private final String myName;

        public TextDiffTypeImpl(@NotNull TextAttributesKey key2, @NotNull String name2) {
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "<init>"));
            }
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "<init>"));
            }
            this.myKey = key2;
            this.myName = name2;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getName"));
            }
            return string;
        }

        @NotNull
        public TextAttributes getAttributes(@Nullable Editor editor) {
            if (editor == null) {
                TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(this.myKey);
                if (textAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getAttributes"));
                }
                return textAttributes;
            }
            TextAttributes textAttributes = editor.getColorsScheme().getAttributes(this.myKey);
            if (textAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getAttributes"));
            }
            return textAttributes;
        }

        @Override
        @NotNull
        public Color getColor(@Nullable Editor editor) {
            Color color = (Color)ObjectUtils.notNull((Object)this.getAttributes(editor).getBackgroundColor(), (Object)JBColor.DARK_GRAY);
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getColor"));
            }
            return color;
        }

        @Override
        @NotNull
        public Color getIgnoredColor(@Nullable Editor editor) {
            Color color = this.getAttributes(editor).getForegroundColor();
            if (color != null) {
                Color color2 = color;
                if (color2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getIgnoredColor"));
                }
                return color2;
            }
            Color fg = this.getColor(editor);
            Color bg = editor instanceof EditorEx ? ((EditorEx)editor).getBackgroundColor() : EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
            Color color3 = ColorUtil.mix((Color)fg, (Color)bg, (double)0.6);
            if (color3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getIgnoredColor"));
            }
            return color3;
        }

        @Override
        @Nullable
        public Color getMarkerColor(@Nullable Editor editor) {
            return this.getAttributes(editor).getErrorStripeColor();
        }

        @NotNull
        public TextAttributesKey getKey() {
            TextAttributesKey textAttributesKey = this.myKey;
            if (textAttributesKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getKey"));
            }
            return textAttributesKey;
        }

        public String toString() {
            return this.myName;
        }
    }
}

