/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.Extensions;
import gnu.trove.TIntObjectHashMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesProfileCache {
    private static final Map<DupInfo, TIntObjectHashMap<DuplicatesProfile>> ourProfileCache = new HashMap<DupInfo, TIntObjectHashMap<DuplicatesProfile>>();
    private static final DuplicatesProfile NULL_PROFILE = new DuplicatesProfile(){

        @Override
        @NotNull
        public DuplocateVisitor createVisitor(@NotNull FragmentsCollector collector) {
            if (collector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/dupLocator/DuplicatesProfileCache$1", "createVisitor"));
            }
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/DuplicatesProfileCache$1", "createVisitor"));
            }
            return null;
        }

        @Override
        public boolean isMyLanguage(@NotNull Language language) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/DuplicatesProfileCache$1", "isMyLanguage"));
            }
            return false;
        }

        @Override
        @NotNull
        public DuplocatorState getDuplocatorState(@NotNull Language language) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/DuplicatesProfileCache$1", "getDuplocatorState"));
            }
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/DuplicatesProfileCache$1", "getDuplocatorState"));
            }
            return null;
        }

        @Override
        public boolean isMyDuplicate(@NotNull DupInfo info, int index) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/dupLocator/DuplicatesProfileCache$1", "isMyDuplicate"));
            }
            return false;
        }
    };

    private DuplicatesProfileCache() {
    }

    public static void clear(@NotNull DupInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/dupLocator/DuplicatesProfileCache", "clear"));
        }
        ourProfileCache.remove(info);
    }

    @Nullable
    public static DuplicatesProfile getProfile(@NotNull DupInfo dupInfo, int index) {
        DuplicatesProfile result2;
        if (dupInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dupInfo", "com/intellij/dupLocator/DuplicatesProfileCache", "getProfile"));
        }
        TIntObjectHashMap patternCache = ourProfileCache.get(dupInfo);
        if (patternCache == null) {
            patternCache = new TIntObjectHashMap();
            ourProfileCache.put(dupInfo, (TIntObjectHashMap<DuplicatesProfile>)patternCache);
        }
        if ((result2 = (DuplicatesProfile)patternCache.get(index)) == null) {
            DuplicatesProfile[] profiles = (DuplicatesProfile[])Extensions.getExtensions(DuplicatesProfile.EP_NAME);
            DuplicatesProfile theProfile = null;
            for (DuplicatesProfile profile2 : profiles) {
                if (!profile2.isMyDuplicate(dupInfo, index)) continue;
                theProfile = profile2;
                break;
            }
            result2 = theProfile == null ? NULL_PROFILE : theProfile;
            patternCache.put(index, (Object)result2);
        }
        return result2 == NULL_PROFILE ? null : result2;
    }
}

