/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.equivalence;

import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.MultiChildDescriptor;
import com.intellij.dupLocator.equivalence.SingleChildDescriptor;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EquivalenceDescriptorBuilder
implements EquivalenceDescriptor {
    private final List<SingleChildDescriptor> mySingleChildDescriptors = new ArrayList<SingleChildDescriptor>();
    private final List<MultiChildDescriptor> myMultiChildDescriptors = new ArrayList<MultiChildDescriptor>();
    private final List<Object> myConstants = new ArrayList<Object>();
    private final List<PsiElement[]> myCodeBlocks = new ArrayList<PsiElement[]>();

    @Override
    public List<SingleChildDescriptor> getSingleChildDescriptors() {
        return this.mySingleChildDescriptors;
    }

    @Override
    public List<MultiChildDescriptor> getMultiChildDescriptors() {
        return this.myMultiChildDescriptors;
    }

    @Override
    public List<Object> getConstants() {
        return this.myConstants;
    }

    @Override
    @NotNull
    public List<PsiElement[]> getCodeBlocks() {
        List<PsiElement[]> list2 = this.myCodeBlocks;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/equivalence/EquivalenceDescriptorBuilder", "getCodeBlocks"));
        }
        return list2;
    }

    public EquivalenceDescriptorBuilder codeBlock(@Nullable PsiElement[] block) {
        this.myCodeBlocks.add(block);
        return this;
    }

    public EquivalenceDescriptorBuilder element(@Nullable PsiElement element) {
        return this.add(SingleChildDescriptor.MyType.DEFAULT, element);
    }

    public EquivalenceDescriptorBuilder elements(@Nullable PsiElement[] elements) {
        return this.add(MultiChildDescriptor.MyType.DEFAULT, elements);
    }

    public EquivalenceDescriptorBuilder children(@Nullable PsiElement element) {
        return this.add(SingleChildDescriptor.MyType.CHILDREN, element);
    }

    @NotNull
    public EquivalenceDescriptorBuilder optionally(@Nullable PsiElement element) {
        EquivalenceDescriptorBuilder equivalenceDescriptorBuilder = this.add(SingleChildDescriptor.MyType.OPTIONALLY, element);
        if (equivalenceDescriptorBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/equivalence/EquivalenceDescriptorBuilder", "optionally"));
        }
        return equivalenceDescriptorBuilder;
    }

    @NotNull
    public EquivalenceDescriptorBuilder optionallyInPattern(@Nullable PsiElement element) {
        EquivalenceDescriptorBuilder equivalenceDescriptorBuilder = this.add(SingleChildDescriptor.MyType.OPTIONALLY_IN_PATTERN, element);
        if (equivalenceDescriptorBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/equivalence/EquivalenceDescriptorBuilder", "optionallyInPattern"));
        }
        return equivalenceDescriptorBuilder;
    }

    @NotNull
    public EquivalenceDescriptorBuilder optionally(@Nullable PsiElement[] elements) {
        EquivalenceDescriptorBuilder equivalenceDescriptorBuilder = this.add(MultiChildDescriptor.MyType.OPTIONALLY, elements);
        if (equivalenceDescriptorBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/equivalence/EquivalenceDescriptorBuilder", "optionally"));
        }
        return equivalenceDescriptorBuilder;
    }

    @NotNull
    public EquivalenceDescriptorBuilder optionallyInPattern(@Nullable PsiElement[] elements) {
        EquivalenceDescriptorBuilder equivalenceDescriptorBuilder = this.add(MultiChildDescriptor.MyType.OPTIONALLY_IN_PATTERN, elements);
        if (equivalenceDescriptorBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/equivalence/EquivalenceDescriptorBuilder", "optionallyInPattern"));
        }
        return equivalenceDescriptorBuilder;
    }

    @NotNull
    public EquivalenceDescriptorBuilder childrenOptionally(@Nullable PsiElement element) {
        EquivalenceDescriptorBuilder equivalenceDescriptorBuilder = this.add(SingleChildDescriptor.MyType.CHILDREN_OPTIONALLY, element);
        if (equivalenceDescriptorBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/equivalence/EquivalenceDescriptorBuilder", "childrenOptionally"));
        }
        return equivalenceDescriptorBuilder;
    }

    @NotNull
    public EquivalenceDescriptorBuilder childrenOptionallyInPattern(@Nullable PsiElement element) {
        EquivalenceDescriptorBuilder equivalenceDescriptorBuilder = this.add(SingleChildDescriptor.MyType.CHILDREN_OPTIONALLY_IN_PATTERN, element);
        if (equivalenceDescriptorBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/equivalence/EquivalenceDescriptorBuilder", "childrenOptionallyInPattern"));
        }
        return equivalenceDescriptorBuilder;
    }

    @NotNull
    public EquivalenceDescriptorBuilder inAnyOrder(PsiElement[] elements) {
        EquivalenceDescriptorBuilder equivalenceDescriptorBuilder = this.add(MultiChildDescriptor.MyType.IN_ANY_ORDER, elements);
        if (equivalenceDescriptorBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/equivalence/EquivalenceDescriptorBuilder", "inAnyOrder"));
        }
        return equivalenceDescriptorBuilder;
    }

    @NotNull
    public EquivalenceDescriptorBuilder childrenInAnyOrder(@Nullable PsiElement element) {
        EquivalenceDescriptorBuilder equivalenceDescriptorBuilder = this.add(SingleChildDescriptor.MyType.CHILDREN_IN_ANY_ORDER, element);
        if (equivalenceDescriptorBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/equivalence/EquivalenceDescriptorBuilder", "childrenInAnyOrder"));
        }
        return equivalenceDescriptorBuilder;
    }

    @NotNull
    public EquivalenceDescriptorBuilder constant(@Nullable Object constant) {
        this.myConstants.add(constant);
        EquivalenceDescriptorBuilder equivalenceDescriptorBuilder = this;
        if (equivalenceDescriptorBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/equivalence/EquivalenceDescriptorBuilder", "constant"));
        }
        return equivalenceDescriptorBuilder;
    }

    private EquivalenceDescriptorBuilder add(MultiChildDescriptor.MyType type2, PsiElement[] elements) {
        this.myMultiChildDescriptors.add(new MultiChildDescriptor(type2, elements));
        return this;
    }

    private EquivalenceDescriptorBuilder add(SingleChildDescriptor.MyType type2, PsiElement element) {
        this.mySingleChildDescriptors.add(new SingleChildDescriptor(type2, element));
        return this;
    }
}

