/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="branch-storage")
public class BranchStorage {
    @Property(surroundWithTag=false)
    @MapAnnotation(keyAttributeName="type")
    @NotNull
    public Map<String, List<DvcsBranchInfo>> myBranches = ContainerUtil.newHashMap();

    public boolean contains(@NotNull String typeName, @Nullable Repository repository, @NotNull String branchName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/dvcs/branch/BranchStorage", "contains"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "com/intellij/dvcs/branch/BranchStorage", "contains"));
        }
        List<DvcsBranchInfo> branches = this.myBranches.get(typeName);
        return branches != null && DvcsBranchUtil.find(branches, repository, branchName) != null;
    }

    public void add(@NotNull String typeName, @Nullable Repository repository, @NotNull String branchName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/dvcs/branch/BranchStorage", "add"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "com/intellij/dvcs/branch/BranchStorage", "add"));
        }
        if (this.contains(typeName, repository, branchName)) {
            return;
        }
        List branchInfos = this.myBranches.computeIfAbsent(typeName, name2 -> ContainerUtil.newArrayList());
        branchInfos.add(new DvcsBranchInfo(DvcsBranchUtil.getPathFor(repository), branchName));
    }

    public void remove(@NotNull String typeName, @Nullable Repository repository, @NotNull String branchName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/dvcs/branch/BranchStorage", "remove"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "com/intellij/dvcs/branch/BranchStorage", "remove"));
        }
        List<DvcsBranchInfo> branches = this.myBranches.get(typeName);
        DvcsBranchInfo toDelete = DvcsBranchUtil.find(branches, repository, branchName);
        if (toDelete != null) {
            branches.remove(toDelete);
            if (branches.isEmpty()) {
                this.myBranches.remove(typeName);
            }
        }
    }
}

