/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.branch.BranchType;
import com.intellij.dvcs.branch.DvcsBranchSettings;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsBranchManager {
    @NotNull
    private final DvcsBranchSettings myBranchSettings;
    @NotNull
    private final Map<BranchType, Collection<String>> myPredefinedFavoriteBranches;

    protected DvcsBranchManager(@NotNull DvcsBranchSettings settings, @NotNull BranchType[] branchTypes) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/dvcs/branch/DvcsBranchManager", "<init>"));
        }
        if (branchTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchTypes", "com/intellij/dvcs/branch/DvcsBranchManager", "<init>"));
        }
        this.myPredefinedFavoriteBranches = ContainerUtil.newHashMap();
        this.myBranchSettings = settings;
        for (BranchType type2 : branchTypes) {
            String defaultBranchName = this.getDefaultBranchName(type2);
            if (StringUtil.isEmptyOrSpaces((String)defaultBranchName)) continue;
            this.myPredefinedFavoriteBranches.put(type2, Collections.singleton(defaultBranchName));
        }
    }

    @Nullable
    protected String getDefaultBranchName(@NotNull BranchType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dvcs/branch/DvcsBranchManager", "getDefaultBranchName"));
        }
        return null;
    }

    public boolean isFavorite(@Nullable BranchType branchType, @Nullable Repository repository, @NotNull String branchName) {
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "com/intellij/dvcs/branch/DvcsBranchManager", "isFavorite"));
        }
        if (branchType == null) {
            return false;
        }
        String branchTypeName = branchType.getName();
        if (this.myBranchSettings.getFavorites().contains(branchTypeName, repository, branchName)) {
            return true;
        }
        if (this.myBranchSettings.getExcludedFavorites().contains(branchTypeName, repository, branchName)) {
            return false;
        }
        return this.isPredefinedAsFavorite(branchType, branchName);
    }

    private boolean isPredefinedAsFavorite(@NotNull BranchType type2, @NotNull String branchName) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dvcs/branch/DvcsBranchManager", "isPredefinedAsFavorite"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "com/intellij/dvcs/branch/DvcsBranchManager", "isPredefinedAsFavorite"));
        }
        Collection<String> predefinedNames = this.myPredefinedFavoriteBranches.get(type2);
        return predefinedNames != null && predefinedNames.contains(branchName);
    }

    public void setFavorite(@Nullable BranchType branchType, @Nullable Repository repository, @NotNull String branchName, boolean shouldBeFavorite) {
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "com/intellij/dvcs/branch/DvcsBranchManager", "setFavorite"));
        }
        if (branchType == null) {
            return;
        }
        String branchTypeName = branchType.getName();
        if (shouldBeFavorite) {
            this.myBranchSettings.getExcludedFavorites().remove(branchTypeName, repository, branchName);
            if (!this.isPredefinedAsFavorite(branchType, branchName)) {
                this.myBranchSettings.getFavorites().add(branchTypeName, repository, branchName);
            }
        } else {
            this.myBranchSettings.getFavorites().remove(branchTypeName, repository, branchName);
            if (this.isPredefinedAsFavorite(branchType, branchName)) {
                this.myBranchSettings.getExcludedFavorites().add(branchTypeName, repository, branchName);
            }
        }
    }
}

