/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DvcsBranchUtil {
    @Nullable
    public static <T extends DvcsBranchInfo> T find(@Nullable Collection<T> branches, @Nullable Repository repository, @NotNull String sourceBranch) {
        if (sourceBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceBranch", "com/intellij/dvcs/branch/DvcsBranchUtil", "find"));
        }
        if (branches == null) {
            return null;
        }
        return (T)((DvcsBranchInfo)ContainerUtil.find(branches, targetInfo -> {
            if (sourceBranch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceBranch", "com/intellij/dvcs/branch/DvcsBranchUtil", "lambda$find$0"));
            }
            return DvcsBranchUtil.repoAndSourceAreEqual(repository, sourceBranch, targetInfo);
        }));
    }

    private static boolean repoAndSourceAreEqual(@Nullable Repository repository, @NotNull String sourceBranch, @NotNull DvcsBranchInfo targetInfo) {
        if (sourceBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceBranch", "com/intellij/dvcs/branch/DvcsBranchUtil", "repoAndSourceAreEqual"));
        }
        if (targetInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetInfo", "com/intellij/dvcs/branch/DvcsBranchUtil", "repoAndSourceAreEqual"));
        }
        return DvcsBranchUtil.getPathFor(repository).equals(targetInfo.repoPath) && StringUtil.equals((CharSequence)targetInfo.sourceName, (CharSequence)sourceBranch);
    }

    @NotNull
    public static String getPathFor(@Nullable Repository repository) {
        String string = repository == null ? "" : repository.getRoot().getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/branch/DvcsBranchUtil", "getPathFor"));
        }
        return string;
    }
}

